/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.BaseVirtualPrinterDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class VirtualPrinterDAO
extends BaseVirtualPrinterDAO {
    private static final String EMPTY_STRING = "";
    private static final String EMPTY_DOT_STRING = ".";
    private static final String EMPTY_NEWLINE_STRING = "\n";
    private static final String EMPTY_SPACE_STRING = " ";

    @Override
    protected Serializable save(Object obj, Session s) {
        this.updateTime(obj);
        return super.save(obj, s);
    }

    @Override
    protected void update(Object obj, Session s) {
        this.updateTime(obj);
        super.update(obj, s);
    }

    @Override
    protected void delete(Object obj, Session s) {
        if (obj instanceof VirtualPrinter) {
            VirtualPrinter virtualPrinter = (VirtualPrinter)obj;
            List<PrinterGroup> printerGroups = PrinterGroupDAO.getInstance().getPrinterGroupsByVirtualPrinter(virtualPrinter, s);
            if (printerGroups != null && !printerGroups.isEmpty()) {
                String message = virtualPrinter.getName() + EMPTY_SPACE_STRING + Messages.getString("VirtualPrinterDAO.0");
                String details = this.constructExceptionDetailsByPrinterGroups(virtualPrinter, printerGroups);
                throw new PosException(message, details);
            }
            virtualPrinter.setDeleted(Boolean.TRUE);
            super.update(virtualPrinter, s);
            this.deleteTerminalPrinters(virtualPrinter, s);
        } else {
            super.delete(obj, s);
        }
    }

    private void deleteTerminalPrinters(VirtualPrinter virtualPrinter, Session session) {
        String hql = "DELETE FROM %s TP WHERE TP.%s = :printer";
        hql = String.format(hql, TerminalPrinters.REF, TerminalPrinters.PROP_VIRTUAL_PRINTER);
        Query query = session.createQuery(hql);
        query.setParameter("printer", (Object)virtualPrinter);
        query.executeUpdate();
    }

    private String constructExceptionDetailsByPrinterGroups(VirtualPrinter virtualPrinter, List<PrinterGroup> printerGroups) {
        if (printerGroups != null && !printerGroups.isEmpty()) {
            StringBuilder builder = new StringBuilder(virtualPrinter.getName() + EMPTY_SPACE_STRING + Messages.getString("VirtualPrinterDAO.3"));
            for (int i = 0; i < printerGroups.size(); ++i) {
                String message = i + 1 + EMPTY_DOT_STRING + EMPTY_SPACE_STRING + printerGroups.get(i).getName();
                builder.append(EMPTY_NEWLINE_STRING).append(message);
            }
            return builder.toString();
        }
        return EMPTY_STRING;
    }

    @Override
    protected void saveOrUpdate(Object obj, Session s) {
        this.updateTime(obj);
        super.saveOrUpdate(obj, s);
    }

    @Override
    public List<VirtualPrinter> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    public void saveOrUpdateVirtualPrinter(List<VirtualPrinter> virtualPrinterList, boolean updateLastUpdateTime, boolean updateSyncTime) throws Exception {
        if (virtualPrinterList == null) {
            return;
        }
        Transaction tx = null;
        try (Session session = this.createNewSession();){
            tx = session.beginTransaction();
            for (VirtualPrinter item : virtualPrinterList) {
                VirtualPrinter existingItem = this.get(item.getId());
                if (existingItem != null) {
                    if (!BaseDataServiceDao.get().shouldSave(item.getLastUpdateTime(), existingItem.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), item.getName() + " already updated");
                        continue;
                    }
                    long version = existingItem.getVersion();
                    PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                    existingItem.setVersion(version);
                    existingItem.setUpdateLastUpdateTime(updateLastUpdateTime);
                    existingItem.setUpdateSyncTime(updateSyncTime);
                    this.update(existingItem);
                    continue;
                }
                item.setVersion(0L);
                item.setUpdateLastUpdateTime(updateLastUpdateTime);
                item.setUpdateSyncTime(updateSyncTime);
                this.save(item);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
    }

    public VirtualPrinter findPrinterByName(String name) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)VirtualPrinter.PROP_NAME, (Object)name));
            VirtualPrinter virtualPrinter = (VirtualPrinter)criteria.uniqueResult();
            return virtualPrinter;
        }
    }

    public List<VirtualPrinter> findKitchenPrinters() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)VirtualPrinter.PROP_TYPE, (Object)2));
            List list = criteria.list();
            return list;
        }
    }
}

