/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao.util;

import com.floreantpos.PosLog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.MemberType;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.util.PosCacheManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class ForeteesCacheManager
extends PosCacheManager {
    private Map<String, TaxGroup> taxGroupMapBytype = new HashMap<String, TaxGroup>();

    @Override
    public InventoryLocation getInventoryLocationById(String inventoryLocationId) {
        if (StringUtils.isBlank((String)inventoryLocationId)) {
            return null;
        }
        InventoryLocation inventoryLocation = super.getInventoryLocationById(inventoryLocationId);
        if (inventoryLocation == null) {
            InventoryLocation il = new InventoryLocation();
            il.setId(inventoryLocationId);
            il.setName(inventoryLocationId);
            il.setDeleted(true);
            il.setRoot(true);
            InventoryLocationDAO.getInstance().save(il);
            return il;
        }
        return inventoryLocation;
    }

    @Override
    protected void loadTaxGroups() {
        List<TaxGroup> dataList = TaxGroupDAO.getInstance().findAll();
        this.clear(this.taxGroupMap);
        if (dataList != null && dataList.size() > 0) {
            for (TaxGroup obj : dataList) {
                this.taxGroupMap.put(obj.getId(), obj);
            }
        }
        this.clear(this.taxGroupMapBytype);
        if (dataList != null && dataList.size() > 0) {
            for (TaxGroup taxGroup : dataList) {
                String key = "";
                if (StringUtils.isNotEmpty((String)taxGroup.getType())) {
                    key = key + taxGroup.getType();
                }
                if (StringUtils.isNotEmpty((String)taxGroup.getSubType())) {
                    key = key + "_" + taxGroup.getSubType();
                }
                if (StringUtils.isNotEmpty((String)taxGroup.getBillingRecordType())) {
                    key = key + "_" + taxGroup.getBillingRecordType();
                }
                if (!StringUtils.isNotEmpty((String)(key = key.replaceAll("[^\\p{Alnum}]", "_")))) continue;
                this.taxGroupMapBytype.put(key, taxGroup);
            }
        }
    }

    public TaxGroup findTaxGroup(MenuItem menuItem, Customer customer) {
        if (menuItem == null) {
            return null;
        }
        String searchKey = "";
        String searchKeyWithoutMember = "";
        if (StringUtils.isNotEmpty((String)menuItem.getCmsTypeName())) {
            searchKey = searchKey + menuItem.getCmsTypeName();
        }
        if (StringUtils.isNotEmpty((String)menuItem.getCmsSubTypeName())) {
            searchKey = searchKey + "_" + menuItem.getCmsSubTypeName();
        }
        searchKeyWithoutMember = searchKey;
        searchKey = customer != null && StringUtils.isNotEmpty((String)customer.getMemberTypeName()) ? searchKey + "_" + customer.getMemberTypeName() : searchKey + "_" + MemberType.MEMBER.getName();
        TaxGroup taxGroup = this.taxGroupMapBytype.get(searchKey = searchKey.replaceAll("[^\\p{Alnum}]", "_"));
        if (taxGroup == null) {
            searchKeyWithoutMember = searchKeyWithoutMember.replaceAll("[^\\p{Alnum}]", "_");
            taxGroup = this.taxGroupMapBytype.get(searchKeyWithoutMember);
        }
        this.logResult(searchKey, searchKeyWithoutMember, taxGroup);
        return taxGroup;
    }

    private void logResult(String searchKey, String searchKeyWithoutMember, TaxGroup taxGroup) {
        if (taxGroup != null) {
            String message = "Search key: " + searchKey + ", Tax Group: " + taxGroup;
            PosLog.debug(this.getClass(), message);
        } else {
            String message = "No tax group found for Search key: " + searchKey;
            PosLog.debug(this.getClass(), message);
        }
    }

    public Map<String, TaxGroup> getTaxGroupMapBytype() {
        return this.taxGroupMapBytype;
    }

    public void setTaxGroupMapBytype(Map<String, TaxGroup> taxGroupMapBytype) {
        this.taxGroupMapBytype = taxGroupMapBytype;
    }
}

