/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.ext;

import com.floreantpos.Messages;
import java.util.regex.Pattern;
import us.fatehi.creditcardnumber.CardBrand;

public enum CardTypeEnum {
    VISA(Messages.getString("CardTypeEnum.0"), "^4[0-9]{6,}$"),
    MASTER_CARD(Messages.getString("CardTypeEnum.1"), "^5[1-5][0-9]{5,}$|^(222[1-9]|2[3-6][0-9][0-9]|27[0-1][0-9]|2720)[0-9]{12}$"),
    AMERICAN_EXPRESS(Messages.getString("CardTypeEnum.2"), "^3[47][0-9]{5,}$"),
    DISCOVER(Messages.getString("CardTypeEnum.3"), "^6(?:011|5[0-9]{2})[0-9]{3,}$"),
    UnionPay(Messages.getString("CardTypeEnum.6"), "^62[0-9]{14,}$"),
    DINERS_CLUB(Messages.getString("CardTypeEnum.5"), "^3(?:0[0-5]|[68][0-9])[0-9]{4,}$"),
    Maestro(Messages.getString("CardTypeEnum.8"), "^(6759|5018|5020|5038|5893|6304|6759|6761|6762|6763)[0-9]{8,15}$"),
    JCB(Messages.getString("CardTypeEnum.4"), "^(?:2131|1800|35[0-9]{3})[0-9]{3,}$"),
    UATP(Messages.getString("CardTypeEnum.10"), "^1[0-9]{14}$");

    private final String value;
    private Pattern pattern;

    private CardTypeEnum(String v) {
        this(v, "");
    }

    private CardTypeEnum(String v, String pattern) {
        this.value = v;
        this.pattern = Pattern.compile(pattern);
    }

    public String value() {
        return this.value;
    }

    public static CardTypeEnum fromValue(String v) {
        for (CardTypeEnum c : CardTypeEnum.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public static CardTypeEnum detect(String cardNumber) {
        for (CardTypeEnum cardType : CardTypeEnum.values()) {
            if (null == cardType.pattern || !cardType.pattern.matcher(cardNumber).matches()) continue;
            return cardType;
        }
        return null;
    }

    public static CardTypeEnum fromCardBrand(CardBrand cardBrand) {
        switch (cardBrand) {
            case Visa: {
                return VISA;
            }
            case MasterCard: {
                return MASTER_CARD;
            }
            case AmericanExpress: {
                return AMERICAN_EXPRESS;
            }
            case DinersClub: {
                return DINERS_CLUB;
            }
            case Discover: {
                return DISCOVER;
            }
            case JCB: {
                return JCB;
            }
            case Maestro: {
                return Maestro;
            }
            case UATP: {
                return UATP;
            }
            case UnionPay: {
                return UnionPay;
            }
            case Unknown: {
                return null;
            }
        }
        return null;
    }
}

