/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment;

import com.floreantpos.CustomerSelectionChangeException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.CreditBookType;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CreditBookDAO;
import com.floreantpos.model.dao.CreditBookTypeDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.payment.AbstractPaymentPlugin;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.ui.views.payment.creditbook.CBTBtnwiseSelectionDialog;
import com.floreantpos.ui.views.payment.creditbook.CreditBookTypesSelectionDialog;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.hibernate.Session;
import org.hibernate.Transaction;

@PluginImplementation
public class CreditBookPaymentPlugin
extends AbstractPaymentPlugin
implements PostPaymentProcessor {
    private static final String CREDIT_BOOK = "CREDIT BOOK";
    private SettleTicketProcessor settleTicketProcessor;

    public String getName() {
        return CREDIT_BOOK;
    }

    public void pay(Ticket ticket, double tenderAmount, SettleTicketProcessor settleTicketProcessor) throws Exception {
        this.settleTicketProcessor = settleTicketProcessor;
        Customer member = this.doSetMember(ticket);
        OrderType orderType = ticket.getOrderType();
        List<CreditBookType> creditBookTypes = CreditBookTypeDAO.getInstance().getSFCreditBookTypesForMember(member.getId(), orderType);
        if (creditBookTypes == null || creditBookTypes.isEmpty()) {
            throw new PosException(Messages.getString("CreditBookPaymentPlugin.1"));
        }
        CreditBookTypesSelectionDialog dialog = new CreditBookTypesSelectionDialog(member, creditBookTypes);
        dialog.setDefaultCloseOperation(2);
        dialog.setSize(PosUIManager.getSize(700, 500));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        CreditBookType creditBookType = dialog.getSelectedCreditBookType();
        double sfCreditBooksBalance = creditBookType.getMemberBalance();
        if (NumberUtil.isZero(sfCreditBooksBalance)) {
            throw new PosException(Messages.getString("CreditBookPaymentPlugin.3"));
        }
        CustomPaymentTransaction transaction = (CustomPaymentTransaction)PaymentType.CREDIT_BOOK.createTransaction(ticket, tenderAmount);
        transaction.setCustomPaymentFieldName("CREDIT_BOOK_TYPE_ID");
        transaction.setCustomPaymentRef(creditBookType.getId());
        if (sfCreditBooksBalance < ticket.getDueAmount()) {
            transaction.setTenderAmount(sfCreditBooksBalance);
            transaction.setAmount(sfCreditBooksBalance);
        }
        settleTicketProcessor.settleTicket(transaction, this);
    }

    private Customer doSetMember(Ticket ticket) {
        Customer member = ticket.getCustomer();
        if (member == null) {
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(ticket.getOrderType());
            dialog.setCreateNewTicket(false);
            if (ticket != null) {
                dialog.setTicket(ticket);
            }
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                throw new PosException(Messages.getString("CreditBookPaymentPlugin.5"));
            }
            member = dialog.getSelectedCustomer();
            if (member == null) {
                throw new PosException(Messages.getString("CreditBookPaymentPlugin.5"));
            }
            ticket.setCustomer(member);
            OrderController.saveOrder(ticket);
            this.settleTicketProcessor.doInformListenerPaymentUpdate();
            throw new CustomerSelectionChangeException(POSConstants.CUSTOMER + " " + member.getName() + " " + Messages.getString("PaymentView.57"));
        }
        return member;
    }

    public String getId() {
        return CREDIT_BOOK;
    }

    @Override
    public void paymentDone(PosTransaction transaction, Session session) {
    }

    public Double doRefund(Ticket ticket, List<PosTransaction> selectedTransactions) throws Exception {
        Transaction tx = null;
        try (Session session = null;){
            Customer member = this.doSetMember(ticket);
            OrderType orderType = ticket.getOrderType();
            List<CreditBookType> creditBookTypes = CreditBookTypeDAO.getInstance().getSFCreditBookTypesForMember(member.getId(), orderType);
            if (creditBookTypes == null || creditBookTypes.isEmpty()) {
                throw new PosException(Messages.getString("CreditBookPaymentPlugin.7"));
            }
            CBTBtnwiseSelectionDialog dialog = new CBTBtnwiseSelectionDialog(member, creditBookTypes);
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(700, 500));
            dialog.open();
            if (dialog.isCanceled()) {
                Double d = null;
                return d;
            }
            CreditBookType creditBookType = dialog.getSelectedCreditBooktype();
            double refundableAmount = this.getRefundableAmount(ticket);
            double refundAmount = NumberSelectionDialog2.takeDoubleInput(Messages.getString("CreditBookPaymentPlugin.9"), refundableAmount);
            if (refundAmount <= 0.0) {
                throw new PosException(Messages.getString("CreditBookPaymentPlugin.10"));
            }
            if (refundAmount > refundableAmount) {
                throw new PosException(Messages.getString("CreditBookPaymentPlugin.11") + NumberUtil.round(refundableAmount));
            }
            double totalTransactionTaxAmount = this.calculateTaxAmount(ticket);
            Double refundTaxAmount = NumberUtil.roundToTwoDigit(totalTransactionTaxAmount * refundAmount / ticket.getPaidAmount());
            session = CreditBookDAO.getInstance().createNewSession();
            tx = session.beginTransaction();
            PosTransactionService transactionService = PosTransactionService.getInstance();
            RefundTransaction refundTransaction = transactionService.createRefundTransaction(ticket, null, refundAmount, true);
            refundTransaction.setPaymentType(PaymentType.CREDIT_BOOK);
            refundTransaction.setCustomPaymentFieldName("CREDIT BOOK ID");
            refundTransaction.setCustomPaymentRef(creditBookType.getId());
            User currentUser = Application.getCurrentUser();
            refundTransaction.setCustomerId(ticket.getCustomerId());
            refundTransaction.setUser(ticket.getOwner());
            double refundedAmount = transactionService.refundTicket(ticket, refundTransaction, refundAmount, refundTaxAmount, currentUser, session);
            if (ticket.getCustomer() == null) {
                ticket.setCustomer(member);
                TicketDAO.getInstance().update(ticket, session);
            }
            tx.commit();
            Double d = refundedAmount;
            return d;
        }
    }

    public void voidPayment(PosTransaction transaction, Session session) {
    }

    public String getProductName() {
        return this.getName();
    }
}

