/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.CardReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PanelTester;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class CreditCardReportView
extends JPanel {
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private MultiSelectComboBox<OrderType> cbMultiOrderType;
    private List<OrderType> enabledOrderTypeListForUser;
    private JButton btnGo = new JButton(POSConstants.GO);
    private JPanel reportContainer;
    private JCheckBox chkCreditCard;
    private JCheckBox chkGroupByCardType;
    private JCheckBox chkPromotion;
    private JCheckBox chkMemberAccount;

    public CreditCardReportView() {
        super(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        this.cbMultiOrderType = new MultiSelectComboBox();
        User user = POSUtil.getBackOfficeWindow().getCurrentUser();
        UserDAO.getInstance().refresh(user);
        this.enabledOrderTypeListForUser = user.getPropOrderTypes();
        if (this.enabledOrderTypeListForUser.isEmpty()) {
            this.enabledOrderTypeListForUser = OrderTypeDAO.getInstance().findAllForReport(false);
        }
        this.cbMultiOrderType.setItems(this.enabledOrderTypeListForUser);
        this.chkCreditCard = new JCheckBox(Messages.getString("CreditCardReportView.1"));
        this.chkCreditCard.setSelected(Boolean.TRUE);
        this.chkGroupByCardType = new JCheckBox(Messages.getString("CreditCardReportView.3"));
        this.chkGroupByCardType.setSelected(Boolean.TRUE);
        this.chkPromotion = new JCheckBox(Messages.getString("CreditCardReportView.4"));
        this.chkMemberAccount = new JCheckBox(Messages.getString("CreditCardReportView.5"));
        this.chkCreditCard.addActionListener(e -> this.stateChangedOnchkCreditCard());
        topPanel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add((Component)new JLabel(POSConstants.TO + ":"), "grow");
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)new JLabel(Messages.getString("ReportViewer.1") + ":"), "grow");
        topPanel.add(this.cbMultiOrderType);
        topPanel.add(this.chkCreditCard);
        topPanel.add(this.chkGroupByCardType);
        topPanel.add(this.chkPromotion);
        topPanel.add(this.chkMemberAccount);
        topPanel.add((Component)this.btnGo, "skip 1, al right");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportContainer = new JPanel(new BorderLayout());
        centerPanel.add(this.reportContainer);
        this.add(centerPanel);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CreditCardReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(CreditCardReportView.this, POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
    }

    private void stateChangedOnchkCreditCard() {
        if (!this.chkCreditCard.isSelected()) {
            this.chkGroupByCardType.setSelected(Boolean.FALSE);
        }
        this.chkGroupByCardType.setEnabled(this.chkCreditCard.isSelected());
    }

    private void viewReport() throws Exception {
        Object[] transactionTypes;
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        User user = POSUtil.getBackOfficeWindow().getCurrentUser();
        List<OrderType> selectedOrdertypes = this.cbMultiOrderType.getSelectedItems() == null ? user.getPropOrderTypes() : this.cbMultiOrderType.getSelectedItems();
        List<String> orderTypeIds = POSUtil.getStringIds(selectedOrdertypes, OrderType.class);
        fromDate = DateUtil.startOfDay(fromDate);
        toDate = DateUtil.endOfDay(toDate);
        boolean isCreditCard = this.chkCreditCard.isSelected();
        boolean isMemberAccount = this.chkMemberAccount.isSelected();
        boolean isPromotion = this.chkPromotion.isSelected();
        boolean isGroupByCardType = this.chkGroupByCardType.isSelected();
        int saleCount = 0;
        double totalSales = 0.0;
        double totalTips = 0.0;
        ArrayList<PosTransaction> newTransactionList = new ArrayList<PosTransaction>();
        ArrayList<Class> transactionTypeList = new ArrayList<Class>();
        if (!(isCreditCard || isMemberAccount || isPromotion)) {
            transactionTypeList.add(CreditCardTransaction.class);
            transactionTypeList.add(CustomerAccountTransaction.class);
            transactionTypeList.add(CustomPaymentTransaction.class);
            transactionTypeList.add(DebitCardTransaction.class);
        } else {
            if (isCreditCard) {
                transactionTypeList.add(CreditCardTransaction.class);
                transactionTypeList.add(DebitCardTransaction.class);
            }
            if (isMemberAccount) {
                transactionTypeList.add(CustomerAccountTransaction.class);
            }
            if (isPromotion) {
                transactionTypeList.add(CustomPaymentTransaction.class);
            }
        }
        for (Object object : transactionTypes = transactionTypeList.toArray()) {
            Class class1 = (Class)object;
            List<? extends PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactions(null, class1, fromDate, toDate, orderTypeIds);
            if (class1.getSimpleName().equals(CreditCardTransaction.REF) && isGroupByCardType) {
                Comparator<PosTransaction> comparator = Comparator.comparing(BasePosTransaction::getCardType, Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER));
                transactions.sort(comparator);
            }
            for (PosTransaction posTransaction : transactions) {
                ++saleCount;
                totalSales += posTransaction.getAmount().doubleValue();
                totalTips += posTransaction.getTipsAmount().doubleValue();
                posTransaction.setClassType(class1.getSimpleName());
                newTransactionList.add(posTransaction);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map);
        ReportUtil.populateReportTime(map, fromDate, toDate);
        ReportUtil.populateReportFooter(map);
        map.put("orderType", ReportUtil.reportLabelWithBoldTag(POSConstants.ORDER_TYPE) + ": " + CreditCardReportView.createOrderTypeString(selectedOrdertypes));
        this.populateReportParams(map);
        map.put("reportTitle", Messages.getString("CreditCardReportView.0"));
        map.put("saleCount", String.valueOf(saleCount));
        map.put("totalSales", NumberUtil.formatNumber(totalSales - totalTips));
        map.put("totalTips", NumberUtil.formatNumber(totalTips));
        map.put("total", NumberUtil.formatNumber(totalSales));
        map.put("isGroupByCardType", isGroupByCardType);
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("credit-card-report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)new CardReportModel(newTransactionList)));
        JRViewer viewer = ReportUtil.getCustomJRViewer(jasperPrint);
        this.reportContainer.removeAll();
        this.reportContainer.add((Component)viewer);
        this.reportContainer.revalidate();
    }

    private static String createOrderTypeString(List<OrderType> selectedOrdertypes) {
        if (selectedOrdertypes == null || selectedOrdertypes.isEmpty()) {
            return POSConstants.ALL;
        }
        String orderTypeNames = "";
        Iterator<OrderType> iterator = selectedOrdertypes.iterator();
        while (iterator.hasNext()) {
            OrderType orderType = iterator.next();
            orderTypeNames = orderTypeNames + orderType.getName();
            if (!iterator.hasNext()) continue;
            orderTypeNames = orderTypeNames + ", ";
        }
        return orderTypeNames;
    }

    private void populateReportParams(HashMap map) {
        map.put("colTicketNo", Messages.getString("TicketNo"));
        map.put("colPaymentType", Messages.getString("SettleTicketDialog.9"));
        map.put("colCardType", Messages.getString("TransactionListView.3"));
        map.put("colMember", Messages.getString("MEMBER"));
        map.put("colDate", POSConstants.DATE);
        map.put("colServer", POSConstants.SERVER);
        map.put("colAuthC", Messages.getString("AuthCode"));
        map.put("tips", Messages.getString("CreditCardReportView.2") + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("totalHeader", Messages.getString("CreditCardReportView.6") + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("rowTSCount", Messages.getString("TSCount"));
        map.put("rowTSales", Messages.getString("TotalSales"));
        map.put("rowTTips", Messages.getString("TotalTips"));
        map.put("rowTotal", POSConstants.TOTAL);
        map.put("colPaymentTypeGroupHeader", Messages.getString("CreditCardReportView.7"));
        map.put("colCardTypeGroupHeader", Messages.getString("CreditCardReportView.8"));
        map.put("colPaymentTypeGroupTotal", Messages.getString("CreditCardReportView.9"));
        map.put("colCardTypeGroupTotal", Messages.getString("CreditCardReportView.10"));
    }

    public static void main(String[] args) {
        PanelTester.width = 800;
        PanelTester.height = 500;
        PanelTester.test(new CreditCardReportView());
    }
}

