/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.report.DiscountData;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;

public class DiscountReportDataModel
extends ListTableModel {
    public DiscountReportDataModel() {
        this.setColumnNames(new String[]{"itemName", "ticketId", "date", "server", "discount", "totalWithDiscount"});
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        DiscountData data = (DiscountData)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return data.getItemName();
            }
            case 1: {
                return data.getTicketId();
            }
            case 2: {
                return data.getFormattedDate();
            }
            case 3: {
                return data.getServerName();
            }
            case 4: {
                return NumberUtil.formatNumber(data.getDiscount());
            }
            case 5: {
                return NumberUtil.formatNumber(data.getTotalWithDiscount());
            }
        }
        return null;
    }

    public void addDiscountDataList(List<DiscountData> itemDiscounts) {
        if (itemDiscounts == null || itemDiscounts.isEmpty()) {
            return;
        }
        if (this.getRows() == null) {
            this.setRows(new ArrayList());
        }
        this.getRows().addAll(itemDiscounts);
    }
}

