/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.EndOfDaySummaryReportModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class EndOfDaySummaryReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;
    private MultiSelectComboBox<OrderType> cbOrderTypes;
    private JCheckBox chkMemberName;
    private JCheckBox chkTicketNumber;
    private JCheckBox chkTicketDate;
    private JCheckBox chkShowGroup;
    private JCheckBox chkLastName;
    private JCheckBox chkMemberId;
    private JCheckBox chkConsolidate;

    public EndOfDaySummaryReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        PosLog.debug(this.getClass(), String.format("End of day report, start: %s end: %s", fromDate, toDate));
        List<OrderType> orderTypes = this.cbOrderTypes.getSelectedItems();
        if (orderTypes == null) {
            User user = POSUtil.getBackOfficeWindow().getCurrentUser();
            orderTypes = user.getPropOrderTypes();
        }
        boolean sortByMemberName = this.chkMemberName.isSelected();
        boolean sortByTicketNumber = this.chkTicketNumber.isSelected();
        boolean sortByTicketDate = this.chkTicketDate.isSelected();
        boolean sortByLastName = this.chkLastName.isSelected();
        boolean sortByMemberId = this.chkMemberId.isSelected();
        List<EndOfDayReportData> transactionList = PosTransactionDAO.getInstance().findEndOfDayReportData(fromDate, toDate, orderTypes, sortByMemberName, sortByTicketNumber, sortByTicketDate, sortByLastName, sortByMemberId, !this.chkShowGroup.isSelected());
        PosLog.debug(this.getClass(), String.format("Found %s tickets", transactionList.size()));
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("end_of_day_summary_report"));
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties, orderTypes);
        EndOfDaySummaryReportModel reportModel = new EndOfDaySummaryReportModel();
        reportModel.setRows(transactionList);
        properties.put("ticketCount", ReportUtil.reportLabelWithBoldTag(Messages.getString("EndOfDaySummaryReportView.7") + ": ") + transactionList.size());
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private String createIdString(List<OrderType> selectedOrderTypes) {
        if (selectedOrderTypes == null || selectedOrderTypes.isEmpty()) {
            return POSConstants.ALL;
        }
        String orderTypeNames = "";
        Iterator<OrderType> iterator = selectedOrderTypes.iterator();
        while (iterator.hasNext()) {
            OrderType orderType = iterator.next();
            orderTypeNames = orderTypeNames + orderType.getName();
            if (!iterator.hasNext()) continue;
            orderTypeNames = orderTypeNames + ", ";
        }
        return orderTypeNames;
    }

    private void populateReportParams(HashMap<String, Object> properties, List<OrderType> selectedOrderTypes) {
        String orderTypeName = this.createIdString(selectedOrderTypes);
        properties.put("reportTitle", Messages.getString("EndOfDaySummaryReport"));
        properties.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("orderType", ReportUtil.reportLabelWithBoldTag(Messages.getString("colOrderType") + ": ") + orderTypeName);
        properties.put("colMName", Messages.getString("MEMBER"));
        properties.put("colTID", POSConstants.TICKET_ID);
        properties.put("colTAmount", POSConstants.TICKET + " " + POSConstants.AMOUNT.toLowerCase());
        properties.put("colSC", POSConstants.S_C);
        properties.put("colTips", Messages.getString("GRATUITY"));
        properties.put("colTax", POSConstants.TAX);
        properties.put("colTotal", POSConstants.TOTAL);
        properties.put("colMCharge", Messages.getString("MEMBER") + "<br/>" + Messages.getString("CHARGE"));
        properties.put("colCCard", Messages.getString("colCredit") + "<br/>" + Messages.getString("CARD"));
        properties.put("colCPayment", Messages.getString("CashPayment"));
        properties.put("colOthersPymt", Messages.getString("OthersPayment"));
        properties.put("colDiscount", POSConstants.DISCOUNT);
        properties.put("colRefund", Messages.getString("EndOfDaySummaryReportView.3"));
        properties.put("colGuestCount", Messages.getString("EndOfDaySummaryReportView.0"));
        properties.put("colDate", POSConstants.DATE);
        properties.put("roleSubTotal", Messages.getString("EndOfDaySummaryReportView.5"));
        properties.put("colSubtotal", "      " + POSConstants.EMPLOYEE + " " + StringUtils.lowerCase((String)POSConstants.SUBTOTAL) + ": ");
        properties.put("colGrandTotal", "      " + POSConstants.GRAND_TOTAL);
        properties.put("isShowGroup", this.chkShowGroup.isSelected());
        properties.put("isConsolidate", !this.chkConsolidate.isSelected());
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getDeafultDateWithTime();
        this.toDatePicker = UiUtil.getDeafultDateWithTime();
        this.fromDatePicker.setDate(DateUtil.startOfDay(new Date()));
        this.toDatePicker.setDate(DateUtil.endOfDay(new Date()));
        this.chkConsolidate = new JCheckBox(Messages.getString("ReportViewer.9"));
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(e -> {
            try {
                this.viewReport();
            }
            catch (Exception e1) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
            }
        });
        this.cbOrderTypes = new MultiSelectionOverflowCombobox<OrderType>();
        User user = POSUtil.getBackOfficeWindow().getCurrentUser();
        UserDAO.getInstance().refresh(user);
        List<OrderType> propOrderTypes = user.getPropOrderTypes();
        if (propOrderTypes.isEmpty()) {
            propOrderTypes = OrderTypeDAO.getInstance().findAllForReport(false);
        }
        this.cbOrderTypes.setItems(propOrderTypes);
        JLabel lblSortBy = new JLabel(Messages.getString("EndOfDaySummaryReportView.1") + ":");
        this.chkMemberName = new JCheckBox(Messages.getString("EndOfDaySummaryReportView.2"));
        this.chkTicketNumber = new JCheckBox(Messages.getString("EndOfDaySummaryReportView.4"));
        this.chkTicketDate = new JCheckBox(POSConstants.DATE);
        this.chkShowGroup = new JCheckBox(Messages.getString("EndOfDaySummaryReportView.6"));
        this.chkLastName = new JCheckBox(Messages.getString("EndOfDaySummaryReportView.8"));
        this.chkMemberId = new JCheckBox(Messages.getString("EndOfDaySummaryReportView.9"));
        this.chkShowGroup.setSelected(Boolean.TRUE);
        this.setLayout(new BorderLayout());
        TransparentPanel topPanel = new TransparentPanel();
        topPanel.setLayout(new WrapLayout(3, 5, 0));
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        topPanel.add(new JLabel(Messages.getString("TerminalTypeForm.1") + ":"));
        topPanel.add(this.cbOrderTypes);
        JPanel startDatePanel = new JPanel();
        startDatePanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        startDatePanel.add((Component)this.fromDatePicker);
        topPanel.add(startDatePanel);
        JPanel endDatePanel = new JPanel();
        endDatePanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        endDatePanel.add((Component)this.toDatePicker);
        topPanel.add(endDatePanel);
        topPanel.add(lblSortBy);
        topPanel.add(this.chkMemberId);
        topPanel.add(this.chkMemberName);
        topPanel.add(this.chkLastName);
        topPanel.add(this.chkTicketNumber);
        topPanel.add(this.chkTicketDate);
        JPanel groupPannel = new JPanel((LayoutManager)new MigLayout());
        groupPannel.add((Component)new JSeparator(1), "growy");
        groupPannel.add(this.chkShowGroup);
        topPanel.add(groupPannel);
        topPanel.add(this.chkConsolidate);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.chkShowGroup.addActionListener(e -> this.updateUi());
        this.add(centerPanel);
    }

    private void updateUi() {
        if (this.chkShowGroup.isSelected()) {
            this.chkConsolidate.setEnabled(Boolean.TRUE);
        } else {
            this.chkConsolidate.setEnabled(Boolean.FALSE);
            this.chkConsolidate.setSelected(Boolean.FALSE);
        }
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

