/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.HourlySalesReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class HourlySalesReportView
extends TransparentPanel {
    private JButton btnGo;
    private JComboBox cbTerminal;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;
    private JComboBox jcbSalesType;

    public HourlySalesReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Terminal terminal = null;
        if (this.cbTerminal.getSelectedItem() instanceof Terminal) {
            terminal = (Terminal)this.cbTerminal.getSelectedItem();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        TicketDAO ticketDAO = TicketDAO.getInstance();
        AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
        ArrayList<LaborReportData> rows = new ArrayList<LaborReportData>();
        DecimalFormat formatter = new DecimalFormat("00");
        for (int i = 0; i < 24; ++i) {
            List<Ticket> tickets = ticketDAO.findTicketsForLaborHour(fromDate, toDate, i, terminal);
            List<User> users = attendenceHistoryDAO.findNumberOfClockedInUserAtHour(fromDate, toDate, i, terminal);
            double manHour = users.size();
            double totalChecks = 0.0;
            double totalGuests = 0.0;
            double totalSales = 0.0;
            double labor = 0.0;
            double salesPerMHr = 0.0;
            double guestsPerMHr = 0.0;
            double checksPerMHr = 0.0;
            if (tickets == null || tickets.size() <= 0) continue;
            for (Ticket ticket : tickets) {
                totalChecks += 1.0;
                totalGuests += (double)ticket.getNumberOfGuests().intValue();
                if (this.jcbSalesType.getSelectedIndex() == 0) {
                    totalSales += ticket.getSubtotalAmount().doubleValue();
                    continue;
                }
                if (this.jcbSalesType.getSelectedIndex() == 1) {
                    totalSales += ticket.getTotalAmountWithTips().doubleValue();
                    continue;
                }
                if (this.jcbSalesType.getSelectedIndex() != 2) continue;
                totalSales += ticket.getPaidAmount().doubleValue();
            }
            for (User user : users) {
                labor += user.getCostPerHour() == null ? 0.0 : user.getCostPerHour();
            }
            if (manHour > 0.0) {
                labor /= manHour;
                salesPerMHr = totalSales / manHour;
                guestsPerMHr = totalGuests / manHour;
                checksPerMHr = totalChecks / manHour;
            }
            LaborReportData reportData = new LaborReportData();
            String am = "AM";
            String pm = "PM";
            if (i >= 0 && i <= 11) {
                reportData.setPeriod(formatter.format(i) + " " + am);
            } else {
                reportData.setPeriod(formatter.format(i) + " " + pm);
            }
            reportData.setManHour(manHour);
            reportData.setNoOfChecks(totalChecks);
            reportData.setSales(totalSales);
            reportData.setNoOfGuests(totalGuests);
            reportData.setLabor(labor);
            reportData.setSalesPerMHr(salesPerMHr);
            reportData.setGuestsPerMHr(guestsPerMHr);
            reportData.setCheckPerMHr(checksPerMHr);
            double laborCostPercentage = labor != 0.0 ? (totalSales != 0.0 ? labor * 100.0 / totalSales : 100.0) : 0.0;
            reportData.setLaborCost(laborCostPercentage);
            rows.add(reportData);
        }
        ArrayList<LaborReportData> shiftReportRows = new ArrayList<LaborReportData>();
        ShiftDAO shiftDAO = new ShiftDAO();
        List<Shift> shifts = shiftDAO.findAll();
        for (Shift shift : shifts) {
            List<Ticket> tickets = ticketDAO.findTicketsForShift(fromDate, toDate, shift, terminal);
            List<User> users = attendenceHistoryDAO.findNumberOfClockedInUserAtShift(fromDate, toDate, shift, terminal);
            double manHour = users.size();
            double totalChecks = 0.0;
            double totalGuests = 0.0;
            double totalSales = 0.0;
            double labor = 0.0;
            double salesPerMHr = 0.0;
            double guestsPerMHr = 0.0;
            double checksPerMHr = 0.0;
            if (tickets == null || tickets.size() <= 0) continue;
            for (Ticket ticket : tickets) {
                totalChecks += 1.0;
                totalGuests += (double)ticket.getNumberOfGuests().intValue();
                if (this.jcbSalesType.getSelectedIndex() == 0) {
                    totalSales += ticket.getSubtotalAmount().doubleValue();
                    continue;
                }
                if (this.jcbSalesType.getSelectedIndex() == 1) {
                    totalSales += ticket.getTotalAmountWithTips().doubleValue();
                    continue;
                }
                if (this.jcbSalesType.getSelectedIndex() != 2) continue;
                totalSales += ticket.getPaidAmount().doubleValue();
            }
            for (User user : users) {
                labor += user.getCostPerHour() == null ? 0.0 : user.getCostPerHour();
            }
            if (manHour > 0.0) {
                labor /= manHour;
                salesPerMHr = totalSales / manHour;
                guestsPerMHr = totalGuests / manHour;
                checksPerMHr = totalChecks / manHour;
            }
            LaborReportData reportData = new LaborReportData();
            reportData.setPeriod(shift.getName());
            reportData.setManHour(manHour);
            reportData.setNoOfChecks(totalChecks);
            reportData.setSales(totalSales);
            reportData.setNoOfGuests(totalGuests);
            reportData.setLabor(labor);
            reportData.setSalesPerMHr(salesPerMHr);
            reportData.setGuestsPerMHr(guestsPerMHr);
            reportData.setCheckPerMHr(checksPerMHr);
            reportData.setLaborCost(labor * 100.0 / totalSales);
            shiftReportRows.add(reportData);
        }
        JasperReport hourlyReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("hourly_labor_subreport"));
        JasperReport shiftReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("hourly_labor_shift_subreport"));
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("hourly_labor_report"));
        String terminalName = terminal == null ? POSConstants.ALL : terminal.getName();
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        properties.put("reportTitle", Messages.getString("HourlySalesReportView.5"));
        properties.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("salesType", ReportUtil.reportLabelWithBoldTag(Messages.getString("salesType")) + this.jcbSalesType.getSelectedItem());
        properties.put("incr", ReportUtil.reportLabelWithBoldTag(Messages.getString("incr")) + Messages.getString("HourlyLaborReportView.0"));
        properties.put("cntr", ReportUtil.reportLabelWithBoldTag(POSConstants.TERMINAL) + terminalName);
        properties.put("hourlyReport", (String)hourlyReport);
        properties.put("hourlyReportDatasource", (String)new JRTableModelDataSource((TableModel)new HourlySalesReportModel(rows)));
        properties.put("shiftReport", (String)shiftReport);
        properties.put("shiftReportDatasource", (String)new JRTableModelDataSource((TableModel)new HourlySalesReportModel(shiftReportRows)));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JREmptyDataSource());
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap properties) {
        properties.put("SWRTitle", Messages.getString("ShiftWiseR"));
        properties.put("SRGTotal", POSConstants.GRAND_TOTAL);
        properties.put("SRPeriod", Messages.getString("PERIOD"));
        properties.put("SRChecks", Messages.getString("CHECKS"));
        properties.put("SRGuests", Messages.getString("GUESTS"));
        properties.put("SRSales", POSConstants.SALES);
        properties.put("SRMHour", Messages.getString("ManHour"));
        properties.put("SRSMH", Messages.getString("SManHour"));
        properties.put("SRGMH", Messages.getString("GManHour"));
        properties.put("SRCMH", Messages.getString("CManHour"));
        properties.put("SRLCost", Messages.getString("LaborCost"));
        properties.put("SRLCostP", Messages.getString("LaborCostP"));
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HourlySalesReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        this.cbTerminal = new JComboBox();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> terminals = terminalDAO.findAll();
        terminals.add(0, (Terminal)((Object)POSConstants.ALL));
        this.cbTerminal.setModel(new ListComboBoxModel(terminals));
        this.jcbSalesType = new JComboBox();
        this.jcbSalesType.addItem(Messages.getString("HourlySalesReportView.7"));
        this.jcbSalesType.addItem(Messages.getString("HourlySalesReportView.8"));
        this.jcbSalesType.addItem(Messages.getString("HourlySalesReportView.9"));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("", "[][][][][][]"));
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        topPanel.add(this.cbTerminal);
        topPanel.add(new JLabel(Messages.getString("HourlySalesReportView.15") + ":"));
        topPanel.add(this.jcbSalesType);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public static class LaborReportData {
        private String period;
        private double noOfChecks;
        private double noOfGuests;
        private double sales;
        private double manHour;
        private double labor;
        private double salesPerMHr;
        private double guestsPerMHr;
        private double checkPerMHr;
        private double laborCost;

        public double getCheckPerMHr() {
            return this.checkPerMHr;
        }

        public void setCheckPerMHr(double checkPerMHr) {
            this.checkPerMHr = checkPerMHr;
        }

        public double getGuestsPerMHr() {
            return this.guestsPerMHr;
        }

        public void setGuestsPerMHr(double guestsPerMHr) {
            this.guestsPerMHr = guestsPerMHr;
        }

        public double getLabor() {
            return this.labor;
        }

        public void setLabor(double labor) {
            this.labor = labor;
        }

        public double getLaborCost() {
            return this.laborCost;
        }

        public void setLaborCost(double laborCost) {
            this.laborCost = laborCost;
        }

        public double getManHour() {
            return this.manHour;
        }

        public void setManHour(double manHour) {
            this.manHour = manHour;
        }

        public double getNoOfChecks() {
            return this.noOfChecks;
        }

        public void setNoOfChecks(double noOfChecks) {
            this.noOfChecks = noOfChecks;
        }

        public double getNoOfGuests() {
            return this.noOfGuests;
        }

        public void setNoOfGuests(double noOfGuests) {
            this.noOfGuests = noOfGuests;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public double getSales() {
            return this.sales;
        }

        public void setSales(double sales) {
            this.sales = sales;
        }

        public double getSalesPerMHr() {
            return this.salesPerMHr;
        }

        public void setSalesPerMHr(double salesPerMHr) {
            this.salesPerMHr = salesPerMHr;
        }
    }

    public static enum SalesType {
        GROSS_SALES,
        NET_SALES;

    }
}

