/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.util.NumberUtil;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.lang.StringUtils;

public class KitchenTicketDataSource
extends AbstractReportDataSource {
    private Store store = DataProvider.get().getStore();

    public KitchenTicketDataSource(KitchenTicket ticket) {
        super(new String[]{"courseIcon", "groupId", "groupName", "itemNo", "itemName", "itemQty", "colorCode", "isVoidItem", "isModifier"});
        this.setTicket(ticket);
    }

    private void setTicket(KitchenTicket kitchenTicket) {
        Terminal terminal;
        OrderType orderType = kitchenTicket.getOrderType();
        if (orderType != null && !orderType.isAllowSeatBasedOrder().booleanValue() && (terminal = Application.getInstance().getTerminal()) != null && terminal.isGroupByCatagoryKitReceipt().booleanValue()) {
            Collections.sort(kitchenTicket.getTicketItems(), new Comparator<KitchenTicketItem>(){

                @Override
                public int compare(KitchenTicketItem o1, KitchenTicketItem o2) {
                    return o1.getMenuItemGroupName().compareTo(o2.getMenuItemGroupName());
                }
            });
        }
        this.setRows(kitchenTicket.getTicketItems());
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        KitchenTicketItem item = (KitchenTicketItem)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return null;
            }
            case 1: {
                return item.getMenuItemGroupName();
            }
            case 2: {
                return item.getMenuItemGroupName();
            }
            case 3: {
                return item.getMenuItemCode();
            }
            case 4: {
                return item.getMenuItemNameDisplay();
            }
            case 5: {
                return NumberUtil.trimDecilamIfNotNeeded(item.getQuantity());
            }
            case 6: {
                Ticket ticket = item.getKitchenTicket().getParentTicket();
                String orderTypeId = "";
                if (ticket != null && ticket.getOrderType() != null) {
                    orderTypeId = ticket.getOrderType().getId();
                }
                return this.getColorCode(item, orderTypeId);
            }
            case 7: {
                return item.isVoided();
            }
            case 8: {
                return item.isModifierItem();
            }
        }
        return null;
    }

    public String getColorCode(KitchenTicketItem item, String orderTypeId) {
        if (StringUtils.isNotEmpty((String)orderTypeId)) {
            orderTypeId = orderTypeId + ".";
        }
        if (item.isModifierItem().booleanValue()) {
            return this.store.getProperty(orderTypeId + "kitchen_ticket.modifier.color");
        }
        if (item.isCookingInstruction().booleanValue()) {
            return this.store.getProperty(orderTypeId + "kitchen_ticket.instruction.color");
        }
        if (item.getMenuItemName().contains("Seat**")) {
            return this.store.getProperty(orderTypeId + "kitchen_ticket.seat.color");
        }
        return Messages.getString("KitchenTicketDataSource.7");
    }
}

