/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketReportModel;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class OpenTicketSummaryReport
extends Report {
    @Override
    public void refresh() throws Exception {
        String userName = this.getUserType() == null ? POSConstants.ALL : this.getUserType().getName();
        OrderType orderType = this.getOrderType();
        String orderTypeName = "";
        ArrayList<String> userOrderTypesIds = new ArrayList<String>();
        if (orderType != null) {
            userOrderTypesIds.add(orderType.getId());
            orderTypeName = orderType.getName();
        } else {
            List<OrderType> typesForUser = POSUtil.getBackOfficeWindow().getCurrentUser().getPropOrderTypes();
            if (typesForUser.isEmpty()) {
                orderTypeName = POSConstants.ALL;
            } else {
                Iterator<OrderType> iterator = typesForUser.iterator();
                while (iterator.hasNext()) {
                    OrderType userOrderType = iterator.next();
                    userOrderTypesIds.add(userOrderType.getId());
                    orderTypeName = orderTypeName + userOrderType.getName();
                    if (!iterator.hasNext()) continue;
                    orderTypeName = orderTypeName + ", ";
                }
            }
        }
        Date startDate = this.getStartDate();
        Date endDate = this.getEndDate();
        List<Ticket> tickets = TicketDAO.getInstance().findOpenTickets(this.getTerminals(), this.getUserType(), userOrderTypesIds, startDate, endDate);
        TicketReportModel reportModel = new TicketReportModel();
        reportModel.setItems(tickets);
        reportModel.calculateGrandTotal();
        reportModel.calculateTotalDue();
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map);
        ReportUtil.populateReportHeaderWithTerminals(map, this.getTerminals(), startDate, endDate, userName);
        map.put("orderType", ReportUtil.reportLabelWithBoldTag(POSConstants.ORDER_TYPE + ":") + " " + orderTypeName);
        ReportUtil.populateReportFooter(map);
        this.populateReportParams(map);
        map.put("reportTitle", Messages.getString("OpenTicketSummaryReport.0"));
        map.put("grandTotal", reportModel.getGrandTotalAsString());
        map.put("totalDue", reportModel.getTotalDueAsString());
        JasperReport masterReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("open_ticket_summary_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        this.viewer = ReportUtil.getCustomJRViewer(print);
    }

    private void populateReportParams(HashMap map) {
        map.put("colId", POSConstants.ID);
        map.put("colCreated", POSConstants.CREATED);
        map.put("colOrderT", POSConstants.ORDER_TYPE);
        map.put("colOwner", Messages.getString("GiftCardSummaryReportView.3"));
        map.put("colTotal", POSConstants.TOTAL);
        map.put("colDue", POSConstants.DUE);
        map.put("colGTotal", POSConstants.GRAND_TOTAL);
    }

    @Override
    public boolean isDateRangeSupported() {
        return false;
    }

    @Override
    public boolean isTypeSupported() {
        return false;
    }
}

