/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.PurchaseOrderItem;
import com.floreantpos.report.AbstractReportDataSource;
import java.util.List;

public class PurchaseOrderItemDataSource
extends AbstractReportDataSource {
    public PurchaseOrderItemDataSource(List<PurchaseOrderItem> items) {
        super(new String[]{"barcodeNumber", "itemName", "price"});
        this.setRows(items);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        PurchaseOrderItem item = (PurchaseOrderItem)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.getMenuItem().getBarcode();
            }
            case 1: {
                return item.getName();
            }
            case 2: {
                return "$ " + item.getPriceDisplay();
            }
        }
        return null;
    }
}

