/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.OpenTicketSummaryReport;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReturnItemReport;
import com.floreantpos.report.SalesReport;
import com.floreantpos.report.VoidItemReport;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jdesktop.swingx.JXDatePicker;

public class ReportViewer
extends JPanel {
    private JButton btnRefresh;
    private JButton btnClear;
    private JLabel lblGroup;
    private JXDatePicker dpEndDate;
    private JXDatePicker dpStartDate;
    private JComboBox<Date> jcbStartTime;
    private JComboBox<Date> jcbEndTime;
    private JLabel lblFromDate;
    private JLabel lblToDate;
    private JLabel lblTerminal;
    private JCheckBox chkBoxFree;
    private JCheckBox chkShowInGroups;
    private JLabel lblUserType;
    private JComboBox<User> cbUserType;
    private JLabel lblOrderType;
    private JComboBox<OrderType> cbOrderType;
    private TransparentPanel reportConstraintPanel;
    private TransparentPanel reportPanel;
    private Report report;
    private MultiSelectComboBox<MenuGroup> cbMenuGroup;
    private MultiSelectComboBox<Terminal> cbMultiTerminal;
    private MultiSelectComboBox<OrderType> cbMultiOrderType;
    private JLabel lblCategory;
    private MultiSelectComboBox<MenuCategory> cbMenuCategory;
    private JCheckBox chkConsolidate;
    private JPanel groupPannel;
    private JPanel terminalPannel;
    private JPanel categoryPannel;
    private JPanel fromDatePannel;
    private JPanel toDatePannel;
    private JPanel userTypePannel;
    private JPanel orderTypePannel;
    private List<OrderType> enabledOrderTypeListForUser;

    public ReportViewer() {
        this.initComponents();
    }

    public ReportViewer(Report report) {
        this.initComponents();
        this.cbMenuGroup.setItems(MenuGroupDAO.getInstance().findAllForReport(false));
        this.cbMultiTerminal.setItems(TerminalDAO.getInstance().findAll());
        this.cbMenuCategory.setItems(MenuCategoryDAO.getInstance().findAllForReport(false));
        User user = POSUtil.getBackOfficeWindow().getCurrentUser();
        UserDAO.getInstance().refresh(user);
        this.enabledOrderTypeListForUser = user.getPropOrderTypes();
        if (this.enabledOrderTypeListForUser.isEmpty()) {
            this.enabledOrderTypeListForUser = OrderTypeDAO.getInstance().findAllForReport(false);
        }
        this.cbMultiOrderType.setItems(this.enabledOrderTypeListForUser);
        this.setReport(report);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.reportConstraintPanel = new TransparentPanel();
        this.reportConstraintPanel.setLayout(new WrapLayout(3, 5, 0));
        this.reportConstraintPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.groupPannel = new JPanel();
        this.lblGroup = new JLabel(Messages.getString("ReportViewer.4"));
        this.cbMenuGroup = new MultiSelectionOverflowCombobox<MenuGroup>();
        this.cbMenuGroup.setPreferredSize(PosUIManager.getSize(130, 20));
        this.groupPannel.add(this.lblGroup);
        this.groupPannel.add(this.cbMenuGroup);
        this.terminalPannel = new JPanel();
        this.lblTerminal = new JLabel(Messages.getString("ReportViewer.3"));
        this.cbMultiTerminal = new MultiSelectComboBox();
        this.cbMultiTerminal.setPreferredSize(PosUIManager.getSize(130, 20));
        this.terminalPannel.add(this.lblTerminal);
        this.terminalPannel.add(this.cbMultiTerminal);
        this.categoryPannel = new JPanel();
        this.lblCategory = new JLabel(POSConstants.CATEGORY);
        this.cbMenuCategory = new MultiSelectComboBox();
        this.cbMenuCategory.setPreferredSize(PosUIManager.getSize(130, 20));
        this.categoryPannel.add(this.lblCategory);
        this.categoryPannel.add(this.cbMenuCategory);
        TimeComboBox tcb = new TimeComboBox();
        this.fromDatePannel = new JPanel();
        this.lblFromDate = new JLabel(POSConstants.START_DATE + ":");
        this.dpStartDate = UiUtil.getCurrentMonthStart();
        this.dpStartDate.getEditor().setEditable(false);
        this.jcbStartTime = tcb.getDefaultTimeComboBox();
        this.fromDatePannel.add(this.lblFromDate);
        this.fromDatePannel.add((Component)this.dpStartDate);
        this.fromDatePannel.add(this.jcbStartTime);
        this.toDatePannel = new JPanel();
        this.lblToDate = new JLabel(POSConstants.END_DATE + ":");
        this.dpEndDate = UiUtil.getCurrentMonthEnd();
        this.dpEndDate.getEditor().setEditable(false);
        this.jcbEndTime = tcb.getDefaultTimeComboBox();
        this.toDatePannel.add(this.lblToDate);
        this.toDatePannel.add((Component)this.dpEndDate);
        this.toDatePannel.add(this.jcbEndTime);
        this.chkConsolidate = new JCheckBox(Messages.getString("ReportViewer.9"));
        this.userTypePannel = new JPanel();
        this.lblUserType = new JLabel(Messages.getString("ReportViewer.7"));
        this.cbUserType = new JComboBox();
        this.cbUserType.setPreferredSize(PosUIManager.getSize(130, 20));
        this.userTypePannel.add(this.lblUserType);
        this.userTypePannel.add(this.cbUserType);
        this.orderTypePannel = new JPanel();
        this.lblOrderType = new JLabel(Messages.getString("ReportViewer.1"));
        this.cbOrderType = new JComboBox();
        this.cbOrderType.setPreferredSize(PosUIManager.getSize(130, 20));
        this.orderTypePannel.add(this.lblOrderType);
        this.orderTypePannel.add(this.cbOrderType);
        this.cbMultiOrderType = new MultiSelectComboBox();
        this.cbMultiOrderType.setPreferredSize(PosUIManager.getSize(130, 20));
        this.chkBoxFree = new JCheckBox(Messages.getString("ReportViewer.6"));
        this.chkShowInGroups = new JCheckBox(Messages.getString("ReportViewer.5"));
        this.btnRefresh = new JButton(Messages.getString("ReportViewer.2"));
        this.reportPanel = new TransparentPanel();
        this.btnRefresh.addActionListener(evt -> this.doRefreshReport());
        this.btnClear = new JButton(Messages.getString("ReportViewer.8"));
        this.btnClear.addActionListener(evt -> this.doClear());
        this.reportConstraintPanel.add(this.groupPannel);
        this.reportConstraintPanel.add(this.terminalPannel);
        this.reportConstraintPanel.add(this.fromDatePannel);
        this.reportConstraintPanel.add(this.toDatePannel);
        this.reportConstraintPanel.add(new JLabel(""));
        this.reportConstraintPanel.add(this.chkBoxFree);
        this.reportConstraintPanel.add(this.chkShowInGroups);
        this.reportConstraintPanel.add(new JLabel(""));
        this.reportConstraintPanel.add(this.btnRefresh);
        this.reportPanel.setLayout(new BorderLayout());
        this.add((Component)this.reportConstraintPanel, "North");
        this.reportPanel.add((Component)new JSeparator(), "North");
        this.add((Component)this.reportPanel, "Center");
    }

    private void doRefreshReport() {
        try {
            Date fromDate = this.dpStartDate.getDate();
            Date toDate = this.dpEndDate.getDate();
            DateUtil.validateDate(fromDate, toDate);
            Date startTime = (Date)this.jcbStartTime.getSelectedItem();
            Date endTime = (Date)this.jcbEndTime.getSelectedItem();
            fromDate = DateUtil.copyTime(fromDate, startTime);
            toDate = DateUtil.copyTime(toDate, endTime);
            this.reportPanel.removeAll();
            this.reportPanel.revalidate();
            this.reportPanel.add((Component)new JSeparator(), "North");
            if (this.report != null) {
                UserType userType = null;
                if (this.cbUserType.getSelectedItem() instanceof UserType) {
                    userType = (UserType)this.cbUserType.getSelectedItem();
                }
                this.report.setUserType(userType);
                OrderType orderType = null;
                if (this.cbOrderType.getSelectedItem() instanceof OrderType) {
                    orderType = (OrderType)this.cbOrderType.getSelectedItem();
                }
                this.report.setOrderType(orderType);
                this.report.setMenuGroups(this.cbMenuGroup.getSelectedItems());
                this.report.setTerminals(this.cbMultiTerminal.getSelectedItems());
                User user = POSUtil.getBackOfficeWindow().getCurrentUser();
                this.report.setOrderTypes(this.cbMultiOrderType.getSelectedItems() == null ? user.getPropOrderTypes() : this.cbMultiOrderType.getSelectedItems());
                this.report.setMenuCategories(this.cbMenuCategory.getSelectedItems());
                this.report.setStartDate(fromDate);
                this.report.setEndDate(toDate);
                this.report.setIncludeFreeItems(this.chkBoxFree.isSelected());
                this.report.setShowInGroups(this.chkShowInGroups.isSelected());
                this.report.setConsolidate(this.chkConsolidate.isSelected());
                this.report.refresh();
                if (this.report != null && this.report.getViewer() != null) {
                    this.reportPanel.add((Component)this.report.getViewer());
                    this.reportPanel.revalidate();
                }
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    public void doClear() {
        if (this.report != null) {
            this.cbOrderType.setSelectedIndex(0);
            this.cbMultiOrderType.setSelectedIndex(0);
            this.cbUserType.setSelectedIndex(0);
            this.cbMultiTerminal.setSelectedIndex(0);
        }
    }

    public Report getReport() {
        return this.report;
    }

    public void setReport(Report report) {
        this.report = report;
        if (report instanceof VoidItemReport || report instanceof ReturnItemReport) {
            this.reportConstraintPanel.removeAll();
            this.reportConstraintPanel.add(this.terminalPannel);
            this.orderTypePannel.removeAll();
            this.orderTypePannel.add(this.lblOrderType);
            this.orderTypePannel.add(this.cbMultiOrderType);
            this.reportConstraintPanel.add(this.orderTypePannel);
            this.reportConstraintPanel.add(this.fromDatePannel);
            this.reportConstraintPanel.add(this.toDatePannel);
            this.reportConstraintPanel.add(this.btnRefresh);
        }
        if (report instanceof SalesReport) {
            this.reportConstraintPanel.removeAll();
            this.orderTypePannel.removeAll();
            this.orderTypePannel.add(this.lblOrderType);
            this.orderTypePannel.add(this.cbMultiOrderType);
            this.reportConstraintPanel.add(this.orderTypePannel);
            this.reportConstraintPanel.add(this.categoryPannel);
            this.reportConstraintPanel.add(this.groupPannel);
            this.reportConstraintPanel.add(this.terminalPannel);
            this.reportConstraintPanel.add(this.fromDatePannel);
            this.reportConstraintPanel.add(this.toDatePannel);
            this.reportConstraintPanel.add(this.chkBoxFree);
            this.reportConstraintPanel.add(this.chkShowInGroups);
            this.reportConstraintPanel.add(this.chkConsolidate);
            this.reportConstraintPanel.add(this.btnRefresh);
        }
        if (report instanceof OpenTicketSummaryReport) {
            this.reportConstraintPanel.removeAll();
            UserTypeDAO dao = new UserTypeDAO();
            List<UserType> userTypes = dao.findAll();
            ArrayList<Object> userTypeList = new ArrayList<Object>();
            userTypeList.add(0, POSConstants.ALL);
            userTypeList.addAll(userTypes);
            ArrayList<Object> orderTypeList = new ArrayList<Object>();
            orderTypeList.add(0, POSConstants.ALL);
            orderTypeList.addAll(this.enabledOrderTypeListForUser);
            this.cbUserType.setModel(new ListComboBoxModel(userTypeList));
            this.reportConstraintPanel.add(this.userTypePannel);
            this.cbOrderType.setModel(new ListComboBoxModel(orderTypeList));
            this.reportConstraintPanel.add(this.orderTypePannel);
            this.reportConstraintPanel.add(this.fromDatePannel);
            this.reportConstraintPanel.add(this.toDatePannel);
            this.reportConstraintPanel.add(this.terminalPannel);
            this.reportConstraintPanel.add(new JLabel(""));
            this.reportConstraintPanel.add(this.btnRefresh);
            this.reportConstraintPanel.add(this.btnClear);
        }
    }
}

