/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.report.SessionSummaryReportView;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.List;

public class SessionSummaryReportModel
extends ListTableModel {
    private String[] columnNames = new String[]{"period", "sessionID", "openingBalance", "deposits", "outage", "cash", "tips", "onAcct", "otherPmt", "payInOut", "voids", "totalGuest", "avgChk", "refund"};

    public SessionSummaryReportModel() {
        this.setColumnNames(this.columnNames);
    }

    public SessionSummaryReportModel(List rows) {
        this.setColumnNames(this.columnNames);
        this.setRows(rows);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SessionSummaryReportView.SessionSummaryReportData reportData = (SessionSummaryReportView.SessionSummaryReportData)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return reportData.getPeriod();
            }
            case 1: {
                return reportData.getSessionID();
            }
            case 2: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getOpeningBalance());
            }
            case 3: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getDeposit());
            }
            case 4: {
                return reportData.getOverOutage();
            }
            case 5: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getCash());
            }
            case 6: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getTips());
            }
            case 7: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getOnAccount());
            }
            case 8: {
                return reportData.getOtherPayment();
            }
            case 9: {
                return reportData.getPayInOut();
            }
            case 10: {
                return reportData.getVoids();
            }
            case 11: {
                return NumberUtil.getIntegerFormat(reportData.getTotalGuest());
            }
            case 12: {
                return NumberUtil.getCurrencyFormatWithoutSymbol(reportData.getAvgChk());
            }
            case 13: {
                return reportData.getRefund();
            }
        }
        return null;
    }
}

