/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.view.JasperViewer;

public class ShiftwiseSalesSummaryReportModel
extends ListTableModel {
    public ShiftwiseSalesSummaryReportModel(List<ShiftwiseSalesSummaryData> dataList) {
        super(new String[]{"shiftName", "categoryName", "count", "gross", "discount", "netSales", "taxAmount"}, dataList);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ShiftwiseSalesSummaryData data = (ShiftwiseSalesSummaryData)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return Messages.getString("ShiftwiseSalesSummaryReportModel.0") + data.shiftName;
            }
            case 1: {
                return data.categoryName;
            }
            case 2: {
                return NumberUtil.formatNumber(data.count);
            }
            case 3: {
                return NumberUtil.formatNumber(data.gross);
            }
            case 4: {
                return NumberUtil.formatNumber(data.discount);
            }
            case 5: {
                return NumberUtil.formatNumber(data.netSales);
            }
            case 6: {
                return NumberUtil.formatNumber(data.taxAmount);
            }
        }
        return null;
    }

    public static void main(String[] args) throws Exception {
        ArrayList<ShiftwiseSalesSummaryData> list = new ArrayList<ShiftwiseSalesSummaryData>();
        ShiftwiseSalesSummaryData data = new ShiftwiseSalesSummaryData();
        data.setShiftName("SHIFT1");
        data.setCategoryName("C");
        list.add(data);
        data = new ShiftwiseSalesSummaryData();
        data.setShiftName("SHIFT1");
        data.setCategoryName("C2");
        list.add(data);
        data = new ShiftwiseSalesSummaryData();
        data.setShiftName("SHIFT2");
        data.setCategoryName("C");
        list.add(data);
        JasperReport report = ReportUtil.getReport("sales_summary_report2");
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, new HashMap(), (JRDataSource)new JRBeanCollectionDataSource(list));
        JasperViewer.viewReport((JasperPrint)print, (boolean)true);
    }

    public static class ShiftwiseSalesSummaryData {
        private String shiftName;
        private String categoryName;
        private double count;
        private double gross;
        private double discount;
        private double netSales;
        private double taxAmount;

        public String getCategoryName() {
            return this.categoryName;
        }

        public void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        public double getCount() {
            return this.count;
        }

        public void setCount(double count) {
            this.count = count;
        }

        public double getDiscount() {
            return this.discount;
        }

        public void setDiscount(double discount) {
            this.discount = discount;
        }

        public double getGross() {
            return this.gross;
        }

        public void setGross(double gross) {
            this.gross = gross;
        }

        public double getNetSales() {
            return this.netSales;
        }

        public void setNetSales(double netSales) {
            this.netSales = netSales;
        }

        public String getShiftName() {
            return this.shiftName;
        }

        public void setShiftName(String shiftName) {
            this.shiftName = shiftName;
        }

        public double getTaxAmount() {
            return this.taxAmount;
        }

        public void setTaxAmount(double taxAmount) {
            this.taxAmount = taxAmount;
        }
    }
}

