/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.StaffBankReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class StaffBankReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JComboBox<Date> jcbStartTime;
    private JComboBox<Date> jcbEndTime;
    private JPanel reportPanel;
    private JPanel contentPane;
    private AutoCompletionComboBox cbStaff;

    public StaffBankReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void createUI() {
        TimeComboBox tcb = new TimeComboBox();
        this.jcbStartTime = tcb.getDefaultTimeComboBox();
        this.jcbEndTime = tcb.getDefaultTimeComboBox();
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    StaffBankReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        this.cbStaff = new AutoCompletionComboBox();
        UserDAO dao = new UserDAO();
        List<User> staff = dao.findAll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(staff);
        this.cbStaff.setModel(new DefaultComboBoxModel(list));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(Messages.getString("StaffBankReportView.0") + ":"));
        topPanel.add((Component)this.cbStaff, "width 160!");
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(this.jcbStartTime);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(this.jcbEndTime);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    private void viewReport() throws Exception {
        List<CashDrawer> staffBankItems;
        Date fromDate = this.fromDatePicker.getDate();
        Date toDate = this.toDatePicker.getDate();
        Date startTime = (Date)this.jcbStartTime.getSelectedItem();
        Date endTime = (Date)this.jcbEndTime.getSelectedItem();
        fromDate = DateUtil.copyTime(fromDate, startTime);
        toDate = DateUtil.copyTime(toDate, endTime);
        if (fromDate == null || toDate == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("StaffBankReportView.2"));
            return;
        }
        if (fromDate.after(toDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Object selectedItem = this.cbStaff.getSelectedItem();
        User staff = null;
        if (selectedItem instanceof User) {
            staff = (User)selectedItem;
        }
        if ((staffBankItems = CashDrawerDAO.getInstance().findStaffBank(fromDate, toDate, staff)) == null || staffBankItems.size() < 1) {
            this.reportPanel.removeAll();
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("StaffBankReportView.3"));
            return;
        }
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("staff-bank-report"));
        HashMap properties = new HashMap();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        StaffBankReportModel reportModel = new StaffBankReportModel();
        reportModel.setRows(staffBankItems);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap map) {
        map.put("reportTitle", Messages.getString("StaffBankReportView.5"));
        map.put("netSalesHeader", Messages.getString("StaffBankReportView.10") + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("cashToDepositeHeader", Messages.getString("StaffBankReportView.14") + CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("colSBC", Messages.getString("StaffBankClosed"));
        map.put("colSBO", Messages.getString("StaffBankOpened"));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

