/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TracTipsReportModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jdesktop.swingx.JXDatePicker;

public class TracTipsReportView
extends TransparentPanel {
    private JButton btnGo;
    private JComboBox cbTerminal;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JComboBox jcbEmployee;
    private Session session;

    public TracTipsReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        Date toDate;
        GenericDAO dao = new GenericDAO();
        Date fromDate = DateUtil.startOfDay(this.fromDatePicker.getDate());
        if (fromDate.after(toDate = DateUtil.endOfDay(this.toDatePicker.getDate()))) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        User selectedUser = null;
        if (this.jcbEmployee.getSelectedItem() instanceof User) {
            selectedUser = (User)this.jcbEmployee.getSelectedItem();
        }
        Terminal terminal = null;
        if (this.cbTerminal.getSelectedItem() instanceof Terminal) {
            terminal = (Terminal)this.cbTerminal.getSelectedItem();
        }
        this.session = dao.createNewSession();
        ArrayList<TracTipsReportData> rows = new ArrayList<TracTipsReportData>();
        ArrayList<User> users = new ArrayList<User>();
        if (selectedUser == null) {
            ComboBoxModel model = (ComboBoxModel)this.jcbEmployee.getModel();
            List dataList = model.getDataList();
            for (Object object : dataList) {
                if (!(object instanceof User)) continue;
                users.add((User)object);
            }
        } else {
            users.add(selectedUser);
        }
        for (User user : users) {
            if (!this.hasDeclaredTips(this.session, fromDate, toDate, user) && !this.hasTransactions(this.session, fromDate, toDate, user)) continue;
            TracTipsReportData reportData = new TracTipsReportData();
            reportData.setEmployeeID(user.getId());
            reportData.setEmployeeName(user.getFullName());
            this.calculateGrossSales(reportData, this.session, fromDate, toDate, user);
            this.calculateCreditCardSales(reportData, this.session, fromDate, toDate, user);
            this.calculateCashTotalWithoutTips(reportData, this.session, fromDate, toDate, user);
            this.calculateDeclareTips(reportData, this.session, fromDate, toDate, user);
            reportData.setNetTips(reportData.getCreditCardTips() + reportData.getTracCashTips() + reportData.getDeclareTips());
            rows.add(reportData);
        }
        if (rows.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("TracTipsReportView.0"));
            return;
        }
        JasperReport trakTipsReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("track_tips_report"));
        String userName = selectedUser == null ? POSConstants.ALL : selectedUser.getFullName();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportHeader(properties, terminal, fromDate, toDate, userName);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        properties.put("reportTitle", Messages.getString("TracTipsReportView.2"));
        TracTipsReportModel reportModel = new TracTipsReportModel();
        reportModel.setRows(rows);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)trakTipsReport, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap<String, Object> map) {
        map.put("colId", POSConstants.ID);
        map.put("colName", POSConstants.NAME);
        map.put("colGSales", Messages.getString("HourlySalesReportView.7"));
        map.put("colCCSalesT", Messages.getString("CCSales") + "<br/>" + Messages.getString("WithTips"));
        map.put("colCCTips", Messages.getString("CCTips"));
        map.put("colTCCTR", Messages.getString("TracCC") + "<br/>" + Messages.getString("TipsRate"));
        map.put("colTCSWT", Messages.getString("TracCash") + "<br/>" + Messages.getString("SWTips"));
        map.put("colTCT", Messages.getString("TracCash") + "<br/>" + POSConstants.TIPS.toLowerCase());
        map.put("colTCTR", Messages.getString("TracCash") + "<br/>" + Messages.getString("TipsRate").toLowerCase());
        map.put("colTDTips", Messages.getString("TracDeclared") + "<br/>" + POSConstants.TIPS.toLowerCase());
        map.put("colNTips", Messages.getString("SRNTips"));
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TracTipsReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        this.jcbEmployee = new JComboBox();
        UserDAO dao = new UserDAO();
        List<User> userTypes = dao.findAll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(userTypes);
        this.jcbEmployee.setModel(new ComboBoxModel(list));
        this.cbTerminal = new JComboBox();
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> terminals = terminalDAO.findAll();
        terminals.add(0, (Terminal)((Object)POSConstants.ALL));
        this.cbTerminal.setModel(new ListComboBoxModel(terminals));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        topPanel.add(this.jcbEmployee);
        topPanel.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        topPanel.add(this.cbTerminal);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    private boolean hasTransactions(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = this.buildCriteria(session, fromDate, toDate, user);
        criteria.setProjection(Projections.rowCount());
        Number rowCount = (Number)criteria.uniqueResult();
        if (rowCount != null) {
            return rowCount.intValue() > 0;
        }
        return false;
    }

    private boolean hasDeclaredTips(Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(DeclaredTips.class);
        criteria.add(Restrictions.between((String)DeclaredTips.PROP_DECLARED_TIME, (Object)fromDate, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_OWNER_ID, (Object)user.getId()));
        criteria.setProjection(Projections.rowCount());
        Number rowCount = (Number)criteria.uniqueResult();
        if (rowCount != null) {
            return rowCount.intValue() > 0;
        }
        return false;
    }

    private void calculateGrossSales(TracTipsReportData reportData, Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = this.buildCriteria(session, fromDate, toDate, user);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        Double grossSales = (Double)criteria.uniqueResult();
        if (grossSales != null) {
            reportData.setGrossSales(grossSales - this.calculateRefundSales(reportData, session, fromDate, toDate, user, null));
        }
    }

    private double calculateRefundSales(TracTipsReportData reportData, Session session, Date fromDate, Date toDate, User user, PaymentType paymentType) {
        Criteria criteria = this.buildCriteria(session, RefundTransaction.class, fromDate, toDate, user);
        if (paymentType != null) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)paymentType.name()));
        }
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        Double totalRefundAmount = (Double)criteria.uniqueResult();
        if (totalRefundAmount == null) {
            totalRefundAmount = 0.0;
        }
        return totalRefundAmount;
    }

    private Criteria buildCriteria(Session session, Date fromDate, Date toDate, User user) {
        return this.buildCriteria(session, PosTransaction.class, fromDate, toDate, user);
    }

    private Criteria buildCriteria(Session session, Class<?> transactionClass, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(transactionClass);
        criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
        if (transactionClass.equals(RefundTransaction.class) || transactionClass.equals(PayOutTransaction.class)) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
        } else {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
        }
        if (fromDate != null && toDate != null) {
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)fromDate, (Object)toDate));
        }
        criteria.add((Criterion)Restrictions.eq((String)("ticket." + Ticket.PROP_OWNER_ID), (Object)(user == null ? null : user.getId())));
        return criteria;
    }

    private void calculateCreditCardSales(TracTipsReportData reportData, Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = this.buildCriteria(session, CreditCardTransaction.class, fromDate, toDate, user);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        Double totalCreditCardAmount = (Double)criteria.uniqueResult();
        criteria.setProjection(null);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        Double creditCardTipsAmount = (Double)criteria.uniqueResult();
        if (totalCreditCardAmount == null) {
            totalCreditCardAmount = 0.0;
        }
        if (creditCardTipsAmount == null) {
            creditCardTipsAmount = 0.0;
        }
        double creditCardWithoutTips = totalCreditCardAmount - creditCardTipsAmount - this.calculateRefundSales(reportData, session, fromDate, toDate, user, PaymentType.CREDIT_CARD) - this.calculateRefundSales(reportData, session, fromDate, toDate, user, PaymentType.DEBIT_CARD);
        Criteria criteria2 = this.buildCriteria(session, DebitCardTransaction.class, fromDate, toDate, user);
        criteria2.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
        Double totalDebitCardAmount = (Double)criteria2.uniqueResult();
        criteria2.setProjection(null);
        criteria2.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        Double debitCardTipsAmount = (Double)criteria2.uniqueResult();
        if (totalDebitCardAmount == null) {
            totalDebitCardAmount = 0.0;
        }
        if (debitCardTipsAmount == null) {
            debitCardTipsAmount = 0.0;
        }
        double debitCardWithoutTips = totalDebitCardAmount - debitCardTipsAmount;
        double totalCardSalsesWithoutTips = creditCardWithoutTips + debitCardWithoutTips;
        reportData.setCreditCardTips(creditCardTipsAmount + debitCardTipsAmount);
        if (creditCardTipsAmount <= 0.0 || totalCreditCardAmount <= 0.0) {
            reportData.setTracCreditCardTipsRate(0.0);
        }
        if (totalCardSalsesWithoutTips > 0.0) {
            reportData.setTracCreditCardTipsRate(reportData.getCreditCardTips() * 100.0 / totalCardSalsesWithoutTips);
        }
        reportData.setCreditCardSalesWithoutTips(totalCardSalsesWithoutTips);
    }

    private void calculateCashTotalWithoutTips(TracTipsReportData reportData, Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = this.buildCriteria(session, CashTransaction.class, fromDate, toDate, user);
        criteria.setProjection((Projection)Projections.sum((String)CashTransaction.PROP_AMOUNT));
        Double totalCashAmount = (Double)criteria.uniqueResult();
        criteria.setProjection(null);
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        Double cashTipsAmount = (Double)criteria.uniqueResult();
        if (totalCashAmount == null) {
            totalCashAmount = 0.0;
        }
        if (cashTipsAmount == null) {
            cashTipsAmount = 0.0;
        }
        double cashAmountWithoutTips = totalCashAmount - cashTipsAmount - this.calculateRefundSales(reportData, session, fromDate, toDate, user, PaymentType.CASH);
        reportData.setTracCashTips(cashTipsAmount);
        if (cashTipsAmount <= 0.0 || totalCashAmount <= 0.0) {
            reportData.setTracCashTipsRate(0.0);
        }
        if (totalCashAmount > 0.0) {
            reportData.setTracCashTipsRate(cashTipsAmount * 100.0 / totalCashAmount);
        }
        reportData.setTracCashSalesWithoutTips(cashAmountWithoutTips);
    }

    private void calculateDeclareTips(TracTipsReportData reportData, Session session, Date fromDate, Date toDate, User user) {
        Criteria criteria = session.createCriteria(DeclaredTips.class);
        criteria.add(Restrictions.between((String)DeclaredTips.PROP_DECLARED_TIME, (Object)fromDate, (Object)toDate));
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_OWNER_ID, (Object)user.getId()));
        criteria.setProjection((Projection)Projections.sum((String)DeclaredTips.PROP_AMOUNT));
        Double declareTips = (Double)criteria.uniqueResult();
        if (declareTips != null) {
            reportData.setDeclareTips(declareTips);
        }
    }

    public static class TracTipsReportData {
        private String employeeID;
        private String employeeName;
        private double grossSales;
        private double creditCardSalesWithoutTips;
        private double creditCardTips;
        private double tracCreditCardTipsRate;
        private double tracCashSalesWithoutTips;
        private double tracCashTips;
        private double tracCashTipsRate;
        private double tipsPaid;
        private double netTips;
        private double declareTips;

        public String getEmployeeID() {
            return this.employeeID;
        }

        public void setEmployeeID(String employeeID) {
            this.employeeID = employeeID;
        }

        public String getEmployeeName() {
            return this.employeeName;
        }

        public void setEmployeeName(String employeeName) {
            this.employeeName = employeeName;
        }

        public double getGrossSales() {
            return this.grossSales;
        }

        public void setGrossSales(double grossSales) {
            this.grossSales = grossSales;
        }

        public double getCreditCardTips() {
            return this.creditCardTips;
        }

        public void setCreditCardTips(double creditCardTips) {
            this.creditCardTips = creditCardTips;
        }

        public double getTracCreditCardTipsRate() {
            return this.tracCreditCardTipsRate;
        }

        public void setTracCreditCardTipsRate(double trackCreditCardTipsRate) {
            this.tracCreditCardTipsRate = trackCreditCardTipsRate;
        }

        public double getTracCashTips() {
            return this.tracCashTips;
        }

        public void setTracCashTips(double trackCashTips) {
            this.tracCashTips = trackCashTips;
        }

        public double getTracCashTipsRate() {
            return this.tracCashTipsRate;
        }

        public void setTracCashTipsRate(double trackCashTipsRate) {
            this.tracCashTipsRate = trackCashTipsRate;
        }

        public double getTipsPaid() {
            return this.tipsPaid;
        }

        public void setTipsPaid(double tipsPaid) {
            this.tipsPaid = tipsPaid;
        }

        public double getNetTips() {
            return this.netTips;
        }

        public void setNetTips(double netTips) {
            this.netTips = netTips;
        }

        public double getCreditCardSalesWithoutTips() {
            return this.creditCardSalesWithoutTips;
        }

        public void setCreditCardSalesWithoutTips(double creditCardSalesWithoutTips) {
            this.creditCardSalesWithoutTips = creditCardSalesWithoutTips;
        }

        public double getTracCashSalesWithoutTips() {
            return this.tracCashSalesWithoutTips;
        }

        public void setTracCashSalesWithoutTips(double trackCashSalesWithoutTips) {
            this.tracCashSalesWithoutTips = trackCashSalesWithoutTips;
        }

        public double getDeclareTips() {
            return this.declareTips;
        }

        public void setDeclareTips(double declareTips) {
            this.declareTips = declareTips;
        }
    }
}

