/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DeletedItem;
import com.floreantpos.report.Report;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.VoidItemReportModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang.StringUtils;

public class VoidItemReport
extends Report {
    private VoidItemReportModel voidItemReportModel;
    private VoidItemReportModel voidTicketReportModel;

    @Override
    public void refresh() throws Exception {
        boolean isModelAdded = this.createModels();
        if (!isModelAdded) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("VoidItemReport.0"));
            this.viewer = null;
            return;
        }
        JasperReport itemReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("deleteItem_sub_report"));
        JasperReport ticketReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("deleteItem_ticket_sub_report"));
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map);
        ReportUtil.populateReportHeaderWithTerminals(map, this.getTerminals(), this.getStartDate(), this.getEndDate(), null);
        map.put("orderType", ReportUtil.reportLabelWithBoldTag(POSConstants.ORDER_TYPE) + ": " + VoidItemReport.createOrderTypeString(this.getOrderTypes()));
        ReportUtil.populateReportFooter(map);
        this.populateReportParams(map);
        map.put("reportTitle", Messages.getString("VoidItemReport.4"));
        map.put("itemDataSource", (String)new JRTableModelDataSource((TableModel)this.voidItemReportModel));
        map.put("ticketDataSource", (String)new JRTableModelDataSource((TableModel)this.voidTicketReportModel));
        if (this.voidTicketReportModel.getRowCount() != 0) {
            map.put("ticketSection", Messages.getString("VoidItemReport.16"));
            map.put("ticketReport", (String)ticketReport);
        }
        map.put("itemSection", Messages.getString("VoidItemReport.18"));
        map.put("itemReport", (String)itemReport);
        JasperReport masterReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("void_item_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        this.viewer = ReportUtil.getCustomJRViewer(print);
    }

    private static String createOrderTypeString(List<OrderType> selectedOrdertypes) {
        if (selectedOrdertypes == null || selectedOrdertypes.isEmpty()) {
            return POSConstants.ALL;
        }
        String orderTypeNames = "";
        Iterator<OrderType> iterator = selectedOrdertypes.iterator();
        while (iterator.hasNext()) {
            OrderType orderType = iterator.next();
            orderTypeNames = orderTypeNames + orderType.getName();
            if (!iterator.hasNext()) continue;
            orderTypeNames = orderTypeNames + ", ";
        }
        return orderTypeNames;
    }

    private void populateReportParams(HashMap map) {
        map.put("VSRDate", Messages.getString("VoidItemReport.1"));
        map.put("VSRCreateDate", Messages.getString("VoidItemReport.5"));
        map.put("VSRTicketId", POSConstants.TICKET_ID);
        map.put("VSRItem", POSConstants.ITEM);
        map.put("VSRQty", POSConstants.QTY);
        map.put("VSRReason", Messages.getString("VSRReason"));
        map.put("VSRWasted", Messages.getString("VSRWasted"));
        map.put("VSRDeletedBy", Messages.getString("VSRDeletedBy"));
        map.put("VSRAmount", POSConstants.AMOUNT);
        map.put("VSRGrandT", POSConstants.GRAND_TOTAL);
        map.put("VSRTerminalName", Messages.getString("VoidItemReport.2"));
        map.put("VSROrderType", Messages.getString("VoidItemReport.3"));
    }

    @Override
    public boolean isDateRangeSupported() {
        return true;
    }

    @Override
    public boolean isTypeSupported() {
        return true;
    }

    public boolean createModels() {
        List<TicketItem> list;
        Date date1 = DateUtil.startOfDay(this.getStartDate());
        Date date2 = DateUtil.endOfDay(this.getEndDate());
        ArrayList<Integer> terminalIdList = new ArrayList<Integer>();
        if (this.getTerminals() != null) {
            for (Terminal terminal : this.getTerminals()) {
                terminalIdList.add(terminal.getId());
            }
        }
        ArrayList<String> orderTypeIdList = new ArrayList<String>();
        if (this.getOrderTypes() != null) {
            for (OrderType orderType : this.getOrderTypes()) {
                orderTypeIdList.add(orderType.getId());
            }
        }
        if ((list = TicketItemDAO.getInstance().findItemsForVoidItemReport(date1, date2, terminalIdList, orderTypeIdList)) == null || list.isEmpty()) {
            return false;
        }
        HashMap<String, String> userNameMap = new HashMap<String, String>();
        ArrayList<DeletedItem> deletedItems = new ArrayList<DeletedItem>();
        for (TicketItem ticketItem : list) {
            DeletedItem deletedItem = new DeletedItem();
            deletedItem.setName(ticketItem.getName());
            deletedItem.setQuantity(Math.abs(ticketItem.getQuantity()));
            deletedItem.setVoidDate(ticketItem.getVoidDate());
            deletedItem.setTotal(Math.abs(ticketItem.getTotalAmount()));
            deletedItem.setTicketId(ticketItem.getTicket().getId());
            deletedItem.setCreateDate(ticketItem.getCreateDate());
            deletedItem.setOrderTypeName(ticketItem.getTicket().getOrderTypeName());
            deletedItem.setTerminalName(ticketItem.getTicket().getTerminal().getName());
            deletedItem.setVoidReason(ticketItem.getVoidReason());
            deletedItem.setItemWasted(POSUtil.getBoolean(ticketItem.getProperty("wasted")));
            String userId = ticketItem.getProperty("voidedByUserId");
            if (StringUtils.isNotBlank((String)userId)) {
                String voidUserName = (String)userNameMap.get(userId);
                if (voidUserName == null) {
                    voidUserName = UserDAO.getInstance().get(userId).getFullName();
                    userNameMap.put(userId, voidUserName);
                }
                deletedItem.setVoidUserName(voidUserName);
            } else {
                deletedItem.setVoidUserName(ticketItem.getTicket().getOwnerName());
            }
            deletedItems.add(deletedItem);
        }
        List<Ticket> voidTickets = TicketDAO.getInstance().findVoidTicketByDate(date1, date2, terminalIdList, orderTypeIdList);
        ArrayList<DeletedItem> deletedTickets = new ArrayList<DeletedItem>();
        this.voidItemReportModel = new VoidItemReportModel();
        this.voidItemReportModel.setItems(deletedItems);
        for (Ticket voidTicket : voidTickets) {
            DeletedItem deletedItem = new DeletedItem();
            deletedItem.setId(voidTicket.getId());
            deletedItem.setCreateDate(voidTicket.getCreateDate());
            deletedItem.setVoidDate(voidTicket.getClosingDate());
            deletedItem.setTicketId(voidTicket.getId());
            deletedItem.setTerminalName(voidTicket.getTerminal() == null ? "" : voidTicket.getTerminal().getName());
            deletedItem.setOrderTypeName(voidTicket.getOrderType() == null ? "" : voidTicket.getOrderType().getName());
            List<VoidItem> voidItemList = VoidItemDAO.getInstance().getVoidItems(voidTicket.getId());
            double amount = 0.0;
            double quantity = 0.0;
            if (voidItemList != null) {
                for (VoidItem item : voidItemList) {
                    amount += item.getTotalPrice().doubleValue();
                    quantity += item.getQuantity().doubleValue();
                }
                deletedItem.setQuantity(quantity);
                deletedItem.setTotal(amount);
            }
            deletedItem.setVoidReason(voidTicket.getVoidReason());
            deletedItem.setOwner(voidTicket.getOwner());
            deletedItem.setVoidUserName(voidTicket.getVoidedBy() == null ? "" : voidTicket.getVoidedBy().getFullName());
            deletedTickets.add(deletedItem);
        }
        this.voidTicketReportModel = new VoidItemReportModel();
        this.voidTicketReportModel.setItems(deletedTickets);
        return true;
    }
}

