/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.DayOfWeek;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.WeeklyPayrollReportData;
import com.floreantpos.report.WeeklyPayrollReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class WeeklyPayrollReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;
    private JComboBox jcbEmployee;
    private JComboBox<DayOfWeek> cbFirstDayOfWeek;

    public WeeklyPayrollReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        Date toDate;
        DayOfWeek firstDay = (DayOfWeek)((Object)this.cbFirstDayOfWeek.getSelectedItem());
        int firstDayOfWeek = firstDay.getValue();
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        Object selectedItem = this.jcbEmployee.getSelectedItem();
        User user = null;
        if (selectedItem instanceof User) {
            user = (User)selectedItem;
        }
        AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
        List<WeeklyPayrollReportData> findPayroll = dao.findWeeklyPayroll(fromDate, toDate, user, firstDayOfWeek);
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("WeeklyPayrollReport"));
        HashMap properties = new HashMap();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        WeeklyPayrollReportModel reportModel = new WeeklyPayrollReportModel();
        reportModel.setRows(findPayroll);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap map) {
        map.put("RTitle", Messages.getString("WeeklyPayrollReportAction.0"));
        map.put("colEID", Messages.getString("EmployeeId"));
        map.put("colEName", Messages.getString("EmployeeName"));
        map.put("colRole", Messages.getString("colRole"));
        map.put("colRHW", Messages.getString("RegularH") + "<br/>" + Messages.getString("Worked"));
        map.put("colOHW", Messages.getString("OvertimeH") + "<br/>" + Messages.getString("Worked"));
        map.put("colRPay", Messages.getString("Regular") + "<br/>" + Messages.getString("PAYMENT"));
        map.put("colOTPay", Messages.getString("OvertimeTH") + "<br/>" + Messages.getString("PAYMENT"));
        map.put("colTHWork", Messages.getString("TotalH") + "<br/>" + Messages.getString("Worked"));
        map.put("colTPay", POSConstants.TOTAL + "<br/>" + Messages.getString("PAYMENT"));
        map.put("colDTips", Messages.getString("declaredTips"));
        map.put("colNCTips", Messages.getString("NoncashTips"));
    }

    private void createUI() {
        this.cbFirstDayOfWeek = new JComboBox<DayOfWeek>(DayOfWeek.values());
        this.cbFirstDayOfWeek.setSelectedIndex(1);
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getDeafultDate();
        this.toDatePicker.setDate(new Date());
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    WeeklyPayrollReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        this.jcbEmployee = new JComboBox();
        UserDAO dao = new UserDAO();
        List<User> userTypes = dao.findActiveUsersForPayroll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(userTypes);
        this.jcbEmployee.setModel(new DefaultComboBoxModel(list));
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(Messages.getString("WeeklyPayrollReportView.2")));
        topPanel.add(this.cbFirstDayOfWeek);
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        topPanel.add(this.jcbEmployee);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public static class LaborReportData {
        private String period;
        private int noOfChecks;
        private int noOfGuests;
        private double sales;
        private double manHour;
        private double labor;
        private double salesPerMHr;
        private double guestsPerMHr;
        private double checkPerMHr;
        private double laborCost;

        public double getCheckPerMHr() {
            return this.checkPerMHr;
        }

        public void setCheckPerMHr(double checkPerMHr) {
            this.checkPerMHr = checkPerMHr;
        }

        public double getGuestsPerMHr() {
            return this.guestsPerMHr;
        }

        public void setGuestsPerMHr(double guestsPerMHr) {
            this.guestsPerMHr = guestsPerMHr;
        }

        public double getLabor() {
            return this.labor;
        }

        public void setLabor(double labor) {
            this.labor = labor;
        }

        public double getLaborCost() {
            return this.laborCost;
        }

        public void setLaborCost(double laborCost) {
            this.laborCost = laborCost;
        }

        public double getManHour() {
            return this.manHour;
        }

        public void setManHour(double manHour) {
            this.manHour = manHour;
        }

        public int getNoOfChecks() {
            return this.noOfChecks;
        }

        public void setNoOfChecks(int noOfChecks) {
            this.noOfChecks = noOfChecks;
        }

        public int getNoOfGuests() {
            return this.noOfGuests;
        }

        public void setNoOfGuests(int noOfGuests) {
            this.noOfGuests = noOfGuests;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public double getSales() {
            return this.sales;
        }

        public void setSales(double sales) {
            this.sales = sales;
        }

        public double getSalesPerMHr() {
            return this.salesPerMHr;
        }

        public void setSalesPerMHr(double salesPerMHr) {
            this.salesPerMHr = salesPerMHr;
        }
    }

    public static enum PayrollType {
        WEEKLY(Messages.getString("WeeklyPayrollReportView.0")),
        DO_WEEKLY(Messages.getString("WeeklyPayrollReportView.1"));

        private String name;

        private PayrollType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

