/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportItem;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesReportModel;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class SalesReportService {
    private SalesReportModel itemReportModel;
    private SalesReportModel modifierReportModel;
    private Date startDate;
    private Date toDate;
    private List<Terminal> terminals;
    private List<MenuGroup> groups;
    List<OrderType> orderTypes;
    List<MenuCategory> menuCategories;
    private boolean isInventory;
    private boolean showInGroups;
    private boolean isConsolidate;
    private boolean includeFreeItems;

    public SalesReportService(Date startDate, Date toDate, List<Terminal> terminals, List<MenuGroup> groups, List<OrderType> orderTypes, List<MenuCategory> menuCategories, boolean isInventory, boolean showInGroups, boolean consolidate, boolean includeFreeItems) {
        this.startDate = startDate;
        this.toDate = toDate;
        this.terminals = terminals;
        this.groups = groups;
        this.orderTypes = orderTypes;
        this.menuCategories = menuCategories;
        this.isInventory = isInventory;
        this.showInGroups = showInGroups;
        this.isConsolidate = consolidate;
        this.includeFreeItems = includeFreeItems;
    }

    public JasperPrint createJasperPrint() throws JRException {
        JasperReport modifierReport;
        JasperReport itemReport;
        this.createModels();
        if (this.isInventory) {
            itemReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_sub_report"));
            modifierReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_sub_report"));
        } else {
            itemReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("non_inv_sales_sub_report"));
            modifierReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("non_inv_sales_sub_report"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(map);
        ReportUtil.populateReportHeaderWithTerminals(map, this.terminals, this.startDate, this.toDate, null);
        map.put("orderTypeName", ReportUtil.reportLabelWithBoldTag(POSConstants.ORDER_TYPE) + ": " + this.createOrderTypeNameString());
        map.put("menuCategoryName", ReportUtil.reportLabelWithBoldTag(POSConstants.MENU_CATEGORY) + ": " + this.createMenuCategoryNameString());
        String reportTitle = this.isInventory ? Messages.getString("SalesReport.3") : Messages.getString("SalesReport.9");
        map.put("reportTitle", reportTitle);
        map.put("itemDataSource", new JRTableModelDataSource((TableModel)this.itemReportModel));
        map.put("modifierDataSource", new JRTableModelDataSource((TableModel)this.modifierReportModel));
        map.put("currencySymbol", CurrencyUtil.getCurrencySymbolWithBracket());
        map.put("itemReport", itemReport);
        map.put("isShowGroup", this.showInGroups);
        map.put("isConsolidate", !this.isConsolidate);
        map.put("modifierReport", modifierReport);
        map.put("modifierReportEnable", Boolean.FALSE);
        map.put("colId", ReportUtil.reportLabelWithBoldTag(POSConstants.ID));
        map.put("colName", ReportUtil.reportLabelWithBoldTag(POSConstants.NAME));
        map.put("colQty", ReportUtil.reportLabelWithBoldTag(POSConstants.QTY));
        map.put("colUnit", ReportUtil.reportLabelWithBoldTag(POSConstants.UNIT));
        map.put("colSales", ReportUtil.reportLabelWithBoldTag(POSConstants.SALES));
        map.put("colDiscount", ReportUtil.reportLabelWithBoldTag(POSConstants.DISCOUNT));
        map.put("colCost", ReportUtil.reportLabelWithBoldTag(POSConstants.COST));
        map.put("colCostPer", ReportUtil.reportLabelWithBoldTag(POSConstants.COST_PERCENTAGE));
        map.put("colNetTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.NET_TOTAL));
        map.put("colTax", ReportUtil.reportLabelWithBoldTag(POSConstants.TAX));
        map.put("colSC", ReportUtil.reportLabelWithBoldTag(POSConstants.S_C));
        map.put("colGrossT", ReportUtil.reportLabelWithBoldTag(POSConstants.GROSS_TOTAL));
        map.put("groupTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GROUP_TOTAL));
        map.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
        if (this.modifierReportModel.getItems().size() > 0) {
            map.put("modifierSection", Messages.getString("SalesReportService.5"));
        }
        JasperReport masterReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JREmptyDataSource());
        return print;
    }

    private void createModels() {
        LinkedHashMap<String, ReportItem> itemMap = new LinkedHashMap<String, ReportItem>();
        LinkedHashMap<String, ReportItem> modifierMap = new LinkedHashMap<String, ReportItem>();
        List<Integer> terminalIdList = POSUtil.getIntegerIds(this.terminals, Terminal.class);
        List<String> groupIdList = POSUtil.getStringIds(this.groups, MenuGroup.class);
        List<String> orderTypeIdList = POSUtil.getStringIds(this.orderTypes, OrderType.class);
        List<String> menuCategoryIdList = POSUtil.getStringIds(this.menuCategories, MenuCategory.class);
        List<TicketItem> ticketItems = TicketItemDAO.getInstance().findSoldItems(this.startDate, this.toDate, terminalIdList, groupIdList, orderTypeIdList, menuCategoryIdList, this.isInventory, this.showInGroups);
        ArrayList<TicketItemModifier> ticketModifierItems = new ArrayList<TicketItemModifier>();
        for (TicketItem ticketItem : ticketItems) {
            List<TicketItem> comboItems;
            if (ticketItem.getUnitPrice() == 0.0 && !this.includeFreeItems) continue;
            this.populateReportTicketItemToMap(ticketItem, ticketItem.getUnitPrice(), itemMap);
            this.populateModifiers(ticketItem, ticketModifierItems);
            if (!ticketItem.isComboItem().booleanValue() || (comboItems = ((ComboTicketItem)ticketItem).getComboItems()) == null || comboItems.size() <= 0) continue;
            for (TicketItem comboChildTicketItem : comboItems) {
                comboChildTicketItem.setUnitPrice(0.0);
                comboChildTicketItem.calculatePrice();
                this.populateReportTicketItemToMap(comboChildTicketItem, ticketItem.getUnitPrice(), itemMap);
                this.populateModifiers(comboChildTicketItem, ticketModifierItems);
            }
        }
        this.itemReportModel = new SalesReportModel();
        ArrayList<ReportItem> arrayList = new ArrayList<ReportItem>(((HashMap)itemMap).values());
        if (this.showInGroups) {
            Collections.sort(arrayList, new Comparator<ReportItem>(){

                @Override
                public int compare(ReportItem o1, ReportItem o2) {
                    if (o1.getGroupName() == o2.getGroupName()) {
                        return 0;
                    }
                    if (o1.getGroupName() == null) {
                        return 1;
                    }
                    if (o2.getGroupName() == null) {
                        return -1;
                    }
                    return o1.getGroupName().compareTo(o2.getGroupName());
                }
            });
        }
        this.itemReportModel.setItems(arrayList);
        for (TicketItemModifier modifier : ticketModifierItems) {
            if (modifier.getUnitPrice() == 0.0 && !this.includeFreeItems) continue;
            String itemId = modifier.getItemId();
            String key = (itemId == null ? modifier.getName() : itemId) + "-" + modifier.getModifierType() + "-" + modifier.getUnitPrice();
            ReportItem modifierReportItem = (ReportItem)((HashMap)modifierMap).get(key);
            if (modifierReportItem == null) {
                modifierReportItem = new ReportItem();
                modifierReportItem.setId(itemId);
                modifierReportItem.setName(modifier.getName());
                modifierReportItem.setTaxRate(modifier.getTotalTaxRate());
                modifierReportItem.setAdjustedPrice(modifier.getAdjustedUnitPrice());
                modifierMap.put(key, modifierReportItem);
            }
            modifierReportItem.setQuantity(modifierReportItem.getQuantity() + modifier.getItemQuantity() * modifier.getTicketItemQuantity());
        }
        this.modifierReportModel = new SalesReportModel();
        ArrayList<ReportItem> arrayList2 = new ArrayList<ReportItem>(((HashMap)modifierMap).values());
        this.modifierReportModel.setItems(arrayList2);
    }

    private void populateModifiers(TicketItem ticketItem, List<TicketItemModifier> modifiableItems) {
        if (ticketItem instanceof ModifiableTicketItem) {
            List<TicketItemModifier> ticketItemModifiers = ((ModifiableTicketItem)ticketItem).getTicketItemModifiers();
            modifiableItems.addAll(ticketItemModifiers);
        }
    }

    private void removeZeroQuantityItems(Collection<ReportItem> values) {
        Iterator<ReportItem> iterator = values.iterator();
        while (iterator.hasNext()) {
            ReportItem reportItem = iterator.next();
            if (reportItem.getQuantity() != 0.0) continue;
            iterator.remove();
        }
    }

    private void populateReportTicketItemToMap(TicketItem ticketItem, Double price, HashMap<String, ReportItem> itemMap) {
        ReportItem reportItem;
        String menuItemId = ticketItem.getMenuItemId();
        String key = (menuItemId == null ? ticketItem.getName() : menuItemId) + "-" + price;
        if (ticketItem.isOpenItem()) {
            key = key + "_" + ticketItem.getName();
        }
        if ((reportItem = itemMap.get(key)) == null) {
            reportItem = new ReportItem();
            reportItem.setId(key);
            reportItem.setCost(ticketItem.getUnitCost());
            reportItem.setName(ticketItem.getName());
            reportItem.setUnit(ticketItem.getUnitName());
            reportItem.setTaxRate(ticketItem.getTotalTaxRate());
            reportItem.setGroupId(ticketItem.getGroupId());
            reportItem.setGroupName(ticketItem.getGroupName());
            reportItem.setBarcode(menuItemId);
            reportItem.setAdjustedPrice(ticketItem.getAdjustedUnitPrice());
            itemMap.put(key, reportItem);
        }
        reportItem.setPrice(reportItem.getPrice() + ticketItem.getSubtotalAmount());
        reportItem.setQuantity(reportItem.getQuantity() + ticketItem.getQuantity());
        reportItem.setDiscount(reportItem.getDiscount() + ticketItem.getAdjustedDiscount());
        reportItem.setGrossTotal(reportItem.getGrossTotal() + ticketItem.getAdjustedSubtotal());
        reportItem.setTaxTotal(reportItem.getTaxTotal() + ticketItem.getAdjustedTax());
        reportItem.setServiceCharge(reportItem.getServiceCharge() + ticketItem.getServiceCharge());
        double netTotal = reportItem.getPrice() - reportItem.getDiscount();
        reportItem.setGrossTotal(netTotal);
        double grossTotal = netTotal + reportItem.getServiceCharge() + reportItem.getTaxTotal();
        reportItem.setNetTotal(grossTotal);
    }

    private String createOrderTypeNameString() {
        if (this.orderTypes == null || this.orderTypes.isEmpty()) {
            return POSConstants.ALL;
        }
        String orderTypeNames = "";
        Iterator<OrderType> iterator = this.orderTypes.iterator();
        while (iterator.hasNext()) {
            OrderType orderType = iterator.next();
            orderTypeNames = orderTypeNames + orderType.getName();
            if (!iterator.hasNext()) continue;
            orderTypeNames = orderTypeNames + ", ";
        }
        return orderTypeNames;
    }

    private String createMenuCategoryNameString() {
        if (this.menuCategories == null) {
            return POSConstants.ALL;
        }
        String menuCategoryNames = "";
        Iterator<MenuCategory> iterator = this.menuCategories.iterator();
        while (iterator.hasNext()) {
            MenuCategory menuCategory = iterator.next();
            menuCategoryNames = menuCategoryNames + menuCategory.getName();
            if (!iterator.hasNext()) continue;
            menuCategoryNames = menuCategoryNames + ", ";
        }
        return menuCategoryNames;
    }
}

