/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.reservation;

import com.floreantpos.Messages;
import com.floreantpos.model.Customer;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.reservation.ReservationDetails;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;

public class ReservationDetailsDialog
extends POSDialog {
    private Ticket ticket;
    private ReservationDetailsTableModel reservationDetailsModel;

    public ReservationDetailsDialog(Ticket ticket) {
        this.ticket = ticket;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Details of reservation no " + this.ticket.getId());
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        JTable table = new JTable();
        table.setSelectionMode(0);
        this.reservationDetailsModel = new ReservationDetailsTableModel();
        table.setModel(this.reservationDetailsModel);
        this.reservationDetailsModel.setPageSize(10);
        table.setRowHeight(PosUIManager.getSize(60));
        table.setDefaultRenderer(Object.class, new PosTableRenderer());
        table.setGridColor(Color.LIGHT_GRAY);
        PosScrollPane scrollPane = new PosScrollPane(table);
        centerPanel.add((Component)scrollPane, "Center");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnOk = new PosButton("OK");
        buttonPanel.add((Component)btnOk, "grow");
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReservationDetailsDialog.this.dispose();
            }
        });
        this.add((Component)buttonPanel, "South");
        this.initData();
    }

    private void initData() {
        if (this.ticket == null) {
            return;
        }
        List<TicketItem> itemList = this.ticket.getTicketItems();
        if (itemList == null) {
            return;
        }
        ArrayList<ReservationDetails> reservationDetailsList = new ArrayList<ReservationDetails>();
        for (TicketItem item : itemList) {
            ReservationDetails reservationDetails = new ReservationDetails();
            reservationDetails.setCreationDate(this.ticket.getCreateDate());
            reservationDetails.setDeliveryDate(this.ticket.getDeliveryDate());
            reservationDetails.setTicketItem(item);
            Customer customer = CustomerDAO.getInstance().findById(this.ticket.getCustomerId());
            reservationDetails.setCustomer(customer);
            SalesArea salesArea = SalesAreaDAO.getInstance().find(this.ticket.getSalesArea());
            reservationDetails.setSalesArea(salesArea);
            reservationDetailsList.add(reservationDetails);
        }
        this.reservationDetailsModel.setRows(reservationDetailsList);
        this.reservationDetailsModel.setNumRows(reservationDetailsList.size() + 1);
    }

    public void doOk() {
        if (!this.save()) {
            return;
        }
        POSMessageDialog.showMessage(this, Messages.getString("GiftCardActivateView.22"));
        this.dispose();
    }

    private boolean save() {
        return true;
    }

    private class ReservationDetailsTableModel
    extends PaginatedTableModel {
        public ReservationDetailsTableModel() {
            super(new String[]{"CREATION DATE", "RESERVATION DATE", "MEMBER", "ITEM CODE", "ITEM DESC", "QUANTITY", "CHARGE ($)"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ReservationDetails reservationDetails = (ReservationDetails)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return DateUtil.formatFullDateAndTimeAsString(reservationDetails.getCreationDate());
                }
                case 1: {
                    return DateUtil.formatFullDateAndTimeAsString(reservationDetails.getDeliveryDate());
                }
                case 2: {
                    return reservationDetails.getCustomer().getName();
                }
                case 3: {
                    return reservationDetails.getTicketItem().getMenuItemId();
                }
                case 4: {
                    return reservationDetails.getTicketItem().getName();
                }
                case 5: {
                    return NumberUtil.trimDecilamIfNotNeeded(reservationDetails.getTicketItem().getQuantity());
                }
                case 6: {
                    return reservationDetails.getTicketItem().getTotalAmount();
                }
            }
            return null;
        }
    }
}

