/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.NumberUtil;
import org.hibernate.Session;

public class InventoryService {
    private static InventoryService instance;

    public static InventoryService getInstance() {
        if (instance == null) {
            instance = new InventoryService();
        }
        return instance;
    }

    private InventoryService() {
    }

    public void adjustMenuItemCost(MenuItem menuItem, double newCost, double newQuantity, InventoryUnit selectedUnit) {
        try (Session session = TerminalDAO.getInstance().createNewSession();){
            this.adjustMenuItemCost(menuItem, newCost, newQuantity, selectedUnit, session);
        }
    }

    public void adjustMenuItemCost(MenuItem menuItem, double newCost, double newQuantity, InventoryUnit selectedUnit, Session session) {
        Double menuItemOnHand;
        Store store = DataProvider.get().getStore();
        if (store == null || menuItem == null || selectedUnit == null || session == null) {
            return;
        }
        MenuItemDAO.getInstance().refresh(menuItem, session);
        InventoryUnit baseUnit = menuItem.getUnit();
        if (selectedUnit != null && baseUnit != null && !baseUnit.equals(selectedUnit)) {
            Double selectedConversionRate = selectedUnit.getConversionRate();
            Double baseConversionRate = baseUnit.getConversionRate();
            newCost *= selectedConversionRate / baseConversionRate;
            newQuantity *= menuItem.getUnitQuantity(selectedUnit, baseUnit);
        }
        if ((menuItemOnHand = menuItem.getUnitOnHand()) < 0.0) {
            menuItemOnHand = 0.0;
        }
        Double menuItemCost = menuItem.getCost();
        double menuItemAverageCost = NumberUtil.round((menuItemOnHand * menuItemCost + newQuantity * newCost) / (menuItemOnHand + newQuantity));
        if (store.isInventoryAvgPricingMethod()) {
            menuItem.setCost(menuItemAverageCost);
        } else {
            menuItem.setCost(newCost);
        }
        menuItem.setLastPurchasedCost(newCost);
        menuItem.setAverageUnitPurchasePrice(menuItemAverageCost);
    }
}

