/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.model.util.ColorPref;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ColoredCircleRenderer
extends DefaultTableCellRenderer {
    ColorPref colorPref;

    public ColoredCircleRenderer() {
    }

    public ColoredCircleRenderer(ColorPref colorPref) {
        this.colorPref = colorPref;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.colorPref = (ColorPref)value;
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.colorPref == null) {
            return;
        }
        int x = 5;
        int gap = 16;
        if (this.colorPref.isBlueFlag()) {
            g.setColor(new Color(2453759));
            g.fillOval(x, this.getHeight() / 2 - 5, 10, 10);
            x += gap;
        }
        if (this.colorPref.isGreenFlag()) {
            g.setColor(new Color(3787607));
            g.fillOval(x, this.getHeight() / 2 - 5, 10, 10);
            x += gap;
        }
        if (this.colorPref.isOrangeFlag()) {
            g.setColor(new Color(16348726));
            g.fillOval(x, this.getHeight() / 2 - 5, 10, 10);
            x += gap;
        }
        if (this.colorPref.isPurpleFlag()) {
            g.setColor(new Color(9306366));
            g.fillOval(x, this.getHeight() / 2 - 5, 10, 10);
            x += gap;
        }
        if (this.colorPref.isRedFlag()) {
            g.setColor(new Color(16259598));
            g.fillOval(x, this.getHeight() / 2 - 5, 10, 10);
            x += gap;
        }
        if (this.colorPref.isYellowFlag()) {
            g.setColor(new Color(16102683));
            g.fillOval(x, this.getHeight() / 2 - 5, 10, 10);
            x += gap;
        }
    }

    public ColorPref getColorPref() {
        return this.colorPref;
    }

    public void setColorPref(ColorPref colorPref) {
        this.colorPref = colorPref;
    }
}

