/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.model.NumberBound;
import com.floreantpos.util.NumberUtil;
import java.awt.Toolkit;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang.StringUtils;

public class DoubleDocument
extends PlainDocument {
    private static final String STR_EMPTY_STRING = "";
    private int length;
    private Pattern pattern;
    private NumberFormat formatter;

    public DoubleDocument() {
        this(8);
    }

    public DoubleDocument(int beforeDecimal) {
        this(beforeDecimal, 6);
    }

    public DoubleDocument(int beforeDecimal, int afterDecimal) {
        this.length = beforeDecimal;
        if (afterDecimal < 6) {
            afterDecimal = 6;
        }
        this.pattern = NumberUtil.getPattern(new NumberBound(beforeDecimal, afterDecimal));
        this.formatter = NumberFormat.getInstance();
        this.formatter.setMaximumFractionDigits(afterDecimal);
    }

    @Override
    public void remove(int offs, int len) throws BadLocationException {
        char separator;
        String value = this.getText(0, this.getLength());
        if (value.contains(String.valueOf(separator = NumberUtil.getDecimalSeparator()))) {
            String[] parts = value.split("\\" + separator, 2);
            String initString = parts[1];
            char charAt = value.charAt(offs);
            if (charAt == separator) {
                len = initString.length() + 1;
            }
        }
        super.remove(offs, len);
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        String oldValue = this.getText(0, this.getLength());
        if (StringUtils.isEmpty((String)oldValue)) {
            try {
                oldValue = str = this.formatter.format(Double.parseDouble(str)).replaceAll("\\" + NumberUtil.getGroupingSeparator(), STR_EMPTY_STRING);
            }
            catch (Exception e0) {
                if (StringUtils.isBlank((String)str)) {
                    str = STR_EMPTY_STRING;
                    oldValue = STR_EMPTY_STRING;
                }
                oldValue = str;
            }
        }
        StringBuilder valueBuilder = new StringBuilder();
        valueBuilder.append(oldValue.substring(0, offs)).append(str).append(oldValue.substring(offs, this.getLength()));
        Matcher matcher = this.pattern.matcher(valueBuilder.toString());
        if (matcher.matches()) {
            super.insertString(offs, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public int getMaximumLength() {
        return this.length;
    }

    public void setMaximumLength(int length) {
        this.length = length;
    }
}

