/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class HorizontalTouchScrollPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int lastX;
    private int distX;
    private double speedX;
    private boolean scroll = false;
    private boolean dragged = false;

    public HorizontalTouchScrollPanel() {
    }

    public HorizontalTouchScrollPanel(LayoutManager layout) {
        super(layout);
        this.addListener(this);
    }

    public boolean wasDragged() {
        return this.dragged;
    }

    private JScrollPane getParentScrollPane(Component p) {
        if (p instanceof JScrollPane) {
            return (JScrollPane)p;
        }
        if (p == null) {
            return null;
        }
        return this.getParentScrollPane(p.getParent());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        JScrollPane scrollPane = this.getParentScrollPane(this.getParent());
        if (scrollPane != null) {
            JScrollBar hbar = scrollPane.getHorizontalScrollBar();
            int currentX = e.getXOnScreen();
            this.distX = this.lastX - currentX;
            this.dragged = true;
            if (this.scroll) {
                int hScroll = this.distX + hbar.getValue();
                hbar.setValue(hScroll);
                if (Math.abs(this.distX) > 1) {
                    this.speedX = this.distX + this.distX;
                }
            }
            this.lastX = currentX;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.lastX = e.getXOnScreen();
            this.scroll = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.scroll = false;
        }
        if (Math.abs(this.speedX) <= 4.0) {
            return;
        }
        JScrollPane scrollPane = this.getParentScrollPane(this.getParent());
        if (scrollPane != null) {
            JScrollBar hbar = scrollPane.getHorizontalScrollBar();
            int max = hbar.getMaximum();
            double brakingforce = 1.04;
            for (int count = 1000; count > 0; --count) {
                int val;
                this.speedX /= brakingforce;
                if (Math.abs(this.speedX) < 1.5) {
                    brakingforce = 1.02;
                }
                if (Math.abs(this.speedX) < 1.0 || (val = hbar.getValue()) < 0 || val > max) break;
                hbar.setValue((int)this.speedX + val);
            }
            if (this.dragged) {
                e.consume();
                this.dragged = false;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public Component add(Component comp) {
        this.addListener(comp);
        return super.add(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.addListener(comp);
        this.addImpl(comp, constraints, -1);
    }

    @Override
    public void removeAll() {
        if (this.getComponentCount() > 0) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                this.removeListener(component);
            }
        }
        super.removeAll();
    }

    @Override
    public void remove(Component comp) {
        this.removeListener(comp);
        super.remove(comp);
    }

    private void addListener(Component comp) {
        JPanel panel;
        comp.addMouseListener(this);
        comp.addMouseMotionListener(this);
        if (comp instanceof JPanel && (panel = (JPanel)comp).getComponentCount() > 0) {
            for (int i = 0; i < panel.getComponentCount(); ++i) {
                Component component = panel.getComponent(i);
                this.addListener(component);
            }
        }
    }

    private void removeListener(Component comp) {
        JPanel panel;
        comp.removeMouseListener(this);
        comp.removeMouseMotionListener(this);
        if (comp instanceof JPanel && (panel = (JPanel)comp).getComponentCount() > 0) {
            for (int i = 0; i < panel.getComponentCount(); ++i) {
                Component component = panel.getComponent(i);
                this.removeListener(component);
            }
        }
    }
}

