/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.ComboBoxModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.plaf.basic.ComboPopup;

public class MultiSelectComboBox<E>
extends JComboBox<E> {
    private static final String ALL = "ALL";
    private boolean keepOpen;
    private List<E> items = new ArrayList();
    private CheckableItem itemAll;

    public MultiSelectComboBox() {
        this.initializeRenderer();
        this.setPreferredSize(new Dimension(200, 20));
    }

    public MultiSelectComboBox(List<E> items) {
        this();
        this.setItems(items);
    }

    public void setItems(List<E> itemList) {
        this.items = itemList;
        ComboBoxModel model = new ComboBoxModel();
        this.itemAll = new CheckableItem(ALL, false);
        model.addElement(this.itemAll);
        for (E object : itemList) {
            CheckableItem checkableItem = new CheckableItem(object, false);
            model.addElement(checkableItem);
        }
        this.setModel(model);
    }

    public List<E> getSelectedItems() {
        ComboBoxModel m = (ComboBoxModel)this.getModel();
        List items = m.getDataList();
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        for (Object object : items) {
            CheckableItem obj2 = (CheckableItem)object;
            if (obj2.item instanceof String || !obj2.isSelected()) continue;
            selectedItems.add(obj2.item);
        }
        return selectedItems.size() == 0 ? null : selectedItems;
    }

    public void setSelectedItems(List<E> itemsToBeSelected) {
        if (itemsToBeSelected == null || itemsToBeSelected.isEmpty()) {
            this.itemAll.selected = true;
            this.setSelectedItem(this.itemAll);
            return;
        }
        ComboBoxModel m = (ComboBoxModel)this.getModel();
        List items = m.getDataList();
        for (Object object : items) {
            CheckableItem obj2 = (CheckableItem)object;
            if (obj2.item instanceof String) {
                if (itemsToBeSelected.size() != items.size() - 1) continue;
                this.setSelectedItem(obj2);
                return;
            }
            obj2.selected = false;
            for (E object2 : itemsToBeSelected) {
                if (!obj2.item.equals(object2) || obj2.isSelected()) continue;
                obj2.selected = true;
                this.setSelectedItem(obj2);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private void initializeRenderer() {
        this.setRenderer(new CheckBoxCellRenderer());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getModifiers() == 16) {
                    MultiSelectComboBox.this.updateItem(MultiSelectComboBox.this.getSelectedIndex());
                    MultiSelectComboBox.this.keepOpen = true;
                }
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "checkbox-select");
        this.getActionMap().put("checkbox-select", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Accessible a = MultiSelectComboBox.this.getAccessibleContext().getAccessibleChild(0);
                if (a instanceof ComboPopup) {
                    ComboPopup pop = (ComboPopup)((Object)a);
                    MultiSelectComboBox.this.updateItem(pop.getList().getSelectedIndex());
                }
            }
        });
    }

    public void updateItem(int index) {
        if (this.isPopupVisible()) {
            Object item = this.getItemAt(index);
            CheckableItem items = (CheckableItem)item;
            items.selected ^= true;
            this.setSelectedIndex(-1);
            this.setSelectedItem(items);
            if (item.toString().equals(ALL)) {
                this.unselectAllItems();
                this.hidePopup();
            }
        }
    }

    public void unselectAllItems() {
        ComboBoxModel m = (ComboBoxModel)this.getModel();
        List dataList = m.getDataList();
        for (Object object : dataList) {
            if (!(object instanceof CheckableItem)) continue;
            CheckableItem obj2 = (CheckableItem)object;
            obj2.selected = false;
        }
    }

    @Override
    public void setPopupVisible(boolean v) {
        if (this.keepOpen) {
            this.keepOpen = false;
        } else {
            super.setPopupVisible(v);
        }
    }

    public List<E> getItems() {
        return this.items;
    }

    private class CheckBoxCellRenderer
    implements ListCellRenderer {
        private final JLabel label = new JLabel(" ");
        private final JCheckBox check = new JCheckBox(" ");
        private final JLabel labelAll = new JLabel("ALL");

        private CheckBoxCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            CheckableItem item = (CheckableItem)value;
            if (item != null && item.toString().equals(MultiSelectComboBox.ALL)) {
                if (isSelected) {
                    this.labelAll.setOpaque(true);
                    this.labelAll.setBackground(list.getSelectionBackground());
                    this.labelAll.setForeground(list.getSelectionForeground());
                } else {
                    this.labelAll.setBackground(list.getBackground());
                    this.labelAll.setForeground(list.getForeground());
                }
                return this.labelAll;
            }
            if (index < 0) {
                this.label.setText(this.getCheckedItemString(list.getModel()));
                return this.label;
            }
            this.check.setText(Objects.toString(item, ""));
            this.check.setSelected(item.selected);
            if (isSelected) {
                this.check.setBackground(list.getSelectionBackground());
                this.check.setForeground(list.getSelectionForeground());
            } else {
                this.check.setBackground(list.getBackground());
                this.check.setForeground(list.getForeground());
            }
            return this.check;
        }

        private String getCheckedItemString(ListModel listModel) {
            ArrayList<String> sl = new ArrayList<String>();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object o = listModel.getElementAt(i);
                if (o == MultiSelectComboBox.this.itemAll || !(o instanceof Object) || !((CheckableItem)o).selected) continue;
                sl.add(o.toString());
            }
            if (sl.isEmpty()) {
                sl.add(MultiSelectComboBox.this.itemAll.toString());
            }
            return ((Object)sl).toString();
        }
    }

    public class CheckableItem {
        public Object item;
        public boolean selected;

        public CheckableItem(Object item, boolean selected) {
            this.item = item;
            this.selected = selected;
        }

        public String toString() {
            return this.item.toString();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public Object getItem() {
            return this.item;
        }
    }
}

