/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.event.KeypadEvent;
import com.floreantpos.swing.event.KeypadEventListener;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.text.JTextComponent;
import jiconfont.IconCode;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;

public class NumericKeypad
extends JComponent {
    private static final String CLEAR = "CLEAR";
    private final EventListenerList eventListeners = new EventListenerList();
    private final String text = "";
    private KeypadEvent keypadEvent = null;
    private boolean isProtected = false;
    private JPanel keypadPanel;
    private PosButton posButton0;
    private PosButton posButton1;
    private PosButton btnClear;
    private PosButton posButton2;
    private PosButton posButton3;
    private PosButton posButton4;
    private PosButton posButton5;
    private PosButton posButton6;
    private PosButton posButton7;
    private PosButton posButton8;
    private PosButton posButton9;
    Action goAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            JTextComponent focusedTextComponent = null;
            if (!(focusOwner instanceof JTextComponent)) {
                return;
            }
            focusedTextComponent = (JTextComponent)focusOwner;
            String command = e.getActionCommand();
            if (NumericKeypad.CLEAR.equals(command)) {
                focusedTextComponent.setText("");
            } else {
                focusedTextComponent.replaceSelection(command);
            }
        }
    };
    private PosButton btnDot;

    public NumericKeypad() {
        this.initComponents();
    }

    public synchronized void removeKeypadEventListener(KeypadEventListener listener) {
        this.eventListeners.remove(KeypadEventListener.class, listener);
    }

    public synchronized void addKeypadEventListener(KeypadEventListener listener) {
        this.eventListeners.add(KeypadEventListener.class, listener);
    }

    protected synchronized void fireKeypadEvent(int eventId) {
        Object[] listeners = this.eventListeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KeypadEventListener.class) continue;
            this.keypadEvent = new KeypadEvent(this, eventId);
            ((KeypadEventListener)listeners[i + 1]).receiveKeypadEvent(this.keypadEvent);
        }
    }

    private void initComponents() {
        Font buttonFont = UIManager.getFont("Button.font").deriveFont((float)PosUIManager.getFontSize(32));
        this.keypadPanel = new JPanel();
        this.posButton7 = new PosButton();
        this.posButton7.setFocusable(false);
        this.posButton8 = new PosButton();
        this.posButton8.setFocusable(false);
        this.posButton9 = new PosButton();
        this.posButton9.setFocusable(false);
        this.posButton4 = new PosButton();
        this.posButton4.setFocusable(false);
        this.posButton5 = new PosButton();
        this.posButton5.setFocusable(false);
        this.posButton6 = new PosButton();
        this.posButton6.setFocusable(false);
        this.posButton1 = new PosButton();
        this.posButton1.setFocusable(false);
        this.posButton2 = new PosButton();
        this.posButton2.setFocusable(false);
        this.posButton3 = new PosButton();
        this.posButton3.setFocusable(false);
        this.posButton0 = new PosButton();
        this.posButton0.setFocusable(false);
        this.keypadPanel.setLayout(new GridLayout(4, 3, 5, 5));
        this.posButton7.setAction(this.goAction);
        this.posButton7.setFont(buttonFont);
        this.posButton7.setText("7");
        this.posButton7.setActionCommand("7");
        this.keypadPanel.add(this.posButton7);
        this.posButton8.setAction(this.goAction);
        this.posButton8.setFont(buttonFont);
        this.posButton8.setText("8");
        this.posButton8.setActionCommand("8");
        this.keypadPanel.add(this.posButton8);
        this.posButton9.setAction(this.goAction);
        this.posButton9.setFont(buttonFont);
        this.posButton9.setText("9");
        this.posButton9.setActionCommand("9");
        this.keypadPanel.add(this.posButton9);
        this.posButton4.setAction(this.goAction);
        this.posButton4.setFont(buttonFont);
        this.posButton4.setText("4");
        this.posButton4.setActionCommand("4");
        this.keypadPanel.add(this.posButton4);
        this.posButton5.setAction(this.goAction);
        this.posButton5.setFont(buttonFont);
        this.posButton5.setText("5");
        this.posButton5.setActionCommand("5");
        this.keypadPanel.add(this.posButton5);
        this.posButton6.setAction(this.goAction);
        this.posButton6.setFont(buttonFont);
        this.posButton6.setText("6");
        this.posButton6.setActionCommand("6");
        this.keypadPanel.add(this.posButton6);
        this.posButton1.setAction(this.goAction);
        this.posButton1.setFont(buttonFont);
        this.posButton1.setText("1");
        this.posButton1.setActionCommand("1");
        this.keypadPanel.add(this.posButton1);
        this.posButton2.setAction(this.goAction);
        this.posButton2.setFont(buttonFont);
        this.posButton2.setText("2");
        this.posButton2.setActionCommand("2");
        this.keypadPanel.add(this.posButton2);
        this.posButton3.setAction(this.goAction);
        this.posButton3.setFont(buttonFont);
        this.posButton3.setText("3");
        this.posButton3.setActionCommand("3");
        this.keypadPanel.add(this.posButton3);
        this.btnDot = new PosButton();
        this.btnDot.setFocusable(false);
        this.btnDot.setFont(buttonFont);
        this.btnDot.setAction(this.goAction);
        this.btnDot.setActionCommand(String.valueOf(NumberUtil.getDecimalSeparator()));
        this.btnDot.setText(String.valueOf(NumberUtil.getDecimalSeparator()));
        this.keypadPanel.add(this.btnDot);
        this.posButton0.setAction(this.goAction);
        this.posButton0.setFont(buttonFont);
        this.posButton0.setText("0");
        this.posButton0.setActionCommand("0");
        this.keypadPanel.add(this.posButton0);
        this.setLayout(new BorderLayout(0, 0));
        this.btnClear = new PosButton();
        this.btnClear.setFocusable(false);
        this.keypadPanel.add(this.btnClear);
        this.btnClear.setAction(this.goAction);
        this.btnClear.setIcon(IconFontSwing.buildIcon((IconCode)FontAwesome.WINDOW_CLOSE, (float)PosUIManager.getSize(16)));
        this.btnClear.setText(Messages.getString("NumericKeypad.0"));
        this.btnClear.setActionCommand(CLEAR);
        this.add((Component)this.keypadPanel, "Center");
    }

    public String getText() {
        return "";
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public static void main(String[] args) {
        JPanel p = new JPanel(new BorderLayout());
        p.add(new NumericKeypad());
        JFrame frame = new JFrame();
        frame.getContentPane().add(p);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

