/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Set;
import javax.swing.ImageIcon;

public class OrderTypeButton
extends PosButton
implements MouseListener {
    private OrderType orderType;

    public OrderTypeButton() {
        super("");
        this.setMinimumSize(PosUIManager.getSize(100, 60));
    }

    public OrderTypeButton(OrderType orderType) {
        this.orderType = orderType;
        if (orderType != null) {
            ImageIcon imgIcon = orderType.getImage();
            Color buttonColor = orderType.getButtonColor();
            Color textColor = orderType.getTextColor();
            if (imgIcon != null) {
                if (orderType.isShowImageOnly().booleanValue()) {
                    this.setIcon(POSUtil.scaleImage(imgIcon, 60));
                } else {
                    this.setHorizontalTextPosition(0);
                    this.setVerticalTextPosition(3);
                    this.setText(orderType.name());
                    if (buttonColor != null) {
                        this.setBackground(buttonColor);
                    }
                    if (textColor != null) {
                        this.setForeground(textColor);
                    }
                    this.setIcon(POSUtil.scaleImage(imgIcon, 60));
                }
            } else {
                this.setHorizontalTextPosition(0);
                this.setVerticalTextPosition(3);
                this.setText(orderType.name());
                if (buttonColor != null) {
                    this.setBackground(buttonColor);
                }
                if (textColor != null) {
                    this.setForeground(textColor);
                }
            }
        }
        this.setMinimumSize(PosUIManager.getSize(100, 60));
        this.addMouseListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (!this.hasPermission()) {
            POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
            return;
        }
        try {
            this.orderType = DataProvider.get().getOrderType(this.orderType.getId());
            if (this.orderType.isRetailOrder().booleanValue()) {
                try {
                    OrderServiceFactory.getOrderService().createNewTicket(this.orderType, null, null);
                    RootView.getInstance().showView("ORDER_VIEW");
                }
                catch (TicketAlreadyExistsException e1) {
                    PosLog.error(this.getClass(), e1);
                }
            } else if (this.orderType.isShowTableSelection().booleanValue() || this.orderType.isBarTab().booleanValue()) {
                TableSelectorDialog dialog = TableSelectorFactory.createTableSelectorDialog(this.orderType);
                dialog.setTitle(Messages.getString("OrderTypeButton.0"));
                dialog.setCreateNewTicket(true);
                dialog.getTableSelector().setTicketTransferMode(false);
                dialog.getTableSelector().setHomeViewMode(Boolean.FALSE);
                dialog.updateView(true);
                dialog.openUndecoratedFullScreen();
            } else if (this.orderType.isRequiredCustomerData().booleanValue()) {
                CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.orderType);
                dialog.setCreateNewTicket(false);
                dialog.updateView(true);
                dialog.openUndecoratedFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
                OrderServiceFactory.getOrderService().createNewTicket(this.orderType, null, dialog.getSelectedCustomer());
            } else {
                OrderServiceFactory.getOrderService().createNewTicket(this.orderType, null, null);
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(this.getParent(), e2.getMessage(), e2);
        }
    }

    private boolean hasPermission() {
        User user = Application.getCurrentUser();
        UserType userType = user.getType();
        if (userType != null) {
            Set<UserPermission> permissions = userType.getPermissions();
            for (UserPermission permission : permissions) {
                if (!permission.equals(UserPermission.CREATE_TICKET)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        this.actionPerformed(null);
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

