/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.actions.CacheDataUpdateAction;
import com.floreantpos.actions.ClockInOutAction;
import com.floreantpos.actions.GiftCardAddBalanceAction;
import com.floreantpos.actions.HomeScreenViewAction;
import com.floreantpos.actions.LogoutAction;
import com.floreantpos.actions.ShowBackofficeAction;
import com.floreantpos.actions.ShowSpecialFunctionsAction;
import com.floreantpos.actions.ShutDownAction;
import com.floreantpos.actions.SwithboardViewAction;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.views.ReservationView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class HeaderPanel
extends JPanel {
    private PosButton btnHomeScreen;
    private PosButton btnShowBackoffice;
    private PosButton btnSpecialFunctions;
    private PosButton btnSwithboardView;
    private PosButton btnLogout;
    private PosButton btnClockOUt;
    private PosButton btnShutdown;
    private PosButton btnReservation = new PosButton("R");
    private POSToggleButton btnReturnMode = new POSToggleButton();
    private POSToggleButton btn_86 = new POSToggleButton("86");
    private PosButton btnReloadCacheData;
    private JPanel buttonPanel;
    private PosButton btnGiftCardScreen;
    private int btnSize;

    public HeaderPanel() {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.buttonPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, aligny center", "sg,fill", ""));
        this.buttonPanel.setBackground(Color.white);
        JLabel logoLabel = new JLabel(IconFactory.getIcon("/ui_icons/", "header_logo.png"));
        this.add((Component)logoLabel, "West");
        this.btnSize = PosUIManager.getSize(50);
        this.btnReservation.setToolTipText(Messages.getString("HeaderPanel.4"));
        this.btnReservation.setFont(new Font(this.btnReservation.getFont().getName(), 1, 20));
        this.btnReservation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RootView rootView = RootView.getInstance();
                if (rootView.hasView("RESERVATION_VIEW")) {
                    rootView.showView("RESERVATION_VIEW");
                } else {
                    rootView.addView(ReservationView.getInstance());
                    rootView.showView("RESERVATION_VIEW");
                }
            }
        });
        this.buttonPanel.add((Component)this.btnReservation, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btn_86.setFont(new Font(this.btn_86.getFont().getName(), 1, 20));
        this.btn_86.setToolTipText(Messages.getString("HeaderPanel.2"));
        this.buttonPanel.add((Component)this.btn_86, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btn_86.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.getInstance().set_86Mode(HeaderPanel.this.btn_86.isSelected());
            }
        });
        this.btnReturnMode.setFont(new Font(this.btnReturnMode.getFont().getName(), 1, 20));
        this.btnReturnMode.setToolTipText(Messages.getString("HeaderPanel.3"));
        this.buttonPanel.add((Component)this.btnReturnMode, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnReturnMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.getInstance().setReturnMode(HeaderPanel.this.btnReturnMode.isSelected());
            }
        });
        this.btnReturnMode.setIcon(IconFactory.getIcon("/ui_icons/", "return.png", PosUIManager.getSize(22, 22)));
        this.btnHomeScreen = new PosButton(new HomeScreenViewAction(false, true));
        this.btnHomeScreen.setToolTipText(Messages.getString("HeaderPanel.5"));
        this.buttonPanel.add((Component)this.btnHomeScreen, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnReloadCacheData = new PosButton(new CacheDataUpdateAction(false, true));
        this.btnReloadCacheData.setToolTipText(Messages.getString("HeaderPanel.8"));
        this.buttonPanel.add((Component)this.btnReloadCacheData, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnGiftCardScreen = new PosButton(new GiftCardAddBalanceAction(true));
        this.btnGiftCardScreen.setToolTipText(Messages.getString("HeaderPanel.12"));
        this.buttonPanel.add((Component)this.btnGiftCardScreen, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnSwithboardView = new PosButton(new SwithboardViewAction(false, true));
        this.btnSwithboardView.setToolTipText(Messages.getString("HeaderPanel.7"));
        this.buttonPanel.add((Component)this.btnSwithboardView, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnSpecialFunctions = new PosButton(new ShowSpecialFunctionsAction(false, true));
        this.btnSpecialFunctions.setToolTipText(Messages.getString("HeaderPanel.9"));
        this.buttonPanel.add((Component)this.btnSpecialFunctions, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnShowBackoffice = new PosButton(new ShowBackofficeAction(false, true));
        this.btnShowBackoffice.setToolTipText(Messages.getString("HeaderPanel.10"));
        this.buttonPanel.add((Component)this.btnShowBackoffice, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnClockOUt = new PosButton(new ClockInOutAction(false, true));
        this.btnClockOUt.setToolTipText(Messages.getString("HeaderPanel.11"));
        this.buttonPanel.add((Component)this.btnClockOUt, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnLogout = new PosButton(new LogoutAction(false, true));
        this.btnLogout.setToolTipText(Messages.getString("Logout"));
        this.buttonPanel.add((Component)this.btnLogout, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnShutdown = new PosButton(new ShutDownAction(false, true));
        this.btnShutdown.setIcon(IconFactory.getIcon("/ui_icons/", "shutdown.png"));
        this.btnShutdown.setToolTipText(Messages.getString("Shutdown"));
        this.buttonPanel.add((Component)this.btnShutdown, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.add((Component)this.buttonPanel, "East");
        this.add((Component)new JSeparator(0), "South");
        this.setPreferredSize(PosUIManager.getSize(100, 62));
    }

    public void updateOthersFunctionsView(boolean enable) {
        this.buttonPanel.removeAll();
        this.btnReturnMode.setSelected(false);
        this.buttonPanel.add((Component)this.btnReloadCacheData, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnGiftCardScreen, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnReservation, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnReturnMode, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btn_86, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnHomeScreen, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnSpecialFunctions, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnSwithboardView, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnShowBackoffice, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnClockOUt, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnLogout, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnShutdown, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnSpecialFunctions.setVisible(enable);
    }

    public void updateSwitchBoardView(boolean enable) {
        this.buttonPanel.removeAll();
        this.btnReturnMode.setSelected(false);
        this.buttonPanel.add((Component)this.btnReloadCacheData, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnGiftCardScreen, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnReservation, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnReturnMode, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btn_86, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnHomeScreen, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnSpecialFunctions, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnSwithboardView, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnShowBackoffice, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnClockOUt, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnLogout, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.buttonPanel.add((Component)this.btnShutdown, "w " + this.btnSize + "!, h " + this.btnSize + "!");
        this.btnSwithboardView.setVisible(enable);
    }

    public void updateHomeView(boolean enable) {
        this.btnHomeScreen.setVisible(enable);
        boolean showingOrderView = OrderView.getInstance().isVisible();
        this.btn_86.setVisible(showingOrderView);
        this.btnReturnMode.setVisible(showingOrderView);
        this.btnGiftCardScreen.setVisible(showingOrderView);
    }

    public void setReturnMode(boolean returnMode) {
        this.btnReturnMode.setSelected(returnMode);
        OrderView.getInstance().setReturnMode(this.btnReturnMode.isSelected());
    }

    public void setSelected_86(boolean select) {
        OrderView.getInstance().set_86Mode(select);
        this.btn_86.setSelected(select);
    }
}

