/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Terminal;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.TitledSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class CashReconciliationDialog
extends OkCancelOptionDialog {
    private static MyOwnFocusTraversalPolicy newPolicy;
    private IntegerTextField tfFiveThousands;
    private IntegerTextField tfTwoThousands;
    private IntegerTextField tfThousand;
    private IntegerTextField tfFiveHundreds;
    private IntegerTextField tfHundreds;
    private IntegerTextField tfFifties;
    private IntegerTextField tfTwenties;
    private IntegerTextField tfTens;
    private IntegerTextField tfFives;
    private IntegerTextField tfTwos;
    private IntegerTextField tfOnes;
    private IntegerTextField tf$_1_0_Coins;
    private IntegerTextField tf$0_50_Coins;
    private IntegerTextField tf$_0_25_Coins;
    private IntegerTextField tf$_0_15_Coins;
    private IntegerTextField tf$_0_10_Coins;
    private IntegerTextField tf$_0_05_Coins;
    private IntegerTextField tf$_0_01_Coins;
    private DoubleTextField tfTotalCash;
    private JLabel lblTotalCash;
    private CashDrawer cashDrawer;
    private CashBreakdown selectedCashBreakdown;
    private Map<String, CashBreakdown> itemMap = new HashMap<String, CashBreakdown>();
    private Map<String, CurrencySummaryRow> summaryMap = new HashMap<String, CurrencySummaryRow>();
    private Currency selectedCurrency;
    private double totalReconcileAmount;

    public CashReconciliationDialog(CashDrawer report) {
        super(POSUtil.getFocusedWindow(), Messages.getString("CashReconciliationDialog.0"));
        this.setCaption(Messages.getString("CashReconciliationDialog.1"));
        this.cashDrawer = report;
        List<CashBreakdown> cashBreakdowns = this.cashDrawer.getCashBreakdownList();
        if (cashBreakdowns != null) {
            for (CashBreakdown curBalance : cashBreakdowns) {
                this.itemMap.put(curBalance.getCurrency().getName(), curBalance);
            }
        }
        this.initComponent();
        this.callOrderController();
        this.createComponents();
        if (this.selectedCurrency != null) {
            this.updateView();
        }
    }

    public void createComponents() {
        JPanel container = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3,inset 0,wrap 1"));
        this.createTopCurrencyButtonPanel();
        if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
            JLabel lblTitle = new JLabel(Messages.getString("CashReconciliationDialog.3"));
            lblTitle.setForeground(UIManager.getColor("TitledBorder.titleColor"));
            lblTitle.setFont(new Font(lblTitle.getFont().getName(), 1, 14));
            TitledSeparator sep = new TitledSeparator((JComponent)lblTitle, 0);
            container.add((Component)sep, "grow,span");
        }
        JLabel lblFiveThousands = new JLabel("5000's");
        JLabel lblTwoThousands = new JLabel("2000's");
        JLabel lblThousands = new JLabel("1000's");
        JLabel lblFiveHundreds = new JLabel("500's");
        JLabel lblHundreds = new JLabel("100's");
        JLabel lblFifties = new JLabel("50's");
        JLabel lblTwenties = new JLabel("20's");
        JLabel lblTens = new JLabel("10's");
        JLabel lblFives = new JLabel("5's");
        JLabel lblTwos = new JLabel("2's");
        JLabel lblOnes = new JLabel("1's");
        JLabel lbl$_1_0_Coins = new JLabel(Messages.getString("CashReconciliationDialog.2"));
        JLabel lbl$0_50_Coins = new JLabel(Messages.getString("CashReconciliationDialog.4"));
        JLabel lbl$_0_25_Coins = new JLabel(Messages.getString("CashReconciliationDialog.5"));
        JLabel lbl$_0_15_Coins = new JLabel(Messages.getString("CashReconciliationDialog.6"));
        JLabel lbl$_0_10_Coins = new JLabel(Messages.getString("CashReconciliationDialog.7"));
        JLabel lbl$_0_05_Coins = new JLabel(Messages.getString("CashReconciliationDialog.8"));
        JLabel lbl$_0_01_Coins = new JLabel(Messages.getString("CashReconciliationDialog.9"));
        int col = 0;
        int row = 0;
        JPanel numberInputPanel = new JPanel((LayoutManager)new MigLayout("fill", "[][]20px[][]", ""));
        numberInputPanel.add((Component)lblFiveThousands, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lblTwoThousands, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lblThousands, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lblFiveHundreds, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lblHundreds, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lblFifties, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lblTwenties, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lblTens, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lblFives, "grow,cell " + col + " " + row++);
        row = 0;
        numberInputPanel.add((Component)this.tfFiveThousands, "grow,cell " + ++col + " " + row++);
        numberInputPanel.add((Component)this.tfTwoThousands, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tfThousand, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tfFiveHundreds, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tfHundreds, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tfFifties, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tfTwenties, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tfTens, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tfFives, "grow,cell " + col + " " + row++);
        row = 0;
        numberInputPanel.add((Component)lblTwos, "grow,cell " + ++col + " " + row++);
        numberInputPanel.add((Component)lblOnes, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)lbl$_1_0_Coins, "right,cell " + col + " " + row++);
        numberInputPanel.add((Component)lbl$0_50_Coins, "right,cell " + col + " " + row++);
        numberInputPanel.add((Component)lbl$_0_25_Coins, "right,cell " + col + " " + row++);
        numberInputPanel.add((Component)lbl$_0_15_Coins, "right,cell " + col + " " + row++);
        numberInputPanel.add((Component)lbl$_0_10_Coins, "right,cell " + col + " " + row++);
        numberInputPanel.add((Component)lbl$_0_05_Coins, "right,cell " + col + " " + row++);
        numberInputPanel.add((Component)lbl$_0_01_Coins, "right,cell " + col + " " + row++);
        row = 0;
        numberInputPanel.add((Component)this.tfTwos, "grow,cell " + ++col + " " + row++);
        numberInputPanel.add((Component)this.tfOnes, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tf$_1_0_Coins, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tf$0_50_Coins, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tf$_0_25_Coins, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tf$_0_15_Coins, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tf$_0_10_Coins, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tf$_0_05_Coins, "grow,cell " + col + " " + row++);
        numberInputPanel.add((Component)this.tf$_0_01_Coins, "grow,cell " + col + " " + row++);
        container.add((Component)numberInputPanel, "grow");
        this.addCurrencySummaryPanel(container);
        this.getContentPanel().add(container);
    }

    private void createTopCurrencyButtonPanel() {
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("center,ins 10 0 0 0", "sg,fill", ""));
        ButtonGroup group = new ButtonGroup();
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal.isEnableMultiCurrency().booleanValue()) {
            for (Currency currency : CurrencyUtil.getAllCurrency()) {
                POSToggleButton btnCurrency = new POSToggleButton(currency.getName());
                btnCurrency.putClientProperty("currency", currency);
                btnCurrency.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CashReconciliationDialog.this.updateModel();
                        CashReconciliationDialog.this.selectedCurrency = (Currency)((POSToggleButton)e.getSource()).getClientProperty("currency");
                        CashReconciliationDialog.this.updateView();
                    }
                });
                if (currency.isMain().booleanValue()) {
                    btnCurrency.setSelected(true);
                    this.selectedCurrency = currency;
                }
                topPanel.add(btnCurrency);
                group.add(btnCurrency);
            }
            this.add((Component)topPanel, "North");
        } else {
            TitlePanel titlePanel = new TitlePanel();
            titlePanel.setTitle(Messages.getString("CashReconciliationDialog.105"));
            this.add((Component)titlePanel, "North");
            this.selectedCurrency = CurrencyUtil.getMainCurrency();
            this.updateView();
        }
    }

    private void addCurrencySummaryPanel(JPanel container) {
        JPanel calculatePanel = new JPanel((LayoutManager)new MigLayout("fill,right,ins 0,wrap 2", "30px[60px,grow,right][60px,grow,fill,right]", ""));
        Terminal terminal = Application.getInstance().getTerminal();
        if (terminal.isEnableMultiCurrency().booleanValue()) {
            for (Currency currency : CurrencyUtil.getAllCurrency()) {
                CurrencySummaryRow item = new CurrencySummaryRow(calculatePanel, currency);
                this.summaryMap.put(currency.getName(), item);
            }
        } else {
            Currency mainCurrency = CurrencyUtil.getMainCurrency();
            CurrencySummaryRow item = new CurrencySummaryRow(calculatePanel, mainCurrency);
            this.summaryMap.put(mainCurrency.getName(), item);
        }
        JLabel lblTitle2 = new JLabel(terminal.isEnableMultiCurrency() != false ? Messages.getString("CashReconciliationDialog.109") : Messages.getString("CashReconciliationDialog.110"));
        lblTitle2.setForeground(UIManager.getColor("TitledBorder.titleColor"));
        lblTitle2.setFont(new Font(lblTitle2.getFont().getName(), 1, 14));
        TitledSeparator sep2 = new TitledSeparator((JComponent)lblTitle2, 0);
        container.add((Component)sep2, "grow,span");
        container.add((Component)calculatePanel, "grow");
    }

    public void initComponent() {
        this.tfFiveThousands = new IntegerTextField(12);
        this.tfTwoThousands = new IntegerTextField(12);
        this.tfThousand = new IntegerTextField(12);
        this.tfFiveHundreds = new IntegerTextField(12);
        this.tfHundreds = new IntegerTextField(12);
        this.tfFifties = new IntegerTextField(12);
        this.tfTwenties = new IntegerTextField(12);
        this.tfTens = new IntegerTextField(12);
        this.tfFives = new IntegerTextField(12);
        this.tfTwos = new IntegerTextField(12);
        this.tfOnes = new IntegerTextField(12);
        this.tf$_1_0_Coins = new IntegerTextField(12);
        this.tf$0_50_Coins = new IntegerTextField(12);
        this.tf$_0_25_Coins = new IntegerTextField(12);
        this.tf$_0_15_Coins = new IntegerTextField(12);
        this.tf$_0_10_Coins = new IntegerTextField(12);
        this.tf$_0_05_Coins = new IntegerTextField(12);
        this.tf$_0_01_Coins = new IntegerTextField(12);
        this.tfTotalCash = new DoubleTextField(12);
        FocusListener listener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                CashReconciliationDialog.this.calculateTotal();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        this.tfFiveThousands.addFocusListener(listener);
        this.tfTwoThousands.addFocusListener(listener);
        this.tfThousand.addFocusListener(listener);
        this.tfFiveHundreds.addFocusListener(listener);
        this.tfHundreds.addFocusListener(listener);
        this.tfFifties.addFocusListener(listener);
        this.tfTwenties.addFocusListener(listener);
        this.tfTens.addFocusListener(listener);
        this.tfFives.addFocusListener(listener);
        this.tfTwos.addFocusListener(listener);
        this.tfOnes.addFocusListener(listener);
        this.tf$_1_0_Coins.addFocusListener(listener);
        this.tf$0_50_Coins.addFocusListener(listener);
        this.tf$_0_25_Coins.addFocusListener(listener);
        this.tf$_0_15_Coins.addFocusListener(listener);
        this.tf$_0_10_Coins.addFocusListener(listener);
        this.tf$_0_05_Coins.addFocusListener(listener);
        this.tf$_0_01_Coins.addFocusListener(listener);
        this.lblTotalCash = new JLabel(Messages.getString("CashReconciliationDialog.114"));
        Font f = new Font(this.lblTotalCash.getFont().getName(), 1, 16);
        this.lblTotalCash.setFont(f);
        this.tfTotalCash.setFont(f);
        this.tfTotalCash.setHorizontalAlignment(4);
    }

    private void updateView() {
        this.selectedCashBreakdown = this.itemMap.get(this.selectedCurrency.getName());
        if (this.selectedCashBreakdown == null) {
            this.selectedCashBreakdown = new CashBreakdown();
            this.selectedCashBreakdown.setCurrency(this.selectedCurrency);
            this.selectedCashBreakdown.setCashDrawer(this.cashDrawer);
            this.itemMap.put(this.selectedCurrency.getName(), this.selectedCashBreakdown);
        }
        this.tfFiveThousands.setText(String.valueOf(this.selectedCashBreakdown.getNoOfFiveThousands()));
        this.tfTwoThousands.setText(String.valueOf(this.selectedCashBreakdown.getNoOfTwoThousands()));
        this.tfThousand.setText(String.valueOf(this.selectedCashBreakdown.getNoOfThousands()));
        this.tfFiveHundreds.setText(String.valueOf(this.selectedCashBreakdown.getNoOfFiveHundreds()));
        this.tfHundreds.setText(String.valueOf(this.selectedCashBreakdown.getNoOfHundreds()));
        this.tfFifties.setText(String.valueOf(this.selectedCashBreakdown.getNoOfFifties()));
        this.tfTwenties.setText(String.valueOf(this.selectedCashBreakdown.getNoOfTwenties()));
        this.tfTens.setText(String.valueOf(this.selectedCashBreakdown.getNoOfTens()));
        this.tfFives.setText(String.valueOf(this.selectedCashBreakdown.getNoOfFives()));
        this.tfTwos.setText(String.valueOf(this.selectedCashBreakdown.getNoOfTwos()));
        this.tfOnes.setText(String.valueOf(this.selectedCashBreakdown.getNoOfOnes()));
        this.tf$_1_0_Coins.setText(String.valueOf(this.selectedCashBreakdown.getNoOfOneDollerCoin()));
        this.tf$0_50_Coins.setText(String.valueOf(this.selectedCashBreakdown.getNoOfFiftyCentCoin()));
        this.tf$_0_25_Coins.setText(String.valueOf(this.selectedCashBreakdown.getNoOfTwentyFiveCentCoin()));
        this.tf$_0_15_Coins.setText(String.valueOf(this.selectedCashBreakdown.getNoOfFifteenCentCoin()));
        this.tf$_0_10_Coins.setText(String.valueOf(this.selectedCashBreakdown.getNoOfTenCentCoin()));
        this.tf$_0_05_Coins.setText(String.valueOf(this.selectedCashBreakdown.getNoOfFiveCentCoin()));
        this.tf$_0_01_Coins.setText(String.valueOf(this.selectedCashBreakdown.getNoOfOneCentCoin()));
        this.calculateTotal();
        this.lblTotalCash.setText(Messages.getString("CashReconciliationDialog.10") + this.selectedCurrency.getName() + ")  " + this.selectedCurrency.getSymbol());
        this.tfTotalCash.setText(String.valueOf(this.selectedCashBreakdown.getTotalAmount()));
    }

    private void calculateTotal() {
        double amountNoOfFiveThousands = this.tfFiveThousands.getInteger() * 5000;
        double amountNoOfTwoThousands = this.tfTwoThousands.getInteger() * 2000;
        double amountNoOfThousands = this.tfThousand.getInteger() * 1000;
        double amountNoOfFiveHundreds = this.tfFiveHundreds.getInteger() * 500;
        double amountNoOfHundreds = this.tfHundreds.getInteger() * 100;
        double amountNoOfFifties = this.tfFifties.getInteger() * 50;
        double amountNoOfTwenties = this.tfTwenties.getInteger() * 20;
        double amountNoOfTens = this.tfTens.getInteger() * 10;
        double amountNoOfFives = this.tfFives.getInteger() * 5;
        double amountNoOfTwos = this.tfTwos.getInteger() * 2;
        double amountNoOfOnes = this.tfOnes.getInteger();
        double amountNoOfOneCoin = this.tf$_1_0_Coins.getInteger();
        double amountNoOfFiftyCentCoin = (double)this.tf$0_50_Coins.getInteger() * 0.5;
        double amountNoOfTwentyFiveCentCoin = (double)this.tf$_0_25_Coins.getInteger() * 0.25;
        double amountNoOfFifteenCentCoin = (double)this.tf$_0_15_Coins.getInteger() * 0.15;
        double amountNoOfTenCentCoin = (double)this.tf$_0_10_Coins.getInteger() * 0.1;
        double amountNoOfFiveCentCoin = (double)this.tf$_0_05_Coins.getInteger() * 0.05;
        double amountNoOfOneCentCoin = (double)this.tf$_0_01_Coins.getInteger() * 0.01;
        double amountTotalCash = amountNoOfFiveThousands + amountNoOfTwoThousands + amountNoOfThousands + amountNoOfFiveHundreds + amountNoOfHundreds + amountNoOfFifties + amountNoOfTwenties + amountNoOfTens + amountNoOfFives + amountNoOfTwos + amountNoOfOnes;
        this.selectedCashBreakdown.setTotalAmount(amountTotalCash += amountNoOfOneCoin + amountNoOfFiftyCentCoin + amountNoOfTwentyFiveCentCoin + amountNoOfTenCentCoin + amountNoOfFiveCentCoin + amountNoOfFifteenCentCoin + amountNoOfOneCentCoin);
        this.updateTotalForCurrency();
    }

    private void updateTotalForCurrency() {
        CurrencySummaryRow row = this.summaryMap.get(this.selectedCurrency.getName());
        Double totalAmount = this.selectedCashBreakdown.getTotalAmount();
        if (row != null) {
            row.tfCashToDeposit.setEditable(totalAmount == 0.0);
            row.setSubtotalAmount(totalAmount);
        }
    }

    public void callOrderController() {
        Vector<Component> order = new Vector<Component>();
        order.add(this.tfFiveThousands);
        order.add(this.tfTwoThousands);
        order.add(this.tfThousand);
        order.add(this.tfFiveHundreds);
        order.add(this.tfHundreds);
        order.add(this.tfFifties);
        order.add(this.tfTwenties);
        order.add(this.tfTens);
        order.add(this.tfFives);
        order.add(this.tfTwos);
        order.add(this.tfOnes);
        order.add(this.tf$_1_0_Coins);
        order.add(this.tf$0_50_Coins);
        order.add(this.tf$_0_25_Coins);
        order.add(this.tf$_0_15_Coins);
        order.add(this.tf$_0_10_Coins);
        order.add(this.tf$_0_05_Coins);
        order.add(this.tf$_0_01_Coins);
        newPolicy = new MyOwnFocusTraversalPolicy(order);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(newPolicy);
    }

    private boolean updateModel() {
        this.selectedCashBreakdown.setNoOfFiveThousands(this.tfFiveThousands.getInteger());
        this.selectedCashBreakdown.setNoOfTwoThousands(this.tfTwoThousands.getInteger());
        this.selectedCashBreakdown.setNoOfThousands(this.tfThousand.getInteger());
        this.selectedCashBreakdown.setNoOfFiveHundreds(this.tfFiveHundreds.getInteger());
        this.selectedCashBreakdown.setNoOfHundreds(this.tfHundreds.getInteger());
        this.selectedCashBreakdown.setNoOfFifties(this.tfFifties.getInteger());
        this.selectedCashBreakdown.setNoOfTwenties(this.tfTwenties.getInteger());
        this.selectedCashBreakdown.setNoOfTens(this.tfTens.getInteger());
        this.selectedCashBreakdown.setNoOfFives(this.tfFives.getInteger());
        this.selectedCashBreakdown.setNoOfTwos(this.tfTwos.getInteger());
        this.selectedCashBreakdown.setNoOfOnes(this.tfOnes.getInteger());
        this.selectedCashBreakdown.setNoOfOneDollerCoin(this.tf$_1_0_Coins.getInteger());
        this.selectedCashBreakdown.setNoOfFiftyCentCoin(this.tf$0_50_Coins.getInteger());
        this.selectedCashBreakdown.setNoOfTwentyFiveCentCoin(this.tf$_0_25_Coins.getInteger());
        this.selectedCashBreakdown.setNoOfFifteenCentCoin(this.tf$_0_15_Coins.getInteger());
        this.selectedCashBreakdown.setNoOfTenCentCoin(this.tf$_0_10_Coins.getInteger());
        this.selectedCashBreakdown.setNoOfFiveCentCoin(this.tf$_0_05_Coins.getInteger());
        this.selectedCashBreakdown.setNoOfOneCentCoin(this.tf$_0_01_Coins.getInteger());
        return true;
    }

    @Override
    public void doOk() {
        this.calculateTotal();
        this.updateTotalForCurrency();
        if (!this.updateModel()) {
            return;
        }
        List<CashBreakdown> cashBreakdowns = this.cashDrawer.getCashBreakdownList();
        if (cashBreakdowns != null) {
            cashBreakdowns.clear();
        }
        this.totalReconcileAmount = 0.0;
        for (CashBreakdown cashBreakdown : this.itemMap.values()) {
            CurrencySummaryRow summary = this.summaryMap.get(cashBreakdown.getCurrency().getName());
            cashBreakdown.setBalance(summary.getCashToDeposit());
            cashBreakdown.setTotalAmount(summary.getCashToDeposit());
            if (!(cashBreakdown.getTotalAmount() > 0.0)) continue;
            this.totalReconcileAmount += cashBreakdown.getTotalAmount() / cashBreakdown.getCurrency().getExchangeRate();
            this.cashDrawer.addTocashBreakdownList(cashBreakdown);
        }
        if (this.totalReconcileAmount < this.cashDrawer.getDrawerAccountable() && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("CashReconciliationDialog.117"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public double getTotalReconcilieAmount() {
        return this.totalReconcileAmount;
    }

    private JLabel getJLabel(String text, int bold, int fontSize, int align) {
        JLabel lbl = new JLabel(text);
        lbl.setFont(lbl.getFont().deriveFont(bold, PosUIManager.getSize(fontSize)));
        lbl.setHorizontalAlignment(align);
        return lbl;
    }

    private DoubleTextField getDoubleTextField(String text, int bold, int fontSize, int align) {
        DoubleTextField tf = new DoubleTextField();
        tf.setText(text);
        tf.setFont(tf.getFont().deriveFont(bold, PosUIManager.getSize(fontSize)));
        tf.setHorizontalAlignment(align);
        return tf;
    }

    class CurrencySummaryRow {
        Currency currency;
        DoubleTextField tfSubtotalAmount;
        DoubleTextField tfCashToDeposit;
        JLabel totalAmount;
        JLabel currencyName;

        public CurrencySummaryRow(JPanel calculatePanel, Currency currency) {
            this.currency = currency;
            this.currencyName = CashReconciliationDialog.this.getJLabel(currency.getName(), 0, 14, 10);
            this.tfSubtotalAmount = CashReconciliationDialog.this.getDoubleTextField("", 0, 14, 4);
            this.tfCashToDeposit = CashReconciliationDialog.this.getDoubleTextField("", 0, 14, 4);
            this.tfSubtotalAmount.setVisible(false);
            this.tfSubtotalAmount.setEnabled(false);
            calculatePanel.add(this.currencyName);
            calculatePanel.add(this.tfCashToDeposit);
            newPolicy.order.add(this.tfCashToDeposit);
        }

        double getSubtotalAmount() {
            double subtotal = this.tfSubtotalAmount.getDouble();
            if (Double.isNaN(subtotal)) {
                return 0.0;
            }
            return subtotal;
        }

        double getCashToDeposit() {
            double cashToDeposit = this.tfCashToDeposit.getDouble();
            if (Double.isNaN(cashToDeposit)) {
                return 0.0;
            }
            return cashToDeposit;
        }

        void setSubtotalAmount(double subtotalAmount) {
            this.tfSubtotalAmount.setText(String.valueOf(subtotalAmount));
            this.tfCashToDeposit.setText(String.valueOf(subtotalAmount));
        }
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        public MyOwnFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

