/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.PrintUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public class ClockedInUserListDialog
extends OkCancelOptionDialog {
    BeanTableModel<User> tableModel;
    JTable userListTable;
    private PosButton btnForceClockOut;
    private boolean dataUpdated = false;
    private User currentUser;

    public ClockedInUserListDialog(User currentUser) {
        super((Frame)Application.getPosWindow(), true);
        this.currentUser = currentUser;
        this.setTitle(Messages.getString("ClockedInUserListDialog.0"));
        this.setCaption(Messages.getString("ClockedInUserListDialog.1"));
        JPanel contentPane = this.getContentPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.tableModel = new BeanTableModel<User>(User.class){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 1) {
                    return Messages.getString("ClockedInUserListDialog.2");
                }
                return super.getValueAt(rowIndex, columnIndex);
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                if (columnIndex != 1) {
                    super.setValueAt(value, rowIndex, columnIndex);
                }
            }
        };
        this.tableModel.addColumn("Name", "fullName");
        this.tableModel.addColumn("", "clockedIn");
        this.userListTable = new JTable(this.tableModel);
        this.userListTable.setRowHeight(PosUIManager.getSize(45));
        this.userListTable.setShowGrid(false);
        this.userListTable.getSelectionModel().setSelectionMode(0);
        contentPane.add(new JScrollPane(this.userListTable));
        this.userListTable.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.btnForceClockOut = new PosButton(Messages.getString("ClockedInUserListDialog.2"));
        this.btnForceClockOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User user = ClockedInUserListDialog.this.getSelectedUser();
                if (user == null) {
                    return;
                }
                ClockedInUserListDialog.this.doForceClockOutUser(user);
            }
        });
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                User user = ClockedInUserListDialog.this.getSelectedUser();
                if (user == null) {
                    return;
                }
                ClockedInUserListDialog.this.doForceClockOutUser(user);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn(this.userListTable, action, 1){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, this.userListTable.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, this.userListTable.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, this.btnForceClockOut.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, this.btnForceClockOut.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
        this.updateView();
        this.setOkButtonText(Messages.getString("DONE"));
        this.setCancelButtonVisible(false);
    }

    private void updateView() {
        List<User> users = UserDAO.getInstance().findClockedInUsers();
        this.tableModel.setRows(users);
    }

    private void doForceClockOutUser(User userToClockOut) {
        try {
            if (!(this.currentUser.isManager() || this.currentUser.isAdministrator() || this.currentUser.hasPermission(UserPermission.OPEN_CLOSE_STORE))) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ClockedInUserListDialog.7"));
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ClockedInUserListDialog.8"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            UserDAO.getInstance().doForceClockOutUser(userToClockOut, this.currentUser);
            String msg = Messages.getString("USER") + userToClockOut.getFirstName() + " " + userToClockOut.getLastName() + Messages.getString("ClockInOutAction.10");
            if (POSMessageDialog.showMessageAndPromtToPrint(msg)) {
                PrintUtil.printClockInOutReport(userToClockOut, this);
            }
            this.updateView();
            this.dataUpdated = true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    public void hideUser(User user) {
        this.tableModel.removeRow(user);
    }

    public User getSelectedUser() {
        int selectedRow = this.userListTable.getSelectedRow();
        if (selectedRow == -1) {
            return null;
        }
        return this.tableModel.getRows().get(selectedRow);
    }

    @Override
    public void doOk() {
        this.setCanceled(true);
        this.dispose();
    }

    public boolean isDataUpdated() {
        return this.dataUpdated;
    }
}

