/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class ComboTicketItemSelectionDialog
extends OkCancelOptionDialog {
    private JPanel menuItemViewPanel;
    private JPanel buttonsPanel;
    private JPanel comboGroupPanel;
    private Map<String, List<MenuItem>> groupMap = new HashMap<String, List<MenuItem>>();
    private MenuItem parentMenuItem;
    private ComboTicketItem ticketItem;
    private ComboGroup selectedComboGroup;
    private JTable table;
    private PosButton btnCustomQuantity;
    private PosButton btnDelete;
    private PosButton btnIncreaseQuantity;
    private PosButton btnDecreaseQuantity;
    private PosButton btnModify;

    public ComboTicketItemSelectionDialog(MenuItem menuItem, TicketItem ticketItem) {
        super((Frame)Application.getPosWindow(), true);
        this.ticketItem = (ComboTicketItem)ticketItem;
        this.parentMenuItem = menuItem;
        this.setComboItemsQuantityToOne();
        this.initComponent();
        this.rendererGroup();
    }

    private void initComponent() {
        this.setOkButtonText("DONE");
        this.setCaption(this.parentMenuItem + Messages.getString("ComboTicketItemSelectionDialog.0"));
        this.getContentPanel().setBorder(new EmptyBorder(0, 10, 0, 10));
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.menuItemViewPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.buttonsPanel = new JPanel(new WrapLayout(1));
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(40, 0));
        scrollPane.setBorder(null);
        this.menuItemViewPanel.add((Component)scrollPane, "grow,span");
        centerPanel.add((Component)this.menuItemViewPanel, "Center");
        this.getContentPanel().add((Component)centerPanel, "Center");
        this.table = new JTable();
        this.table.setRowHeight(40);
        this.table.setModel(new ComboTicketItemTableModel());
        this.table.setTableHeader(null);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new MultiLineTableCellRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                TicketItem comboTicketItem = ComboTicketItemSelectionDialog.this.getComboTicketItem();
                boolean editable = ComboTicketItemSelectionDialog.this.isGroupItem(comboTicketItem);
                ComboTicketItemSelectionDialog.this.btnCustomQuantity.setEnabled(editable);
                ComboTicketItemSelectionDialog.this.btnIncreaseQuantity.setEnabled(editable);
                ComboTicketItemSelectionDialog.this.btnDecreaseQuantity.setEnabled(editable);
                ComboTicketItemSelectionDialog.this.btnCustomQuantity.setText("...");
                ComboTicketItemSelectionDialog.this.btnCustomQuantity.setEnabled(editable);
                ComboTicketItemSelectionDialog.this.btnDelete.setEnabled(editable);
                if (comboTicketItem == null) {
                    return;
                }
                ComboTicketItemSelectionDialog.this.btnModify.setEnabled(comboTicketItem.isHasModifiers());
                double quantity = comboTicketItem.getQuantity();
                ComboTicketItemSelectionDialog.this.updateQuantity(quantity);
            }
        });
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 2, 3), scroll.getBorder()));
        scroll.setPreferredSize(PosUIManager.getSize(250, 0));
        JPanel leftTableView = new JPanel(new BorderLayout());
        TitledBorder leftSelectedComboTitleBorder = new TitledBorder(Messages.getString("ComboTicketItemSelectionDialog.4"));
        leftSelectedComboTitleBorder.setTitleJustification(2);
        leftTableView.setBorder(leftSelectedComboTitleBorder);
        leftTableView.add(scroll);
        this.getContentPanel().add((Component)leftTableView, "West");
        int size = PosUIManager.getSize(30);
        JPanel itemtemActionPanel = new JPanel();
        itemtemActionPanel.setLayout((LayoutManager)new MigLayout("fillx,ins 2 0 2 0", "[" + size + "px][grow][" + size + "px]", "[" + size + "]"));
        this.btnIncreaseQuantity = new PosButton();
        this.btnIncreaseQuantity.addActionListener(e -> this.doIncreaseQty());
        this.btnCustomQuantity = new PosButton("...");
        this.btnCustomQuantity.addActionListener(e -> this.doPerformCustomQty());
        this.btnDecreaseQuantity = new PosButton();
        this.btnDecreaseQuantity.addActionListener(e -> this.doDecreaseQuantity());
        this.btnDelete = new PosButton();
        this.btnDelete.addActionListener(e -> this.doDeleteSelection());
        Dimension iconSize = PosUIManager.getSize(20, 20);
        this.btnCustomQuantity.setFont(new Font(this.btnCustomQuantity.getFont().getName(), 1, 20));
        this.btnDelete.setIcon(IconFactory.getIcon("/ui_icons/", "delete.png", iconSize));
        this.btnIncreaseQuantity.setIcon(IconFactory.getIcon("/ui_icons/", "plus_32.png", iconSize));
        this.btnDecreaseQuantity.setIcon(IconFactory.getIcon("/ui_icons/", "minus_32.png", iconSize));
        itemtemActionPanel.add(this.btnDecreaseQuantity);
        itemtemActionPanel.add((Component)this.btnCustomQuantity, "grow");
        itemtemActionPanel.add(this.btnIncreaseQuantity);
        itemtemActionPanel.add(this.btnDelete);
        leftTableView.add((Component)itemtemActionPanel, "South");
        this.comboGroupPanel = new HorizontalTouchScrollPanel((LayoutManager)new MigLayout("fill, ins 0", "fill, grow", ""));
        JPanel menuGroupContainer = new JPanel((LayoutManager)new MigLayout("fill"));
        TitledBorder titledBorder = new TitledBorder(Messages.getString("ComboTicketItemSelectionDialog.15"));
        titledBorder.setTitleJustification(2);
        menuGroupContainer.setBorder(titledBorder);
        menuGroupContainer.setPreferredSize(PosUIManager.getSize(0, 100));
        menuGroupContainer.add((Component)((Object)new HorizontalSimpleScrollPane(this.comboGroupPanel)), "grow");
        centerPanel.add((Component)menuGroupContainer, "North");
        this.btnModify = new PosButton(Messages.getString("ComboTicketItemSelectionDialog.17"));
        this.btnModify.setEnabled(false);
        this.btnModify.addActionListener(e -> this.performModify());
        this.getButtonPanel().add((Component)this.btnModify, 0);
    }

    private void doDeleteSelection() {
        try {
            TicketItem comboTicketItem = this.getComboTicketItem();
            if (comboTicketItem == null) {
                return;
            }
            if (!this.isGroupItem(comboTicketItem)) {
                return;
            }
            int row = this.table.getSelectedRow();
            if (row == -1) {
                return;
            }
            int index = this.table.convertRowIndexToModel(row);
            ((ComboTicketItemTableModel)this.table.getModel()).deleteItem(index);
            this.btnCustomQuantity.setText("...");
            this.table.repaint();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }

    private boolean isGroupItem(TicketItem comboTicketItem) {
        return comboTicketItem == null || comboTicketItem.getGroupId() != null;
    }

    private boolean hasGroupOrValidateQuantity(TicketItem comboTicketItem, double previousQuantity) {
        ComboTicketItemTableModel model;
        int count;
        if (comboTicketItem.getGroupId() == null) {
            return false;
        }
        if (this.parentMenuItem.getComboGroups() != null) {
            for (ComboGroup group : this.parentMenuItem.getComboGroups()) {
                if (!group.getId().equals(comboTicketItem.getGroupId())) continue;
                this.renderItemsAndSelectComboGroup(group);
                break;
            }
        }
        if ((count = (model = (ComboTicketItemTableModel)this.table.getModel()).getItemCountOfGroup(this.selectedComboGroup)) > this.selectedComboGroup.getMaxQuantity()) {
            comboTicketItem.setQuantity(previousQuantity);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboTicketItemSelectionDialog.18") + this.selectedComboGroup.getMaxQuantity());
            return false;
        }
        return true;
    }

    protected void updateQuantity(double quantity) {
        this.btnCustomQuantity.setText(NumberUtil.trimDecilamIfNotNeeded(quantity));
        this.table.repaint();
    }

    private TicketItem getComboTicketItem() {
        int row = this.table.getSelectedRow();
        if (row == -1) {
            return null;
        }
        int index = this.table.convertRowIndexToModel(row);
        ITicketItem item = (ITicketItem)((ComboTicketItemTableModel)this.table.getModel()).getRowData(index);
        TicketItem comboTicketItem = null;
        if (item instanceof TicketItem) {
            comboTicketItem = (TicketItem)item;
        } else if (item instanceof TicketItemModifier) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)item;
            comboTicketItem = ticketItemModifier.getTicketItem();
        }
        return comboTicketItem;
    }

    public void openModifierDialog(TicketItem ticketItem) {
        try {
            Object dialog;
            Ticket ticket = ticketItem.getTicket();
            MenuItem menuItem = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize(menuItem);
            List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
            if (ticketItemModifiers == null) {
                ticketItemModifiers = new ArrayList<TicketItemModifier>();
            }
            TicketItem cloneTicketItem = ticketItem.clone();
            boolean pizzaType = ticketItem.isPizzaType();
            if (pizzaType) {
                dialog = new PizzaModifierSelectionDialog(ticket, cloneTicketItem, menuItem, true);
                dialog.openFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
                TicketItemModifier sizeModifier = cloneTicketItem.getSizeModifier();
                sizeModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(sizeModifier);
                ticketItem.setQuantity(cloneTicketItem.getQuantity());
                ticketItem.setUnitPrice(cloneTicketItem.getUnitPrice());
            } else {
                dialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, cloneTicketItem, menuItem));
                ((POSDialog)dialog).open();
                if (((POSDialog)dialog).isCanceled()) {
                    return;
                }
            }
            List<TicketItemModifier> addedTicketItemModifiers = cloneTicketItem.getTicketItemModifiers();
            if (addedTicketItemModifiers == null) {
                addedTicketItemModifiers = new ArrayList<TicketItemModifier>();
            }
            ticketItemModifiers.clear();
            for (TicketItemModifier ticketItemModifier : addedTicketItemModifiers) {
                ticketItemModifier.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void rendererGroup() {
        try {
            List<TicketItem> comboItems = this.ticketItem.getComboItems();
            ComboTicketItemTableModel model = (ComboTicketItemTableModel)this.table.getModel();
            if (comboItems != null) {
                for (TicketItem ticketItem : comboItems) {
                    model.addItem(ticketItem);
                }
            }
            if (this.parentMenuItem.isVariant().booleanValue()) {
                this.parentMenuItem = this.parentMenuItem.getParentMenuItem();
                MenuItemDAO.getInstance().initialize(this.parentMenuItem);
            } else if (this.parentMenuItem.isComboItem().booleanValue()) {
                MenuItemDAO.getInstance().initialize(this.parentMenuItem);
            }
            List<ComboGroup> comboGroups = this.parentMenuItem.getComboGroups();
            if (comboGroups != null) {
                TitledBorder titleBorder;
                Dimension size = PosUIManager.getSize(115, 60);
                ButtonGroup group = new ButtonGroup();
                boolean selectedFirst = true;
                for (ComboGroup comboGroup : comboGroups) {
                    ComboGroupButton groupButton = new ComboGroupButton(comboGroup);
                    groupButton.setSelected(selectedFirst);
                    groupButton.setPreferredSize(size);
                    this.comboGroupPanel.add(groupButton);
                    this.comboGroupPanel.putClientProperty(comboGroup.getId(), groupButton);
                    List<MenuItem> items = comboGroup.getItems();
                    if (items != null) {
                        this.groupMap.put(comboGroup.getId(), items);
                    }
                    group.add(groupButton);
                    selectedFirst = false;
                }
                if (comboGroups != null && comboGroups.size() > 0) {
                    this.selectedComboGroup = comboGroups.get(0);
                    this.rendererItems(this.selectedComboGroup);
                    titleBorder = BorderFactory.createTitledBorder(this.selectedComboGroup.getName() + Messages.getString("ComboTicketItemSelectionDialog.19") + this.selectedComboGroup.getMinQuantity() + Messages.getString("ComboTicketItemSelectionDialog.20") + this.selectedComboGroup.getMaxQuantity());
                    titleBorder.setTitleJustification(2);
                    this.menuItemViewPanel.setBorder(titleBorder);
                } else {
                    titleBorder = BorderFactory.createTitledBorder("-");
                    titleBorder.setTitleJustification(2);
                    this.menuItemViewPanel.setBorder(titleBorder);
                }
            }
            model.fireTableDataChanged();
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rendererItems(ComboGroup comboGroup) {
        try {
            this.buttonsPanel.removeAll();
            if (comboGroup == null) {
                return;
            }
            List<MenuItem> items = this.groupMap.get(comboGroup.getId());
            if (items != null) {
                for (MenuItem menuItem : items) {
                    MenuItemButton btnMenuItem = new MenuItemButton(menuItem);
                    btnMenuItem.setPreferredSize(PosUIManager.getSize(120, 100));
                    btnMenuItem.setEnabled(menuItem.isEnable());
                    this.buttonsPanel.add(btnMenuItem);
                }
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
        finally {
            this.menuItemViewPanel.revalidate();
            this.menuItemViewPanel.repaint();
        }
    }

    @Override
    public void setCanceled(boolean canceled) {
        this.restoreComboItemsQuantity();
        super.setCanceled(canceled);
    }

    @Override
    public void doOk() {
        List lTicketItems;
        if (!this.isRequiredItemsAdded()) {
            return;
        }
        List<TicketItem> comboItems = this.ticketItem.getComboItems();
        if (comboItems != null) {
            Iterator<TicketItem> iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.getGroupId() == null) continue;
                iterator.remove();
            }
        }
        if ((lTicketItems = ((ComboTicketItemTableModel)this.table.getModel()).getRows()) != null) {
            for (ITicketItem lTicketItem : lTicketItems) {
                if (lTicketItem instanceof TicketItemModifier) continue;
                TicketItem item = (TicketItem)lTicketItem;
                if (comboItems != null && comboItems.contains(item)) continue;
                item.setParentTicketItem(this.ticketItem);
                item.setTicket(null);
                this.ticketItem.addTocomboItems(item);
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void restoreComboItemsQuantity() {
        if (this.ticketItem.getQuantity() > 1.0 && this.ticketItem.getComboItems() != null && this.ticketItem.getComboItems().size() > 0) {
            for (TicketItem comboItem : this.ticketItem.getComboItems()) {
                comboItem.setQuantity(comboItem.getQuantity() * this.ticketItem.getQuantity());
            }
        }
    }

    private void setComboItemsQuantityToOne() {
        if (this.ticketItem.getQuantity() > 1.0 && this.ticketItem.getComboItems() != null && this.ticketItem.getComboItems().size() > 0) {
            for (TicketItem comboItem : this.ticketItem.getComboItems()) {
                comboItem.setQuantity(comboItem.getQuantity() / this.ticketItem.getQuantity());
            }
        }
    }

    public List<TicketItem> addedItems() {
        ComboTicketItemTableModel model = (ComboTicketItemTableModel)this.table.getModel();
        return model.getTicketItems();
    }

    private boolean isRequiredItemsAdded() {
        List<ComboGroup> comboGroups = this.parentMenuItem.getComboGroups();
        if (comboGroups == null) {
            return true;
        }
        ComboTicketItemTableModel model = (ComboTicketItemTableModel)this.table.getModel();
        for (ComboGroup group : comboGroups) {
            int count = model.getItemCountOfGroup(group);
            if (count >= group.getMinQuantity()) continue;
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboTicketItemSelectionDialog.22") + group.getMinQuantity() + Messages.getString("ComboTicketItemSelectionDialog.23") + group.getName());
            this.renderItemsAndSelectComboGroup(group);
            return false;
        }
        return true;
    }

    private void renderItemsAndSelectComboGroup(ComboGroup group) {
        Object object = this.comboGroupPanel.getClientProperty(group.getId());
        if (object instanceof ComboGroupButton) {
            ComboGroupButton comboGroupButton = (ComboGroupButton)object;
            comboGroupButton.setSelected(true);
            this.comboGroupPanel.revalidate();
            this.comboGroupPanel.repaint();
        }
        this.selectedComboGroup = group;
        this.rendererItems(group);
    }

    @Override
    public void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    public Collection<TicketItem> getSelectedMenuItems() {
        ComboTicketItemTableModel model = (ComboTicketItemTableModel)this.table.getModel();
        return model.getTicketItems();
    }

    public boolean addComboItem(MenuItem menuItem) {
        TicketItem lastTicketItem;
        boolean editable;
        boolean isRequiredIncreaseQty;
        if (menuItem.isVariant().booleanValue() && menuItem.getParentMenuItem() != null) {
            MenuItemDAO.getInstance().initialize(menuItem.getParentMenuItem());
        }
        ComboTicketItemTableModel model = (ComboTicketItemTableModel)this.table.getModel();
        double quantity = 1.0;
        if (this.parentMenuItem.isEnableComboQuantitySelection()) {
            double enabledQty = this.getEnabledQty(menuItem);
            if (enabledQty + (double)model.getItemCountOfGroup(this.selectedComboGroup) > (double)this.selectedComboGroup.getMaxQuantity().intValue()) {
                POSMessageDialog.showMessage(Messages.getString("ComboTicketItemSelectionDialog.24") + this.selectedComboGroup.getMaxQuantity());
                return false;
            }
            quantity = enabledQty;
        }
        boolean bl = isRequiredIncreaseQty = (editable = this.isGroupItem(lastTicketItem = model.getLastTicketItem())) && menuItem.isPizzaType() == false && !menuItem.hasModifiers();
        if (lastTicketItem != null && isRequiredIncreaseQty && lastTicketItem.getMenuItem().getId().equals(menuItem.getId())) {
            lastTicketItem.setQuantity(lastTicketItem.getQuantity() + quantity);
            model.fireTableDataChanged();
            return true;
        }
        Ticket currentTicket = OrderView.getInstance().getCurrentTicket();
        TicketItem comboTicketItem = menuItem.convertToTicketItem(currentTicket, quantity);
        comboTicketItem.setMenuItem(menuItem);
        comboTicketItem.setTicket(currentTicket);
        comboTicketItem.setMenuItemId(menuItem.getId());
        comboTicketItem.setGroupId(this.selectedComboGroup.getId());
        comboTicketItem.setName(menuItem.getName());
        comboTicketItem.setQuantity(quantity);
        if (menuItem.isPizzaType().booleanValue()) {
            PizzaModifierSelectionDialog dialog = new PizzaModifierSelectionDialog(currentTicket, comboTicketItem, menuItem, false);
            dialog.setAllowCreateMultiPizza(false);
            dialog.openFullScreen();
            if (dialog.isCanceled()) {
                return false;
            }
        } else if (menuItem.hasMandatoryModifiers()) {
            ModifierSelectionDialog dialog = new ModifierSelectionDialog(new ModifierSelectionModel(currentTicket, comboTicketItem, menuItem));
            dialog.open();
            if (dialog.isCanceled()) {
                return false;
            }
        }
        model.addItem(comboTicketItem);
        return true;
    }

    private boolean validQuantity() {
        ComboTicketItemTableModel model = (ComboTicketItemTableModel)this.table.getModel();
        int count = model.getItemCountOfGroup(this.selectedComboGroup);
        return count < this.selectedComboGroup.getMaxQuantity();
    }

    private double getEnabledQty(MenuItem menuItem) {
        NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
        dialog.setTitle(Messages.getString("ComboTicketItemSelectionDialog.12"));
        dialog.setFloatingPoint(false);
        dialog.setValue(1.0);
        dialog.pack();
        dialog.open();
        double quantity = (int)dialog.getValue();
        return quantity;
    }

    private void doDecreaseQuantity() {
        try {
            TicketItem comboTicketItem = this.getComboTicketItem();
            if (comboTicketItem == null) {
                return;
            }
            if (!this.isGroupItem(comboTicketItem)) {
                return;
            }
            double previousQuantity = comboTicketItem.getQuantity();
            if (previousQuantity == 1.0) {
                return;
            }
            comboTicketItem.setQuantity(previousQuantity - 1.0);
            if (!this.hasGroupOrValidateQuantity(comboTicketItem, previousQuantity)) {
                return;
            }
            this.updateQuantity(comboTicketItem.getQuantity());
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }

    private void doPerformCustomQty() {
        try {
            TicketItem comboTicketItem = this.getComboTicketItem();
            if (comboTicketItem == null) {
                return;
            }
            if (!this.isGroupItem(comboTicketItem)) {
                return;
            }
            NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
            dialog.setTitle(Messages.getString("ComboTicketItemSelectionDialog.12"));
            dialog.setFloatingPoint(false);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            double quantity = (int)dialog.getValue();
            if (quantity <= 0.0) {
                return;
            }
            double previousQuantity = comboTicketItem.getQuantity();
            comboTicketItem.setQuantity(quantity);
            if (!this.hasGroupOrValidateQuantity(comboTicketItem, previousQuantity)) {
                return;
            }
            this.updateQuantity(comboTicketItem.getQuantity());
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }

    private void doIncreaseQty() {
        try {
            TicketItem comboTicketItem = this.getComboTicketItem();
            if (comboTicketItem == null) {
                return;
            }
            if (!this.isGroupItem(comboTicketItem)) {
                return;
            }
            double previousQuantity = comboTicketItem.getQuantity();
            comboTicketItem.setQuantity(previousQuantity + 1.0);
            if (!this.hasGroupOrValidateQuantity(comboTicketItem, previousQuantity)) {
                return;
            }
            this.updateQuantity(comboTicketItem.getQuantity());
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }

    private void performModify() {
        try {
            TicketItem comboTicketItem = this.getComboTicketItem();
            if (comboTicketItem == null) {
                return;
            }
            ComboTicketItemTableModel model = (ComboTicketItemTableModel)this.table.getModel();
            comboTicketItem.setTicket(OrderView.getInstance().getCurrentTicket());
            if (comboTicketItem instanceof ModifiableTicketItem || comboTicketItem.isPizzaType().booleanValue()) {
                this.openModifierDialog(comboTicketItem);
                comboTicketItem.setTicket(null);
                model.getRows().set(this.table.getSelectedRow(), comboTicketItem);
                model.fireTableDataChanged();
            }
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }

    public class ComboTicketItemTableModel
    extends ListTableModel<ITicketItem> {
        public ComboTicketItemTableModel() {
            super(new String[]{Messages.getString("ComboTicketItemSelectionDialog.27")});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ITicketItem item = (ITicketItem)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return this.getTicketItemName(item);
                }
            }
            return null;
        }

        @Override
        public void addItem(ITicketItem item) {
            super.addItem(item);
        }

        @Override
        public void deleteItem(int index) {
            super.deleteItem(index);
        }

        private String getTicketItemName(ITicketItem item) {
            String modifierName = "";
            String ticketItemName = item.getNameDisplay();
            if (item instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)item;
                List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
                if (ticketItem.isHasModifiers().booleanValue() && ticketItemModifiers != null) {
                    for (TicketItemModifier itemModifier : ticketItemModifiers) {
                        modifierName = modifierName + "\n" + itemModifier.getNameDisplay();
                    }
                }
                if (StringUtils.isNotBlank((String)modifierName)) {
                    ticketItemName = ticketItemName + modifierName;
                }
            }
            return ticketItemName;
        }

        public List<TicketItem> getTicketItems() {
            ArrayList<TicketItem> listOfTicketItems = new ArrayList<TicketItem>();
            List iTicketItems = this.getRows();
            for (ITicketItem iTicketItem : iTicketItems) {
                if (iTicketItem instanceof TicketItemModifier) continue;
                TicketItem ticketItem = (TicketItem)iTicketItem;
                listOfTicketItems.add(ticketItem);
            }
            return listOfTicketItems;
        }

        public TicketItem getLastTicketItem() {
            int lastIndex;
            ITicketItem iTicketItem;
            List rows = this.getRows();
            if (rows != null && rows.size() != 0 && (iTicketItem = (ITicketItem)rows.get(lastIndex = rows.size() - 1)) instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)iTicketItem;
                return ticketItem;
            }
            return null;
        }

        public int getItemCountOfGroup(ComboGroup selectedComboGroup) {
            int count = 0;
            List rows = this.getRows();
            if (rows != null && rows.size() != 0) {
                for (ITicketItem iTicketItem : rows) {
                    if (iTicketItem instanceof TicketItemModifier) continue;
                    TicketItem ticketItem = (TicketItem)iTicketItem;
                    String groupId = selectedComboGroup.getId();
                    String ticketItemGroupId = ticketItem.getGroupId();
                    if (groupId == null || ticketItemGroupId == null || !groupId.equals(ticketItemGroupId)) continue;
                    count = (int)((double)count + ticketItem.getQuantity());
                }
            }
            return count;
        }
    }

    private class ComboGroupButton
    extends POSToggleButton
    implements ActionListener {
        ComboGroup comboGroup;

        ComboGroupButton(ComboGroup comboGroup) {
            this.comboGroup = comboGroup;
            this.setText("<html><body><center>" + comboGroup.getName() + "</center></body></html>");
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ComboTicketItemSelectionDialog.this.menuItemViewPanel.setBorder(BorderFactory.createTitledBorder(this.comboGroup.getName() + Messages.getString("ComboTicketItemSelectionDialog.25") + this.comboGroup.getMinQuantity() + Messages.getString("ComboTicketItemSelectionDialog.26") + this.comboGroup.getMaxQuantity()));
            ComboTicketItemSelectionDialog.this.rendererItems(this.comboGroup);
            ComboTicketItemSelectionDialog.this.selectedComboGroup = this.comboGroup;
        }
    }

    private class MenuItemButton
    extends PosButton
    implements ActionListener {
        private int minHeight = PosUIManager.getSize(100);
        private int minWidth = PosUIManager.getSize(120);
        MenuItem menuItem;

        MenuItemButton(MenuItem menuItem) {
            Color textColor;
            this.menuItem = menuItem;
            this.setFocusable(false);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            ImageIcon image = menuItem.getImage();
            if (image != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(image);
                } else {
                    this.setIcon(image);
                    this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItem.getName() + "</center></body></html>");
            }
            Color buttonColor = menuItem.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(buttonColor);
            }
            if ((textColor = menuItem.getTextColor()) != null) {
                this.setForeground(textColor);
            }
            this.addActionListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (preferredSize.width < this.minWidth) {
                preferredSize.width = this.minWidth;
            }
            if (preferredSize.height < this.minHeight) {
                preferredSize.height = this.minHeight;
            }
            return preferredSize;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ComboTicketItemSelectionDialog.this.validQuantity()) {
                POSMessageDialog.showMessage(Messages.getString("ComboTicketItemSelectionDialog.24") + ComboTicketItemSelectionDialog.this.selectedComboGroup.getMaxQuantity());
                return;
            }
            try (Session session = MenuItemDAO.getInstance().createNewSession();){
                session.refresh((Object)this.menuItem);
                if (!ComboTicketItemSelectionDialog.this.addComboItem(this.menuItem)) {
                    return;
                }
            }
        }
    }
}

