/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ItemSearchDialog
extends OkCancelOptionDialog {
    private JComboBox cbMenuGroup;
    private JComboBox cbMenuCategory;
    private JTextField tfName;
    private PosButton btnSearch;
    private JTable table;
    private BeanTableModel<MenuItem> tableModel;
    private MenuItem menuItem;
    private OrderType orderType;

    public ItemSearchDialog() {
        super(POSUtil.getFocusedWindow(), POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(PosUIManager.getSize(900, 700));
        this.init();
    }

    public ItemSearchDialog(Frame parent) {
        super((Window)parent, POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(PosUIManager.getSize(900, 700));
        this.init();
    }

    private void init() {
        this.setResizable(false);
        JPanel contentPane = this.getContentPanel();
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 15, 0, 15));
        MigLayout layout = new MigLayout("fillx, inset 0");
        contentPane.setLayout((LayoutManager)layout);
        this.table = new JTable();
        this.table.setRowHeight(40);
        this.table.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ItemSearchDialog.this.doOk();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ItemSearchDialog.this.doOk();
                }
            }
        });
        this.tableModel = new BeanTableModel(MenuItem.class, 20);
        this.tableModel.addColumn(Messages.getString("ItemSearchDialog.1"), MenuItem.PROP_BARCODE);
        this.tableModel.addColumn(Messages.getString("ItemSearchDialog.2"), MenuItem.PROP_SKU);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "displayName");
        this.tableModel.addColumn(Messages.getString("ItemSearchDialog.4"), MenuItem.PROP_MENU_GROUP_NAME);
        this.tableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuItem.PROP_PRICE);
        this.tableModel.addColumn(Messages.getString("MenuItemExplorer.14"), "availableUnit");
        this.table.setModel(this.tableModel);
        this.tfName = new JTextField();
        this.tfName.setFont(this.tfName.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.tfName.setBackground(Color.WHITE);
        this.btnSearch = new PosButton(Messages.getString("Search"));
        ActionListener searchActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ItemSearchDialog.this.doSetMenuItem();
            }
        };
        this.tfName.addActionListener(searchActionListener);
        this.btnSearch.addActionListener(searchActionListener);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (ItemSearchDialog.this.tfName.getText().length() > 2) {
                    ItemSearchDialog.this.doSetMenuItem();
                } else if (ItemSearchDialog.this.tfName.getText().isEmpty()) {
                    ItemSearchDialog.this.tableModel.removeAll();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        };
        this.tfName.addKeyListener(keyListener);
        contentPane.add((Component)this.createSelectionPanel(), "spanx ,grow");
        contentPane.add((Component)this.tfName, "spanx,split 2, grow");
        contentPane.add((Component)this.btnSearch, "gaptop 0, wrap");
        contentPane.add((Component)new PosScrollPane(this.table), "span, grow");
        QwertyKeyPad keypad = new QwertyKeyPad();
        keypad.setKeyPadListener(keyListener);
        contentPane.add((Component)((Object)keypad), "spanx ,grow");
        this.resizeColumnWidth(this.table);
        this.tfName.setFocusable(true);
        this.tfName.requestFocus();
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    public void updateFilterPanel(OrderType orderType) {
        this.orderType = orderType;
        this.cbMenuCategory.removeAllItems();
        this.cbMenuGroup.removeAllItems();
        this.cbMenuCategory.addItem(Messages.getString("ALL"));
        List<MenuCategory> categoryGroups = MenuCategoryDAO.getInstance().findActiveCategories(orderType);
        for (MenuCategory categoryGroup : categoryGroups) {
            this.cbMenuCategory.addItem(categoryGroup);
        }
        this.cbMenuGroup.addItem(Messages.getString("ALL"));
        List<MenuGroup> menuGroups = MenuGroupDAO.getInstance().loadActiveGroupsByOrderType(orderType);
        for (MenuGroup menuGroup : menuGroups) {
            this.cbMenuGroup.addItem(menuGroup);
        }
    }

    private JPanel createSelectionPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("ins 0", "[][]15[][]", "[]5[]"));
        JLabel lbCategory = new JLabel(Messages.getString("ItemSearchDialog.11"));
        this.cbMenuCategory = new JComboBox();
        JLabel lbGroup = new JLabel(Messages.getString("ItemSearchDialog.12"));
        this.cbMenuGroup = new JComboBox();
        this.cbMenuCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ItemSearchDialog.this.doSetMenuGroup();
            }
        });
        this.disableFocus(lbCategory, this.cbMenuCategory, lbGroup, this.cbMenuGroup);
        this.cbMenuCategory.setMinimumSize(PosUIManager.getSize(150, 30));
        this.cbMenuGroup.setMinimumSize(PosUIManager.getSize(150, 30));
        panel.add(lbCategory);
        panel.add(this.cbMenuCategory);
        panel.add(lbGroup);
        panel.add(this.cbMenuGroup);
        return panel;
    }

    private void disableFocus(Component ... components) {
        for (Component component : components) {
            component.setFocusable(false);
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(100);
        columnWidth.add(100);
        columnWidth.add(250);
        columnWidth.add(250);
        columnWidth.add(50);
        columnWidth.add(50);
        return columnWidth;
    }

    @Override
    public void doOk() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("ItemSearchDialog.3"));
            return;
        }
        this.menuItem = this.tableModel.getRow(index);
        this.tableModel.removeAll();
        this.tfName.setText("");
        this.setCanceled(false);
        this.dispose();
    }

    public MenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    private void doSetMenuItem() {
        List<MenuItem> menuItems;
        String itemName = this.tfName.getText();
        if (StringUtils.isEmpty((String)itemName)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("ItemSearchDialog.0"));
            return;
        }
        this.tableModel.removeAll();
        MenuItemDAO dao = new MenuItemDAO();
        MenuCategory menuCategory = null;
        Object selectedCategory = this.cbMenuCategory.getSelectedItem();
        if (selectedCategory instanceof MenuCategory) {
            menuCategory = (MenuCategory)this.cbMenuCategory.getSelectedItem();
        }
        Object selectedGroup = this.cbMenuGroup.getSelectedItem();
        MenuGroup menuGroup = null;
        if (selectedGroup instanceof MenuGroup) {
            menuGroup = (MenuGroup)this.cbMenuGroup.getSelectedItem();
        }
        if ((menuItems = dao.getMenuItemsByName(this.orderType, menuCategory, menuGroup, itemName, true)) != null && menuItems.size() > 0) {
            this.tableModel.addRows(menuItems);
        }
        this.table.repaint();
    }

    private void doSetMenuGroup() {
        try {
            Object object = this.cbMenuCategory.getSelectedItem();
            MenuCategory selectedCategory = null;
            if (object instanceof MenuCategory) {
                selectedCategory = (MenuCategory)this.cbMenuCategory.getSelectedItem();
            }
            List<MenuGroup> menuGroups = null;
            menuGroups = selectedCategory == null ? MenuGroupDAO.getInstance().loadActiveGroupsByOrderType(this.orderType) : MenuGroupDAO.getInstance().findByParent(selectedCategory);
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.cbMenuGroup.getModel();
            model.removeAllElements();
            model.addElement(Messages.getString("ALL"));
            for (MenuGroup menuGroup : menuGroups) {
                model.addElement(menuGroup);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

