/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.ui.model.MenuItemSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MenuItemSelectionDialog
extends POSDialog
implements ActionListener {
    private MenuItemSelectionView menuSelectorPanel;
    private List<MenuItem> menuItemList;
    private int selectionMode;
    private TitlePanel titelpanel;
    private boolean inventoryItemOnly;
    private static MenuItemSelectionDialog instance;

    public MenuItemSelectionDialog(List<MenuItem> menuItemList) {
        super(POSUtil.getFocusedWindow(), "");
        this.menuItemList = menuItemList;
        this.initComponents();
    }

    public MenuItemSelectionDialog(List<MenuItem> menuItemList, boolean inventoryItemOnly) {
        super(POSUtil.getFocusedWindow(), "");
        this.menuItemList = menuItemList;
        this.inventoryItemOnly = inventoryItemOnly;
        this.initComponents();
    }

    public MenuItemSelectionDialog() {
        super(POSUtil.getFocusedWindow(), "");
        this.setTitle(Messages.getString("MenuItemSelectionDialog.3"));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(Messages.getString("MenuItemSelectionDialog.4"));
        this.titelpanel = new TitlePanel();
        this.titelpanel.setTitle(Messages.getString("MenuItemSelectionDialog.5"));
        this.add((Component)this.titelpanel, "North");
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.menuSelectorPanel = new MenuItemSelectionView(this.menuItemList, this.inventoryItemOnly, this);
        contentPane.add((Component)this.menuSelectorPanel, "grow,span,wrap");
        PosButton btnOk = new PosButton(Messages.getString("MenuItemSelectionDialog.8"));
        btnOk.setActionCommand(POSConstants.OK);
        btnOk.setBackground(Color.GREEN);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,center,ins 0 5 5 5", "", ""));
        PosButton btnAdd = new PosButton();
        btnAdd.setText(POSConstants.ADD);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuItem menuMenuItem = new MenuItem();
                    MenuItemForm editor = new MenuItemForm(menuMenuItem);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(1000, 700);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuItem menuItemItem = (MenuItem)editor.getBean();
                    MenuItemSelectionDialog.this.menuSelectorPanel.getModel().addItem(menuItemItem);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        if (POSUtil.isAllowLocalItem()) {
            footerPanel.add(btnAdd);
        }
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
    }

    public void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
        if (selectionMode == 0) {
            this.titelpanel.setTitle(Messages.getString("MenuItemSelectionDialog.12"));
        } else {
            this.titelpanel.setTitle(Messages.getString("MenuItemSelectionDialog.13"));
        }
        this.menuSelectorPanel.setSelectionMode(selectionMode);
    }

    public void setSelectedGroup(MenuGroup group) {
        this.menuSelectorPanel.setSelectedGroup(group);
    }

    private void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    public List<MenuItem> getSelectedItems() {
        return this.menuSelectorPanel.getSelectedMenuItemList();
    }

    public MenuItem getSelectedRowData() {
        int index = this.menuSelectorPanel.getSelectedRow();
        if (index < 0) {
            return null;
        }
        return (MenuItem)this.menuSelectorPanel.getModel().getRowData(index);
    }

    public static MenuItemSelectionDialog getInstance() {
        if (instance == null) {
            instance = new MenuItemSelectionDialog();
        }
        return instance;
    }

    public void doSearch(String searchText) {
        this.menuSelectorPanel.searchItem(searchText);
    }

    public void setShowVariantParent(boolean isShowVarParent) {
        this.menuSelectorPanel.setShowVariantParent(isShowVarParent);
    }

    public void setHideEditButton(boolean isHideEditButton) {
    }

    public void setShowVariant(boolean isShowVariant) {
        this.menuSelectorPanel.setShowVariant(isShowVariant);
    }

    public void setShowComboItem(boolean isShowComboItem) {
        this.menuSelectorPanel.setShowComboItem(isShowComboItem);
    }
}

