/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

public class POSDialog
extends JDialog {
    protected boolean canceled = true;

    public POSDialog() throws HeadlessException {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.initUI();
    }

    public POSDialog(Dialog owner, boolean modal) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), modal);
    }

    public POSDialog(Dialog owner, String title, boolean modal) {
        this(POSUtil.getFocusedWindow(), title, modal);
    }

    public POSDialog(Frame owner, String title, boolean modal) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), modal);
    }

    public POSDialog(Frame owner, String title) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), true);
    }

    public POSDialog(Frame owner) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), true);
    }

    public POSDialog(Window owner, Dialog.ModalityType modalityType) {
        super(POSUtil.getFocusedWindow(), modalityType);
        this.initUI();
    }

    public POSDialog(Window owner) {
        super(owner);
        this.initUI();
    }

    public POSDialog(Frame owner, boolean modal) {
        this(POSUtil.getFocusedWindow(), VersionInfo.getAppName(), modal);
    }

    public POSDialog(Window owner, String title) {
        this(owner, VersionInfo.getAppName(), true);
    }

    public POSDialog(Window owner, String title, boolean modal) {
        super(owner, VersionInfo.getAppName(), modal ? Dialog.ModalityType.APPLICATION_MODAL : Dialog.ModalityType.MODELESS);
        this.initUI();
    }

    protected void initUI() {
        this.setIcon();
        ActionListener escapeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                POSDialog.this.setCanceled(true);
                POSDialog.this.dispose();
            }
        };
        this.getRootPane().registerKeyboardAction(escapeListener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void open() {
        this.canceled = true;
        if (this.isUndecorated()) {
            Window owner = this.getOwner();
            if (owner instanceof JFrame) {
                JFrame frame = (JFrame)owner;
                this.setLocationRelativeTo(frame.getContentPane());
            } else {
                this.setLocationRelativeTo(owner);
            }
        } else {
            this.setLocationRelativeTo(this.getOwner());
        }
        this.setVisible(true);
    }

    public void openFullScreen() {
        this.canceled = true;
        if (TerminalConfig.isKioskMode()) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(screenSize);
            this.setUndecorated(true);
        } else {
            Rectangle windowBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            windowBounds.height -= 50;
            this.setBounds(windowBounds);
        }
        this.setResizable(true);
        this.setLocationRelativeTo(POSUtil.getFocusedWindow());
        this.setVisible(true);
    }

    public void openUndecoratedFullScreen() {
        this.openFullScreen();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    private void setIcon() {
        PosWindow posWindow = Application.getPosWindow();
        if (posWindow != null) {
            this.setIconImage(posWindow.getIconImage());
        }
    }
}

