/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.JDBCException;

public class POSMessageDialog {
    private static Logger logger = Logger.getLogger(Application.class);

    private static void showDialog(Component parent, String message, int messageType, int optionType) {
        POSMessageDialog.showDialog(parent, message, messageType, optionType, null, null);
    }

    private static boolean showDialog(Component parent, String message, int messageType, int optionType, String option, Throwable x) {
        if (StringUtils.isEmpty((String)message) || message.startsWith("Batch update")) {
            message = Messages.getString("POSMessageDialog.0");
        }
        if (StringUtils.isNotBlank((String)message) && message.startsWith("Unable to acquire JDBC Connection")) {
            message = Messages.getString("POSMessageDialog.6");
        }
        String submitErrorText = Messages.getString("POSMessageDialog.1");
        JOptionPane optionPane = null;
        ArrayList<String> optionList = new ArrayList<String>(3);
        if (option != null) {
            optionList.add(option);
        }
        if (messageType == 0 && x != null && !(x instanceof PosException) && !(x instanceof JDBCException)) {
            optionList.add(submitErrorText);
            logger.error((Object)message, x);
        }
        optionList.add(POSConstants.OK);
        optionPane = new JOptionPane(message, messageType, optionType, null, optionList.toArray(new String[0]));
        POSMessageDialog.customizeOption(optionPane, submitErrorText, x);
        String title = "";
        title = messageType == 0 ? Messages.getString("MessageDialog.0") : (messageType == 1 ? Messages.getString("POSMessageDialog.5") : VersionInfo.getAppName());
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.setModal(true);
        dialog.setVisible(true);
        if (option == null) {
            return false;
        }
        Object selectedValue = optionPane.getValue();
        return selectedValue != null && selectedValue.equals(option);
    }

    public static void showMessage(String message) {
        POSMessageDialog.showDialog(POSUtil.getFocusedWindow(), message, 1, -1);
    }

    public static void showMessage(Component parent, String message) {
        POSMessageDialog.showDialog(POSUtil.getFocusedWindow(), message, 1, -1);
    }

    public static void showError(String message) {
        POSMessageDialog.showDialog(POSUtil.getFocusedWindow(), message, 0, -1);
    }

    public static void showError(Component parent, String message) {
        POSMessageDialog.showDialog(POSUtil.getFocusedWindow(), message, 0, -1);
    }

    public static boolean showErrorWithOption(Component parent, String message, String option) {
        return POSMessageDialog.showDialog(POSUtil.getFocusedWindow(), message, 0, -1, option, null);
    }

    public static void showError(Component parent, String message, Throwable x) {
        POSMessageDialog.showDialog(POSUtil.getFocusedWindow(), message, 0, -1, null, x);
    }

    public static int showYesNoQuestionDialog(String message) {
        return POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, POSConstants.CONFIRM, null, null);
    }

    public static int showYesNoQuestionDialog(String message, String title) {
        return POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), message, title, null, null);
    }

    public static int showYesNoQuestionDialog(Component parent, String message, String title) {
        return POSMessageDialog.showYesNoQuestionDialog(parent, message, title, null, null);
    }

    public static int showYesNoQuestionDialog(Component parent, String message, String title, String yesButtonText, String noButtonText) {
        Component[] options;
        JOptionPane optionPane = null;
        optionPane = yesButtonText != null && noButtonText != null ? new JOptionPane(message, 3, 1, null, new String[]{yesButtonText, noButtonText}) : new JOptionPane(message, 3, 0);
        for (Component object : options = optionPane.getComponents()) {
            Component[] components;
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            for (Component component : components = panel.getComponents()) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(new Dimension(component.getPreferredSize().width, 60));
            }
        }
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        if (selectedValue instanceof String) {
            return selectedValue.equals(noButtonText) ? 1 : 0;
        }
        return (Integer)selectedValue;
    }

    public static String showOptionDialog(Component parent, String message, String title, String ... options) {
        Component[] optionComponents;
        JOptionPane optionPane = null;
        optionPane = options != null ? new JOptionPane(message, 3, 1, null, options) : new JOptionPane(message, 3, 0);
        for (Component object : optionComponents = optionPane.getComponents()) {
            Component[] components;
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            for (Component component : components = panel.getComponents()) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(new Dimension(component.getPreferredSize().width, 60));
            }
        }
        JDialog dialog = optionPane.createDialog(parent, title);
        dialog.setVisible(true);
        Object selectedValue = optionPane.getValue();
        if (selectedValue != null) {
            return selectedValue.toString();
        }
        return null;
    }

    public static boolean showMessageAndPromtToPrint(String msg) {
        return POSMessageDialog.showMessageAndPromtToPrint(null, msg);
    }

    public static boolean showMessageAndPromtToPrint(Component parent, String msg) {
        Component[] optionValues;
        JOptionPane promtPane = new JOptionPane(msg, 1, 1, null, new String[]{POSConstants.PRINT, POSConstants.OK.toUpperCase()});
        for (Component object : optionValues = promtPane.getComponents()) {
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            Component[] components = panel.getComponents();
            boolean printIcon = true;
            for (Component component : components) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(PosUIManager.getSize(100, 50));
                JButton button = (JButton)component;
                if (!printIcon) continue;
                button.setIcon(IconFactory.getIcon("/ui_icons/", "print_32.png"));
                button.setText(Messages.getString("POSMessageDialog.2"));
                printIcon = false;
                button.setFocusable(false);
            }
        }
        JDialog dialog = promtPane.createDialog(parent == null ? POSUtil.getFocusedWindow() : parent, "Message");
        dialog.setDefaultCloseOperation(0);
        dialog.setIconImage(Application.getApplicationIcon().getImage());
        dialog.setVisible(true);
        String selectedValue = (String)promtPane.getValue();
        return selectedValue.equals(POSConstants.PRINT);
    }

    public static void showMessageDialogWithReloadButton(Component parent, RefreshableView refreshView) {
        POSMessageDialog.showMessageDialogWithReloadButton(parent, refreshView, Messages.getString("POSMessageDialog.3"));
    }

    public static void showMessageDialogWithReloadButton(Component parent, RefreshableView refreshView, String msg) {
        Component[] options;
        JOptionPane reloadPane = new JOptionPane(msg, 0, 0, null, new String[]{Messages.getString("POSMessageDialog.4")});
        for (Component object : options = reloadPane.getComponents()) {
            Component[] components;
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            for (Component component : components = panel.getComponents()) {
                if (!(component instanceof JButton)) continue;
                component.setPreferredSize(new Dimension(component.getPreferredSize().width, 60));
            }
        }
        JDialog dialog = reloadPane.createDialog(parent == null ? POSUtil.getFocusedWindow() : parent, Messages.getString("MessageDialog.0"));
        dialog.setDefaultCloseOperation(2);
        dialog.setIconImage(Application.getApplicationIcon().getImage());
        dialog.setVisible(true);
        if (refreshView != null) {
            refreshView.refresh();
        }
    }

    private static void customizeOption(JOptionPane optionPane, String submitErrorText, Throwable x) {
        Component[] options;
        for (Component object : options = optionPane.getComponents()) {
            Component[] components;
            if (!(object instanceof JPanel)) continue;
            JPanel panel = (JPanel)object;
            for (Component component : components = panel.getComponents()) {
                if (!(component instanceof JButton)) continue;
                JButton button = (JButton)component;
                component.setPreferredSize(new Dimension(component.getPreferredSize().width, 60));
                if (!submitErrorText.equals(button.getText())) continue;
                POSMessageDialog.createSubmitErrorAction(button, x);
            }
        }
    }

    private static void createSubmitErrorAction(JButton button, final Throwable x) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    StringWriter stringWriter = new StringWriter();
                    PrintWriter printWriter = new PrintWriter(stringWriter);
                    x.printStackTrace(printWriter);
                    printWriter.close();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<pre>");
                    stringBuffer.append("System: " + VersionInfo.getAppName());
                    stringBuffer.append("\nVersion: " + VersionInfo.getVersion());
                    Store store = DataProvider.get().getStore();
                    String subject = VersionInfo.getAppName() + " error log";
                    if (store != null) {
                        subject = store.getName() + " " + VersionInfo.getAppName() + " error log";
                        stringBuffer.append("\nStore: " + store.getName());
                        Terminal terminal = DataProvider.get().getCurrentTerminal();
                        if (terminal != null) {
                            stringBuffer.append("\nTerminal key: " + terminal.getTerminalKey());
                        }
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(stringWriter.toString());
                    stringBuffer.append("</pre>");
                    MailService.sendMail("oroposlog@gmail.com", subject, stringBuffer.toString());
                }
                catch (Exception e) {
                    POSMessageDialog.showError(Messages.getString("POSMessageDialog.15"));
                }
            }
        });
    }

    public static void showError(String message, Throwable e2) {
        POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e2);
    }
}

