/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.Promotion;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class PromotionSelectionDialog
extends POSDialog {
    private Promotion selectedPromotion;
    private double dueAmount;

    public PromotionSelectionDialog(List<Promotion> activePromotions, double dueAmount) throws HeadlessException {
        this.dueAmount = dueAmount;
        this.setTitle(AppProperties.getAppName());
        this.setLayout(new BorderLayout(5, 5));
        this.setSize(800, 600);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Select Promotion");
        JPanel promotionPanel = new JPanel(new WrapLayout(1));
        promotionPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        for (final Promotion promotion : activePromotions) {
            PosButton button = new PosButton("<html><center>" + promotion.getName() + "</center></html>");
            button.setPreferredSize(PosUIManager.getSize(180, 160));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PromotionSelectionDialog.this.doSelectPromotion(promotion);
                }
            });
            promotionPanel.add(button);
        }
        PosButton btnOk = new PosButton(POSConstants.OK);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PromotionSelectionDialog.this.setCanceled(false);
                PromotionSelectionDialog.this.dispose();
            }
        });
        PosButton btnCancel = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PromotionSelectionDialog.this.setCanceled(true);
                PromotionSelectionDialog.this.dispose();
            }
        });
        JPanel actionPanel = new JPanel();
        actionPanel.add(btnOk);
        actionPanel.add(btnCancel);
        this.add((Component)titlePanel, "North");
        this.add((Component)new JScrollPane(promotionPanel), "Center");
        this.add((Component)actionPanel, "South");
    }

    public Promotion getPromotion() {
        return this.selectedPromotion;
    }

    private void doSelectPromotion(Promotion promotion) {
        try {
            double value = 0.0;
            if (promotion.isAmountBased().booleanValue()) {
                value = NumberSelectionDialog2.takeDoubleInput("Enter amount: ", AppProperties.getAppName(), this.dueAmount);
            } else if (promotion.isPercentageBased().booleanValue()) {
                value = NumberSelectionDialog2.takeDoubleInput("Enter percentage: ", AppProperties.getAppName(), 100.0);
            }
            promotion.setValue(value);
            this.selectedPromotion = promotion;
            if (Double.isNaN(value)) {
                return;
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }
}

