/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.TicketCloseAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class ServerOpenTicketListDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private JXTable tableTicket;
    private TicketTableModel tableModel;
    private DefaultListSelectionModel selectionModel;
    private User currentUser;
    private User serverUser;
    private PosButton btnDone;
    private boolean filterByUser;
    private JCheckBox chkSelectAll;

    public ServerOpenTicketListDialog(User currentUser, User user, boolean filterByUser) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.currentUser = currentUser;
        this.serverUser = user;
        this.filterByUser = filterByUser;
        this.initComponents();
        this.initData();
        this.updateView();
    }

    @Override
    public void setTitle(String title) {
        super.setTitle(POSConstants.OPEN_TICKETS);
        this.titlePanel.setTitle(title);
    }

    private void initComponents() {
        TransparentPanel container = new TransparentPanel();
        this.titlePanel = new TitlePanel();
        TransparentPanel contentPanel = new TransparentPanel();
        TransparentPanel bottomActionPanel = new TransparentPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        JSeparator jSeparator1 = new JSeparator();
        this.btnDone = new PosButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.tableTicket = new JXTable();
        this.tableTicket.setRowHeight(PosUIManager.getSize(30));
        this.tableTicket.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.tableTicket.setSelectionMode(2);
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)jSeparator1, "North");
        PosButton btnTransferAll = new PosButton(POSConstants.TRANSFER);
        btnTransferAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerOpenTicketListDialog.this.doTransferTickets();
            }
        });
        bottomActionPanel.add(btnTransferAll);
        PosButton btnSettleAll = new PosButton(POSConstants.SETTLE);
        btnSettleAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerOpenTicketListDialog.this.doGroupSettle();
            }
        });
        bottomActionPanel.add(btnSettleAll);
        this.btnDone.setText(Messages.getString("DONE"));
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerOpenTicketListDialog.this.btnCloseActionPerformed(evt);
            }
        });
        bottomActionPanel.add(this.btnDone);
        container.add((Component)bottomActionPanel, "Center");
        this.getContentPane().add((Component)container, "South");
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.titlePanel, "North");
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[][]"));
        jScrollPane1.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(5, 10, 5, 10), jScrollPane1.getBorder()));
        jScrollPane1.setViewportView((Component)this.tableTicket);
        this.chkSelectAll = new JCheckBox(Messages.getString("MultipleCustomerSelectionView.19"));
        this.chkSelectAll.addActionListener(e -> this.selectAllItems());
        tablePanel.add((Component)this.chkSelectAll, "gapleft 10,gaptop 10,left");
        contentPanel.add((Component)tablePanel, "North");
        contentPanel.add((Component)jScrollPane1, "Center");
        JPanel cashSummaryPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0"));
        contentPanel.add((Component)cashSummaryPanel, "South");
        this.getContentPane().add((Component)contentPanel, "Center");
    }

    private void selectAllItems() {
        List tickets = this.tableModel.getRows();
        if (tickets != null && tickets.size() > 0) {
            for (Ticket ticket : tickets) {
                ticket.setSelectedInUi(this.chkSelectAll.isSelected());
            }
        } else {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MultipleCustomerSelectionView.21"));
            this.chkSelectAll.setSelected(false);
        }
        this.tableTicket.repaint();
    }

    public void initData() {
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(2);
        this.tableTicket.getSelectionModel().setSelectionMode(2);
        this.tableTicket.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.tableModel = new TicketTableModel();
        this.tableTicket.setModel((TableModel)this.tableModel);
        this.tableTicket.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                ServerOpenTicketListDialog.this.selectItem();
            }
        });
        AbstractAction transferAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.tableModel.getRowData(row);
                ServerOpenTicketListDialog.this.doTransferTicket(ticket);
                ServerOpenTicketListDialog.this.updateView();
            }
        };
        AbstractAction settleAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.tableModel.getRowData(row);
                new SettleTicketAction(ticket, ServerOpenTicketListDialog.this.currentUser).actionPerformed(e);
                ServerOpenTicketListDialog.this.updateView();
            }
        };
        this.addButtonColumnAction(transferAction, 6);
        this.addButtonColumnAction(settleAction, 7);
        this.addButtonColumnAction(new CloseTicketAction(), 8);
        this.resizeTableColumns();
        TableColumnModelExt columnModel = (TableColumnModelExt)this.tableTicket.getColumnModel();
        columnModel.getColumnExt(2).setVisible(!this.filterByUser);
    }

    private void selectItem() {
        Ticket ticket;
        if (this.tableTicket.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = this.tableTicket.getSelectedRow();
        ticket.setSelectedInUi((ticket = (Ticket)this.tableModel.getRowData(selectedRow = this.tableTicket.convertRowIndexToModel(selectedRow))).isSelectedInUi() == false);
        this.tableTicket.repaint();
    }

    private void addButtonColumnAction(AbstractAction action, int columnNum) {
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.tableTicket, action, columnNum){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(3, 3, 3, 3, this.tableTicket.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(3, 3, 3, 3, this.tableTicket.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, this.btnDone.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, this.btnDone.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
    }

    private void doTransferTicket(Ticket ticket) {
        try {
            TicketTransferAction transferAction = new TicketTransferAction(ticket, this.currentUser);
            transferAction.execute();
            if (!transferAction.isTransfered()) {
                return;
            }
            this.updateView();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(Messages.getString("MessageDialog.0"));
            PosLog.error(this.getClass(), e1);
        }
    }

    private void doTransferTickets() {
        try {
            List<Ticket> tickets = this.getSelectedTickets();
            if (tickets.isEmpty()) {
                POSMessageDialog.showError(Messages.getString("ServerOpenTicketListDialog.3"));
                return;
            }
            int size = tickets.size();
            int i = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("ServerOpenTicketListDialog.4") + size + (size == 1 ? Messages.getString("ServerOpenTicketListDialog.5") : Messages.getString("ServerOpenTicketListDialog.6")));
            if (i != 0) {
                return;
            }
            UserListDialog dialog = new UserListDialog();
            dialog.setTitle(Messages.getString("UserTransferDialog.0"));
            dialog.setCaption(Messages.getString("UserTransferDialog.1"));
            dialog.setSize(PosUIManager.getSize(400, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            User selectedUser = dialog.getSelectedUser();
            TicketTransferAction.doTransferTickets(this.currentUser, selectedUser, tickets);
            POSMessageDialog.showMessage(Messages.getString("ServerOpenTicketListDialog.1"));
            this.updateView();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
    }

    private List<Ticket> getSelectedTickets() {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        for (Ticket ticket : this.tableModel.getRows()) {
            if (ticket == null || !ticket.isSelectedInUi().booleanValue()) continue;
            tickets.add(ticket);
        }
        return tickets;
    }

    protected void doTransferTicket(Ticket ticket, User selectedUser) {
        ticket.setOwner(selectedUser);
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    private void doGroupSettle() {
        List<Ticket> ticketList = this.getSelectedTickets();
        if (ticketList == null || ticketList.isEmpty()) {
            POSMessageDialog.showError(Messages.getString("ServerOpenTicketListDialog.3"));
            return;
        }
        int size = ticketList.size();
        int i = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("ServerOpenTicketListDialog.8") + size + (size == 1 ? Messages.getString("ServerOpenTicketListDialog.9") : Messages.getString("ServerOpenTicketListDialog.10")));
        if (i != 0) {
            return;
        }
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        for (Ticket ticket : ticketList) {
            if (ticket.getOrderType().isBarTab().booleanValue()) continue;
            tickets.add(ticket);
        }
        GroupSettleTicketAction action = new GroupSettleTicketAction(tickets, this.currentUser);
        action.actionPerformed(null);
        this.updateView();
    }

    private void updateView() {
        List<Ticket> ticketList = this.filterByUser ? TicketDAO.getInstance().findOpenTicketsForUser(this.serverUser) : TicketDAO.getInstance().findOpenTickets();
        if (ticketList != null) {
            for (Ticket ticket : ticketList) {
                TicketDAO.getInstance().loadFullTicket(ticket);
            }
        }
        this.tableModel.setItems(ticketList);
        this.tableModel.fireTableDataChanged();
    }

    private void resizeTableColumns() {
        this.tableTicket.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(100));
        this.setColumnWidth(1, PosUIManager.getSize(150));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.tableTicket.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    public void setInfo(String info) {
        this.titlePanel.setTitle(info);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        if (!this.currentUser.isAllowClockOutWithOpenTickets() && this.hasOpenTickets()) {
            this.setCanceled(true);
            this.dispose();
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public boolean hasOpenTickets() {
        return this.tableModel.getRowCount() > 0;
    }

    class CloseTicketAction
    extends TicketCloseAction
    implements DataChangeListener {
        Ticket ticket;
        private int row;

        public CloseTicketAction() {
            this.setDataChangedListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.row = Integer.parseInt(e.getActionCommand());
            this.ticket = (Ticket)ServerOpenTicketListDialog.this.tableModel.getRowData(this.row);
            super.actionPerformed(e);
        }

        @Override
        protected User getCurrentUser() {
            return ServerOpenTicketListDialog.this.currentUser;
        }

        @Override
        public void dataAdded(Object object) {
        }

        @Override
        public void dataChanged(Object object) {
            ServerOpenTicketListDialog.this.tableModel.deleteItem(this.row);
        }

        @Override
        public void dataRemoved(Object object) {
        }

        @Override
        public Object getSelectedObject() {
            return this.ticket;
        }

        @Override
        public void dataSetUpdated() {
        }

        @Override
        public void dataChangeCanceled(Object object) {
        }

        @Override
        public Object getSelectedData() {
            return null;
        }
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                label.setHorizontalAlignment(4);
            }
            if (value instanceof Double || column == 2 || column == 3) {
                label.setHorizontalAlignment(4);
            } else if (column == 1) {
                label.setHorizontalAlignment(2);
            } else {
                label.setHorizontalAlignment(0);
            }
            return label;
        }
    }

    class TicketTableModel
    extends ListTableModel<Ticket> {
        public TicketTableModel() {
            super(new String[]{"", POSConstants.TOKEN, POSConstants.ORDER_TYPE, POSConstants.SERVER, POSConstants.TOTAL, POSConstants.DUE, "", "", ""});
        }

        public void setItems(List<Ticket> ticketList) {
            this.setRows(ticketList);
        }

        @Override
        public int getColumnCount() {
            return 9;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 6 || columnIndex == 7 || columnIndex == 8;
        }

        public Ticket getSelectedRow() {
            int index = ServerOpenTicketListDialog.this.tableTicket.getSelectedRow();
            if (index < 0) {
                return null;
            }
            index = ServerOpenTicketListDialog.this.tableTicket.convertRowIndexToModel(index);
            return (Ticket)ServerOpenTicketListDialog.this.tableModel.getRowData(index);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Ticket t = (Ticket)ServerOpenTicketListDialog.this.tableModel.getRows().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return t.isSelectedInUi();
                }
                case 1: {
                    return t.getTokenNo();
                }
                case 2: {
                    return t.getOrderType();
                }
                case 3: {
                    return t.getOwner();
                }
                case 4: {
                    return NumberUtil.formatNumber(t.getTotalAmountWithTips());
                }
                case 5: {
                    return NumberUtil.formatNumber(t.getDueAmount());
                }
                case 6: {
                    return POSConstants.TRANSFER;
                }
                case 7: {
                    return POSConstants.SETTLE;
                }
                case 8: {
                    return POSConstants.CLOSE.toUpperCase();
                }
            }
            return "";
        }
    }
}

