/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppProperties;
import com.floreantpos.config.ui.MultiroleUserComboRenderer;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.ServerSummaryReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.DateTimePicker;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class ServerSummaryReportDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private User currentUser;
    private CashDrawer serverSummaryReport;
    private StoreSession storeSession;
    private PosButton btnServerSummaryDetails;
    private JPanel buttonPanel;
    private PosButton btnFinish;
    private PosButton btnPrint;
    private JComboBox userCombo;
    private JPanel serverTopActionPanel;
    private JPanel reportViewPanel;
    private JasperPrint serverSummaryDetailjasperPrint;
    private JasperPrint serverSummaryjasperPrint;
    private JRadioButton chkLastClockIn;
    private JRadioButton chkStoreOpenTtime;
    private JRadioButton chkSpecificTime;
    private DateTimePicker fromDatePicker;

    public ServerSummaryReportDialog(User currentUser, StoreSession storeSession) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.currentUser = currentUser;
        this.storeSession = storeSession;
        this.initComponents();
        this.setSize(PosUIManager.getSize(800, 670));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.titlePanel = new TitlePanel();
        this.reportViewPanel = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 4", "[grow]", ""));
        this.btnPrint = new PosButton(Messages.getString("DrawerPullReportDialog.8"));
        this.btnFinish = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.buttonPanel.add((Component)new JSeparator(), "grow,span,wrap");
        this.btnServerSummaryDetails = new PosButton(POSConstants.DETAILS);
        this.buttonPanel.add((Component)this.btnPrint, "grow");
        this.buttonPanel.add((Component)this.btnServerSummaryDetails, "grow");
        this.buttonPanel.add((Component)this.btnFinish, "grow");
        this.serverTopActionPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,center,ins 5 5 5 5,wrap 5", "[grow]", ""));
        this.serverTopActionPanel.setVisible(false);
        List<User> users = UserDAO.getInstance().findUsersForServerSummeryReport();
        JLabel userLabel = new JLabel(POSConstants.SELECT_USER + " :");
        this.userCombo = new OverflowCombobox((ComboBoxModel)new ListComboBoxModel(users));
        this.userCombo.setRenderer(new MultiroleUserComboRenderer());
        this.userCombo.setSelectedItem(this.currentUser);
        this.userCombo.addActionListener(ea -> this.doSearch());
        if (this.currentUser.isAdministrator() || this.currentUser.isManager()) {
            this.serverTopActionPanel.setVisible(true);
        }
        ButtonGroup fromTimeButtonGroup = new ButtonGroup();
        this.chkLastClockIn = new JRadioButton(Messages.getString("ServerSummaryReportDialog.0"));
        this.chkStoreOpenTtime = new JRadioButton(Messages.getString("ServerSummaryReportDialog.1"));
        this.chkSpecificTime = new JRadioButton(Messages.getString("ServerSummaryReportDialog.2"));
        this.fromDatePicker = UiUtil.createCurrentMonthAndTimeStart(Boolean.TRUE);
        this.fromDatePicker.setVisible(false);
        this.fromDatePicker.setDate(DateUtil.createDate(8, 0));
        fromTimeButtonGroup.add(this.chkLastClockIn);
        fromTimeButtonGroup.add(this.chkStoreOpenTtime);
        fromTimeButtonGroup.add(this.chkSpecificTime);
        this.chkLastClockIn.setSelected(true);
        this.chkLastClockIn.addActionListener(e -> this.doVisibleDatePicker());
        this.chkStoreOpenTtime.addActionListener(e -> this.doVisibleDatePicker());
        this.chkSpecificTime.addActionListener(e -> this.doVisibleDatePicker());
        this.fromDatePicker.addActionListener(e -> this.doSearch());
        this.fromDatePicker.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ServerSummaryReportDialog.this.doSearch();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        JPanel userComboPannel = new JPanel();
        userComboPannel.add(userLabel);
        userComboPannel.add(this.userCombo);
        this.serverTopActionPanel.add((Component)userComboPannel, "center");
        JPanel fromTimePanel = new JPanel(new WrapLayout());
        fromTimePanel.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("ServerSummaryReportDialog.3"), 1, 2));
        fromTimePanel.add(this.chkLastClockIn);
        fromTimePanel.add(this.chkStoreOpenTtime);
        fromTimePanel.add(this.chkSpecificTime);
        fromTimePanel.add((Component)((Object)this.fromDatePicker));
        this.serverTopActionPanel.add((Component)fromTimePanel, "center,grow");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0"));
        centerPanel.add((Component)this.serverTopActionPanel, "grow,wrap");
        centerPanel.add((Component)new PosScrollPane(this.reportViewPanel), "grow");
        this.add((Component)this.titlePanel, "North");
        this.add(centerPanel);
        this.add((Component)this.buttonPanel, "South");
        this.btnServerSummaryDetails.addActionListener(e -> this.doShowServerDetailsReport());
        this.btnFinish.addActionListener(e -> this.doCloseDialog());
        this.btnPrint.addActionListener(e -> this.doPrintReport());
    }

    private void doSearch() {
        try {
            this.currentUser = (User)this.userCombo.getSelectedItem();
            this.refreshServerSummeryReport();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    private void doVisibleDatePicker() {
        this.fromDatePicker.setVisible(this.chkSpecificTime.isSelected());
        this.doSearch();
    }

    private void doShowServerDetailsReport() {
        try {
            this.buildServerDetailTransationReport();
            DetailReportDialog dialog = new DetailReportDialog(this.serverSummaryDetailjasperPrint);
            dialog.setTitle(Messages.getString("ServerSummaryReportDialog.13"));
            dialog.updateView();
            dialog.open();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private void buildServerDetailTransationReport() throws JRException {
        ArrayList<PosTransaction> allTransactionsList = new ArrayList<PosTransaction>();
        Date reportTime = this.getReportTime();
        List<PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactionsForServer(this.storeSession.getId(), this.currentUser.getId(), reportTime, StoreDAO.getServerTimestamp());
        allTransactionsList.addAll(transactions);
        CashDrawerTransactionReportModel reportModel = new CashDrawerTransactionReportModel();
        reportModel.setItems(allTransactionsList);
        HashMap<String, String> map = new HashMap<String, String>();
        Store store = DataProvider.get().getStore();
        map.put("headerLine1", store.getName());
        map.put("headerLine2", store.getAddressLine1());
        map.put("receiptType", Messages.getString("ServerSummaryReportDialog.13"));
        if (this.currentUser != null) {
            String userInfo = this.currentUser.getFullName();
            map.put("serverName", Messages.getString("ServerSummaryReportDialog.16") + userInfo);
        }
        Date storeCloseTime = this.storeSession != null ? this.storeSession.getCloseTime() : new Date();
        String strDate = "<b>" + Messages.getString("FROM") + "</b> " + DateUtil.formatFullDateAndTimeAsString(reportTime) + " <b>" + Messages.getString("TO") + "</b> " + DateUtil.formatFullDateAndTimeAsString(storeCloseTime != null ? storeCloseTime : new Date());
        map.put("startDate", strDate);
        map.put("status", allTransactionsList == null || allTransactionsList.isEmpty() ? Messages.getString("NoTransactionFound") : null);
        JasperReport masterReport = ReportUtil.getReport("server_details_report");
        this.serverSummaryDetailjasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
    }

    private Date getReportTime() {
        Date reportTime = null;
        if (this.chkLastClockIn.isSelected()) {
            if (this.currentUser.getLastClockInTime() != null) {
                reportTime = this.currentUser.getLastClockInTime();
            } else {
                AttendenceHistory attendanceHistory = AttendenceHistoryDAO.getInstance().findLastAttendanceHistory(this.currentUser);
                if (attendanceHistory != null) {
                    reportTime = attendanceHistory.getClockInTime();
                }
            }
        } else if (this.chkStoreOpenTtime.isSelected()) {
            reportTime = this.storeSession.getOpenTime();
        } else if (this.chkSpecificTime.isSelected()) {
            reportTime = this.fromDatePicker.getDate();
        }
        return reportTime;
    }

    private void doCloseDialog() {
        this.dispose();
    }

    private void doPrintReport() {
        try {
            PosPrintService.printReportByJasperPrint(this.serverSummaryjasperPrint);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + ex.getMessage());
            PosLog.error(this.getClass(), ex);
        }
    }

    public void refreshServerSummeryReport() throws Exception {
        this.createServerSummaryReport();
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
        super.setTitle(AppProperties.getAppName());
    }

    public void createServerSummaryReport() throws Exception {
        this.reportViewPanel.removeAll();
        Date reportTime = this.getReportTime();
        ServerSummaryReportService reportService = new ServerSummaryReportService(this.currentUser, this.storeSession, reportTime == null ? new Date() : reportTime);
        this.serverSummaryReport = reportService.populateServerSummaryReport();
        this.serverSummaryjasperPrint = PosPrintService.populateServerSummaryReportParameters(this.serverSummaryReport);
        TicketReceiptView receiptView = new TicketReceiptView(this.serverSummaryjasperPrint);
        receiptView.setZoom(1.25f);
        this.reportViewPanel.add(receiptView.getReportPanel());
        this.reportViewPanel.revalidate();
        this.reportViewPanel.repaint();
    }
}

