/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Ticket;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;

public class TicketNoteEntryDialog
extends POSDialog {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTextArea txtANote;
    private JTextArea txtAReciprocalNote;
    private Ticket ticket;
    private OrderView orderView;

    public TicketNoteEntryDialog(OrderView orderView) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.ticket = orderView.getCurrentTicket();
        this.orderView = orderView;
        this.setTitle(Messages.getString("TicketNoteEntryDialog.0"));
        this.initComponents();
        this.initData();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        centerPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        centerPanel.add((Component)this.tabbedPane, "grow");
        this.add((Component)centerPanel, "Center");
        this.txtANote = new JTextArea();
        this.txtANote.setEditable(false);
        this.txtANote.setWrapStyleWord(true);
        this.txtANote.setLineWrap(true);
        this.txtANote.setBackground(Color.WHITE);
        this.txtAReciprocalNote = new JTextArea();
        this.txtAReciprocalNote.setEditable(false);
        this.txtAReciprocalNote.setLineWrap(true);
        this.txtAReciprocalNote.setWrapStyleWord(true);
        this.txtAReciprocalNote.setBackground(Color.WHITE);
        PosButton btnEdit = new PosButton(POSConstants.EDIT);
        btnEdit.addActionListener(e -> this.doEditNote());
        PosButton btnClose = new PosButton(POSConstants.CLOSE);
        btnClose.addActionListener(e -> this.doClose());
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center"));
        footerPanel.add((Component)btnEdit, "grow");
        footerPanel.add((Component)btnClose, "grow");
        this.add((Component)footerPanel, "South");
    }

    private void doEditNote() {
        try {
            String note = null;
            int index = this.tabbedPane.getSelectedIndex();
            note = index == 0 ? this.ticket.getNote() : this.ticket.getProperty("reciprocal_member.note");
            NotesDialog dialog = new NotesDialog();
            dialog.setTitle(VersionInfo.getAppName());
            dialog.setCaption(Messages.getString("OrderView.104"));
            dialog.setNote(note);
            dialog.setSize(PosUIManager.getSize(900, 500));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            note = dialog.getNote();
            if (note != null) {
                if (index == 0) {
                    this.ticket.setNote(note);
                    this.txtANote.setText(note);
                } else {
                    this.ticket.addProperty("reciprocal_member.note", note);
                    this.txtAReciprocalNote.setText(note);
                }
                this.orderView.setCurrentTicket(this.ticket);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    private void doClose() {
        this.setCanceled(true);
        this.dispose();
    }

    private void initData() {
        try {
            this.txtANote.setText(this.ticket.getNote());
            this.txtAReciprocalNote.setText(this.ticket.getProperty("reciprocal_member.note"));
            this.tabbedPane.add(Messages.getString("TicketNoteEntryDialog.6"), new PosScrollPane(this.txtANote));
            this.tabbedPane.add(Messages.getString("TicketNoteEntryDialog.7"), new PosScrollPane(this.txtAReciprocalNote));
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }
}

