/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.DeclaredTipsDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TipsCashoutReportDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class TipsDeclarationDialog
extends POSDialog {
    private TitlePanel titlePanel;
    private JXTable table;
    private DeclaredTipsTableModel tableModel;
    private User user;
    private StoreSession currentSession;
    private PosButton btnCancel;

    public TipsDeclarationDialog(User user, StoreSession currentSession, List<DeclaredTips> declaredTips) {
        super(Application.getPosWindow(), "", true);
        this.user = user;
        this.currentSession = currentSession;
        this.initComponents();
        this.initData();
        this.setDeclaredTips(declaredTips);
    }

    public void setDeclaredTips(List declaredTips) {
        this.tableModel.setRows(declaredTips);
        this.table.repaint();
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
    }

    private void initComponents() {
        TransparentPanel container = new TransparentPanel();
        this.titlePanel = new TitlePanel();
        TransparentPanel contentPanel = new TransparentPanel();
        TransparentPanel bottomActionPanel = new TransparentPanel((LayoutManager)new MigLayout("al center", "", ""));
        JSeparator jSeparator1 = new JSeparator();
        this.btnCancel = new PosButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.table = new JXTable();
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        container.setLayout(new BorderLayout(5, 5));
        PosButton btnShowServerTipsReport = new PosButton(Messages.getString("TipsDeclarationDialog.1"));
        btnShowServerTipsReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TipsDeclarationDialog.this.showServerTipsHistory();
            }
        });
        PosButton btnAdd = new PosButton(Messages.getString("TipsDeclarationDialog.2"));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TipsDeclarationDialog.this.doDeclareNewTips();
            }
        });
        this.btnCancel.setText(Messages.getString("DONE"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TipsDeclarationDialog.this.btnCloseActionPerformed(evt);
            }
        });
        bottomActionPanel.add(btnShowServerTipsReport);
        bottomActionPanel.add(btnAdd);
        bottomActionPanel.add(this.btnCancel);
        container.add((Component)jSeparator1, "Center");
        container.add((Component)bottomActionPanel, "South");
        this.getContentPane().add((Component)container, "South");
        contentPanel.setLayout(new BorderLayout());
        contentPanel.add((Component)this.titlePanel, "North");
        jScrollPane1.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 10, 5, 10), jScrollPane1.getBorder()));
        jScrollPane1.setViewportView((Component)this.table);
        contentPanel.add((Component)jScrollPane1, "Center");
        JPanel cashSummaryPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0"));
        contentPanel.add((Component)cashSummaryPanel, "South");
        this.getContentPane().add((Component)contentPanel, "Center");
    }

    private void showServerTipsHistory() {
        try {
            TipsCashoutReport report = GratuityDAO.getInstance().createReport(null, null, this.user, true);
            TipsCashoutReportDialog dialog = new TipsCashoutReportDialog(report);
            dialog.setCaption(POSConstants.SERVER_TIPS_REPORT);
            dialog.setSize(650, 600);
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void doDeclareNewTips() {
        try {
            double declareTips = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TipsDeclarationDialog.4"), 0.0);
            if (declareTips < 0.0) {
                return;
            }
            DeclaredTips declaredTips = new DeclaredTips();
            declaredTips.setOwnerId(this.user.getId());
            declaredTips.setAmount(declareTips);
            declaredTips.setDeclaredTime(new Date());
            declaredTips.setSessionId(this.currentSession.getId());
            DeclaredTipsDAO.getInstance().saveOrUpdate(declaredTips);
            this.tableModel.addItem(declaredTips);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MessageDialog.0"), e);
        }
    }

    public void initData() {
        this.table.getSelectionModel().setSelectionMode(0);
        this.tableModel = new DeclaredTipsTableModel();
        this.table.setModel((TableModel)this.tableModel);
        AbstractAction declareTipsAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                DeclaredTips declareTips = (DeclaredTips)TipsDeclarationDialog.this.tableModel.getRowData(row);
                TipsDeclarationDialog.this.doDeclareTips(declareTips);
            }
        };
        this.addButtonColumnAction(declareTipsAction, 2);
        this.resizeTableColumns();
    }

    private void addButtonColumnAction(AbstractAction action, int columnNum) {
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.table, action, columnNum){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table, value, false, hasFocus, row, column);
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        MatteBorder selectedBorder = BorderFactory.createMatteBorder(3, 3, 3, 3, this.table.getBackground());
        MatteBorder unselectedBorder = BorderFactory.createMatteBorder(3, 3, 3, 3, this.table.getBackground());
        CompoundBorder border1 = new CompoundBorder(selectedBorder, this.btnCancel.getBorder());
        CompoundBorder border2 = new CompoundBorder(unselectedBorder, this.btnCancel.getBorder());
        buttonColumn.setUnselectedBorder(border1);
        buttonColumn.setFocusBorder(border2);
    }

    protected void doDeclareTips(DeclaredTips declaredTips) {
        try {
            double declareTips = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TipsDeclarationDialog.6"), declaredTips.getAmount());
            if (declareTips < 0.0) {
                return;
            }
            declaredTips.setAmount(declareTips);
            declaredTips.setDeclaredTime(new Date());
            DeclaredTipsDAO.getInstance().saveOrUpdate(declaredTips);
            this.tableModel.fireTableDataChanged();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MessageDialog.0"), e);
        }
    }

    private void resizeTableColumns() {
        this.table.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(100));
        this.setColumnWidth(2, PosUIManager.getSize(90));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.table.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    public void setInfo(String info) {
        this.titlePanel.setTitle(info);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setCanceled(false);
        this.dispose();
    }

    public boolean hasOpenTickets() {
        return this.tableModel.getRowCount() > 0;
    }

    class DeclaredTipsTableModel
    extends PaginatedTableModel {
        public DeclaredTipsTableModel() {
            super(new String[]{Messages.getString("TipsDeclarationDialog.0"), Messages.getString("TipsDeclarationDialog.8"), ""});
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2;
        }

        public DeclaredTips getSelectedRow() {
            int index = TipsDeclarationDialog.this.table.getSelectedRow();
            if (index < 0) {
                return null;
            }
            index = TipsDeclarationDialog.this.table.convertRowIndexToModel(index);
            return (DeclaredTips)TipsDeclarationDialog.this.tableModel.getRowData(index);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            List rows = this.getRows();
            if (rows == null) {
                return null;
            }
            DeclaredTips t = (DeclaredTips)rows.get(rowIndex);
            if (t == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    Date transactionTime = t.getDeclaredTime();
                    if (transactionTime == null) {
                        return "";
                    }
                    return DateUtil.formatFullDateAndTimeAsString(transactionTime);
                }
                case 1: {
                    return t.getAmount();
                }
                case 2: {
                    return Messages.getString("EDIT");
                }
            }
            return "";
        }
    }
}

