/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class VoidTicketDialog
extends OkCancelOptionDialog
implements RefreshableView {
    private PosOverflowCombobox cbVoidReasons;
    private POSToggleButton btnItemWasted;
    private List<Ticket> tickets;

    public VoidTicketDialog() {
        this(POSUtil.getFocusedWindow(), (List<Ticket>)null);
    }

    public VoidTicketDialog(Window window, List<Ticket> tickets) {
        super(window, "");
        this.tickets = tickets;
        this.initComponents();
        this.initialize();
        this.setDefaultCloseOperation(0);
    }

    public void setTickets(List<Ticket> tickets) {
        this.tickets = tickets;
    }

    private void initComponents() {
        this.setCaption(Messages.getString("SELECT_VOID_REASON"));
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setDefaultCloseOperation(2);
        Font font2 = new Font("Tahoma", 1, PosUIManager.getFontSize(16));
        JLabel lblReason = new JLabel();
        this.btnItemWasted = new POSToggleButton(POSConstants.ITEMS_WASTED);
        lblReason.setText(Messages.getString("LBL_VOID_REASON"));
        Dimension size = PosUIManager.getSize(100, 35);
        this.cbVoidReasons = new PosOverflowCombobox();
        this.cbVoidReasons.setPreferredSize(size);
        this.cbVoidReasons.setFont(font2);
        PosButton btnNewVoidReason = new PosButton();
        btnNewVoidReason.setText("+");
        btnNewVoidReason.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoidTicketDialog.this.doAddNewVoidReason();
            }
        });
        JPanel inputPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 2 5,hidemode 3", "[grow]", "[][][grow]"));
        inputPanel.add((Component)lblReason, "grow,wrap");
        inputPanel.add((Component)this.cbVoidReasons, "growy,split 3 ,w 200!");
        inputPanel.add((Component)btnNewVoidReason, "growy");
        inputPanel.add((Component)this.btnItemWasted, "h 50!,growy,wrap");
        this.getContentPanel().add(inputPanel);
    }

    public void initialize() {
        try {
            VoidReasonDAO dao = new VoidReasonDAO();
            List<VoidReason> voidReasons = dao.findAll();
            this.cbVoidReasons.setModel(new ListComboBoxModel(voidReasons));
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.CANNOT_LOAD_VOID_REASONS, e);
        }
    }

    private void doAddNewVoidReason() {
        try {
            NotesDialog dialog = new NotesDialog();
            dialog.setTitle(POSConstants.ENTER_VOID_REASON);
            dialog.pack();
            dialog.open();
            if (!dialog.isCanceled()) {
                String newVoidReason = dialog.getNote();
                VoidReason voidReason = new VoidReason();
                voidReason.setReasonText(newVoidReason);
                VoidReasonDAO dao = new VoidReasonDAO();
                dao.save(voidReason);
                if (this.cbVoidReasons.getModel() instanceof ListComboBoxModel) {
                    ListComboBoxModel model = (ListComboBoxModel)this.cbVoidReasons.getModel();
                    model.addElement(voidReason);
                    this.cbVoidReasons.setSelectedItem(voidReason);
                }
            }
        }
        catch (Throwable e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private boolean isAnyTicketVoided() {
        if (this.tickets != null) {
            for (Ticket ticket : this.tickets) {
                if (!ticket.isVoided().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAnyTicketPaid() {
        if (this.tickets != null) {
            for (Ticket ticket : this.tickets) {
                if (!(ticket.getPaidAmount() > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAnyTicketRefund() {
        if (this.tickets != null) {
            for (Ticket ticket : this.tickets) {
                if (!(ticket.getRefundAmount() > 0.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void doOk() {
        try {
            if (this.isAnyTicketVoided()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("VoidTicketDialog.1"));
                this.canceled = false;
                this.dispose();
                return;
            }
            if (this.isAnyTicketPaid()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("VoidTicketDialog.2"));
                return;
            }
            if (this.isAnyTicketRefund()) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("VoidTicketDialog.2"));
                return;
            }
            VoidReason voidReason = (VoidReason)this.cbVoidReasons.getSelectedItem();
            String voidReasionText = "";
            if (voidReason != null) {
                voidReasionText = voidReason.getReasonText();
            }
            for (Ticket ticket : this.tickets) {
                ticket.setVoidReason(voidReasionText);
                ticket.setWasted(this.btnItemWasted.isSelected());
                PosTransactionService.getInstance().voidTicket(ticket, Application.getCurrentUser());
            }
            this.canceled = false;
            this.dispose();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    @Override
    public void refresh() {
        if (this.tickets != null) {
            for (Ticket ticket : this.tickets) {
                Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            }
        }
    }

    public void setTicket(Ticket ticket) {
        this.tickets = Arrays.asList(ticket);
    }
}

