/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class WeightSelectionDialog
extends POSDialog
implements ActionListener {
    private static final String EMPTY_SPACE = " ";
    private int defaultValue;
    private TitlePanel titlePanel;
    private JTextField tfNumber;
    private boolean floatingPoint;
    private PosButton btnCancel;
    private boolean clearPreviousNumber = true;
    private JComboBox cbUnits;
    private InventoryUnit selectedUnit;
    private InventoryUnit sourceUnit;

    public WeightSelectionDialog() {
        this.init();
        this.cbUnits.setVisible(false);
    }

    public WeightSelectionDialog(Frame parent) {
        super(parent, true);
        this.init();
        this.cbUnits.setVisible(false);
    }

    public WeightSelectionDialog(MenuItem menuItem) {
        this.init();
        ArrayList<InventoryUnit> units = new ArrayList<InventoryUnit>();
        if (menuItem.getUnit() != null) {
            List<InventoryUnit> items = InventoryUnitDAO.getInstance().findByGroupId(menuItem.getUnit().getUnitGroupId());
            units.addAll(items);
        }
        this.cbUnits.setModel(new ComboBoxModel(units));
    }

    public WeightSelectionDialog(InventoryUnit inventoryUnit, String unitCode, MenuItem menuItem) {
        ArrayList units = new ArrayList();
        if (menuItem.getUnit() != null) {
            List<InventoryUnit> items = InventoryUnitDAO.getInstance().findByGroupId(menuItem.getUnit().getUnitGroupId());
            items.forEach(item -> {
                if (item.getCode().equals(unitCode)) {
                    this.sourceUnit = item;
                } else {
                    units.add(item);
                }
            });
        }
        this.init();
        this.cbUnits.setModel(new ComboBoxModel(units));
        this.selectedUnit = inventoryUnit;
    }

    private void init() {
        this.setResizable(false);
        Container contentPane = this.getContentPane();
        MigLayout layout = new MigLayout("fill,hidemode 3", "", "");
        contentPane.setLayout((LayoutManager)layout);
        this.titlePanel = new TitlePanel();
        contentPane.add((Component)this.titlePanel, "newline,height 60");
        this.tfNumber = new JTextField();
        this.tfNumber.setText(String.valueOf(this.defaultValue));
        this.tfNumber.setFont(this.tfNumber.getFont().deriveFont(1, 24.0f));
        this.tfNumber.setFocusable(true);
        this.tfNumber.requestFocus();
        this.tfNumber.setBackground(Color.WHITE);
        this.cbUnits = new JComboBox();
        contentPane.add((Component)this.tfNumber, "gapleft 5,newline,split 3,gapright 5, grow");
        contentPane.add((Component)new JLabel((this.sourceUnit != null ? this.sourceUnit.getName() : "") + EMPTY_SPACE + "<=>" + EMPTY_SPACE + Messages.getString("WeightSelectionDialog.3")), "gapleft 5, gapright 5");
        contentPane.add((Component)this.cbUnits, "gapright 5,grow");
        JPanel buttonsPanel = new JPanel((LayoutManager)new MigLayout("fill", "sg,fill", ""));
        String[][] numbers = new String[][]{{"7", "8", "9"}, {"4", "5", "6"}, {"1", "2", "3"}, {".", "0", POSConstants.CLEAR_ALL}};
        Font buttonFont = UIManager.getFont("Button.font").deriveFont((float)PosUIManager.getFontSize(32));
        for (int i = 0; i < numbers.length; ++i) {
            for (int j = 0; j < numbers[i].length; ++j) {
                PosButton posButton = new PosButton();
                posButton.setFocusable(false);
                String buttonText = String.valueOf(numbers[i][j]);
                posButton.setText(buttonText);
                if (!POSConstants.CLEAR_ALL.equals(buttonText)) {
                    posButton.setFont(buttonFont);
                }
                posButton.setActionCommand(buttonText);
                posButton.addActionListener(this);
                String constraints = "grow,height 55";
                if (j == numbers[i].length - 1) {
                    constraints = constraints + ",wrap";
                }
                buttonsPanel.add((Component)posButton, constraints);
            }
        }
        contentPane.add((Component)buttonsPanel, "newline,grow");
        contentPane.add((Component)new JSeparator(), "newline,grow,gaptop 5");
        PosButton btnOk = new PosButton(POSConstants.OK);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        this.btnCancel = new PosButton(POSConstants.CANCEL);
        this.btnCancel.setFocusable(false);
        this.btnCancel.addActionListener(this);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center center", "fill,sg", ""));
        buttonPanel.add((Component)btnOk, "w 100!");
        buttonPanel.add(this.btnCancel);
        contentPane.add((Component)buttonPanel, "newline,grow");
    }

    private void doOk() {
        if (!this.validate(this.tfNumber.getText())) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        InventoryUnit inventoryUnit = (InventoryUnit)this.cbUnits.getSelectedItem();
        if (inventoryUnit == null) {
            POSMessageDialog.showError(this, Messages.getString("MenuItemExplorerUnit"));
            return;
        }
        if (this.selectedUnit == null) {
            this.selectedUnit = new InventoryUnit();
        }
        this.selectedUnit.setId(inventoryUnit.getId());
        this.selectedUnit.setVersion(inventoryUnit.getVersion());
        this.selectedUnit.setLastUpdateTime(inventoryUnit.getLastUpdateTime());
        this.selectedUnit.setLastSyncTime(inventoryUnit.getLastSyncTime());
        this.selectedUnit.setCode(inventoryUnit.getCode());
        this.selectedUnit.setName(inventoryUnit.getName());
        this.selectedUnit.setBaseUnit(inventoryUnit.isBaseUnit());
        this.selectedUnit.setConversionRate(inventoryUnit.getConversionRate());
        this.selectedUnit.setUnitGroupId(inventoryUnit.getUnitGroupId());
        this.selectedUnit.setProperties(inventoryUnit.getProperties());
        this.selectedUnit.setDeleted(inventoryUnit.isDeleted());
        this.setCanceled(false);
        this.dispose();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    private void doClearAll() {
        this.tfNumber.setText(String.valueOf(this.defaultValue));
    }

    private void doInsertNumber(String number) {
        if (this.clearPreviousNumber) {
            this.tfNumber.setText("0");
            this.clearPreviousNumber = false;
        }
        String s = this.tfNumber.getText();
        double d = 0.0;
        try {
            d = Double.parseDouble(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (d == 0.0 && !s.contains(".")) {
            this.tfNumber.setText(number);
            return;
        }
        if (!this.validate(s = s + number)) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        this.tfNumber.setText(s);
    }

    private void doInsertDot() {
        String string = this.tfNumber.getText() + ".";
        if (!this.validate(string)) {
            POSMessageDialog.showError(this, POSConstants.INVALID_NUMBER);
            return;
        }
        this.tfNumber.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        } else if (actionCommand.equals(POSConstants.CLEAR_ALL)) {
            this.doClearAll();
        } else if (actionCommand.equals(".")) {
            this.doInsertDot();
        } else {
            this.doInsertNumber(actionCommand);
        }
    }

    private boolean validate(String str) {
        if (this.isFloatingPoint()) {
            try {
                Double.parseDouble(str);
            }
            catch (Exception x) {
                return false;
            }
        }
        try {
            Integer.parseInt(str);
        }
        catch (Exception x) {
            return false;
        }
        return true;
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
        super.setTitle(title);
    }

    public void setDialogTitle(String title) {
        super.setTitle(title);
    }

    public double getValue() {
        try {
            return Double.valueOf(NumberUtil.trimDecilamIfNotNeeded(Double.valueOf(this.tfNumber.getText()), true));
        }
        catch (NumberFormatException e) {
            PosLog.error(this.getClass(), e.getMessage());
            return this.defaultValue;
        }
    }

    public void setValue(double value) {
        if (value == 0.0) {
            this.tfNumber.setText("0");
        } else {
            this.tfNumber.setText(NumberUtil.trimDecilamIfNotNeeded(value, true));
        }
    }

    public boolean isFloatingPoint() {
        return this.floatingPoint;
    }

    public void setFloatingPoint(boolean decimalAllowed) {
        this.floatingPoint = decimalAllowed;
    }

    public static void main(String[] args) {
        WeightSelectionDialog dialog2 = new WeightSelectionDialog();
        dialog2.pack();
        dialog2.setVisible(true);
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(int defaultValue) {
        this.defaultValue = defaultValue;
        this.tfNumber.setText(String.valueOf(defaultValue));
    }

    public static int takeIntInput(String title) {
        WeightSelectionDialog dialog = new WeightSelectionDialog();
        dialog.setTitle(title);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return -1;
        }
        return (int)dialog.getValue();
    }

    public static double takeDoubleInput(String title, String dialogTitle, double initialAmount) {
        WeightSelectionDialog dialog = new WeightSelectionDialog();
        dialog.setFloatingPoint(true);
        dialog.setValue(initialAmount);
        dialog.setTitle(title);
        dialog.setDialogTitle(dialogTitle);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return Double.NaN;
        }
        return dialog.getValue();
    }

    public static double takeDoubleInput(String title, double initialAmount) {
        WeightSelectionDialog dialog = new WeightSelectionDialog();
        dialog.setFloatingPoint(true);
        dialog.setTitle(title);
        dialog.setValue(initialAmount);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return -1.0;
        }
        return dialog.getValue();
    }

    public static double takeDoubleInput(String title, double initialAmount, MenuItem menuItem) {
        WeightSelectionDialog dialog = new WeightSelectionDialog(menuItem);
        dialog.setFloatingPoint(true);
        dialog.setTitle(title);
        dialog.setValue(initialAmount);
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return -1.0;
        }
        return dialog.getValue();
    }

    public static double show(Component parent, String title, double initialAmount) {
        WeightSelectionDialog dialog2 = new WeightSelectionDialog();
        dialog2.setFloatingPoint(true);
        dialog2.setTitle(title);
        dialog2.pack();
        dialog2.setLocationRelativeTo(parent);
        dialog2.setValue(initialAmount);
        dialog2.setVisible(true);
        if (dialog2.isCanceled()) {
            return Double.NaN;
        }
        return dialog2.getValue();
    }

    public InventoryUnit getSelectedUnit() {
        return this.selectedUnit;
    }
}

