/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.SystemProperties;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CopyUtil;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.TitledSeparator;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class SeatSelectionDialog
extends POSDialog
implements ActionListener {
    private TitlePanel titlePanel;
    private ShopSeat selectedSeat;
    private JLayeredPane tableLayeredPane = new JLayeredPane();
    private SeatMemberInfoView memberInfoPanel;
    private List<ShopTable> tables;
    private ShopTable selectedTable;
    private ButtonGroup seatButtonGroup = new ButtonGroup();
    private Map<Integer, TableButton> tableMap = new HashMap<Integer, TableButton>();
    private Map<ShopSeat, SeatButton> seatButtonMap = new HashMap<ShopSeat, SeatButton>();
    private Map<ShopSeat, SeatButton> miscSeatButtonMap = new HashMap<ShopSeat, SeatButton>();
    private Map<ShopSeat, TicketItemSeat> ticketItemSeatMap = new HashMap<ShopSeat, TicketItemSeat>();
    private PosButton btnDone;
    private PosButton btnShared;
    private TicketItemSeat oldTicketItemSeat;
    private Ticket ticket;
    private TicketItemSeat originalTicketItemSeat;
    private boolean editMode;
    private boolean seatCustomerEnabled = SystemProperties.isSeatCustomerEnable();
    private PosButton btnAddSeat;
    private POSToggleButton btnDeleteSeat;
    private JPanel miscSeatPanel;
    private JPanel miscSeatPanelContainer;

    public SeatSelectionDialog(Ticket ticket) {
        this.ticket = ticket;
        this.editMode = false;
        this.initData();
        this.init();
        this.renderTable(this.tables.get(0));
        TableButton tableButton = this.tableMap.get(this.tables.get(0).getId());
        if (tableButton != null) {
            tableButton.setSelected(true);
        }
    }

    public SeatSelectionDialog(Ticket ticket, TicketItemSeat seat) {
        this.ticket = ticket;
        this.editMode = true;
        this.initData();
        this.init();
        this.btnDone.setVisible(true);
        this.renderTable(this.tables.get(0));
        TableButton tableButton = this.tableMap.get(this.tables.get(0).getId());
        if (tableButton != null) {
            tableButton.setSelected(true);
        }
        try {
            this.originalTicketItemSeat = seat;
            this.oldTicketItemSeat = (TicketItemSeat)CopyUtil.deepCopy(seat);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        if (seat != null) {
            SeatButton button = this.seatButtonMap.get(seat.getShopSeat());
            if (button == null) {
                ShopSeat shopSeat = seat.getShopSeat();
                if (shopSeat == null) {
                    shopSeat = this.getShopSeatFromTicketItemSeat(seat, this.ticket.getExtraSeats());
                }
                button = this.miscSeatButtonMap.get(shopSeat);
            }
            if (button != null) {
                this.selectedSeat = button.getSeat();
                this.selectedSeat.setMember(seat.getMember());
                tableButton = this.tableMap.get(this.selectedSeat.getTableId());
                if (tableButton != null) {
                    tableButton.setSelected(true);
                    if (this.selectedSeat.getTableId() != null) {
                        this.renderTable(this.selectedSeat.getShopTable());
                    }
                } else {
                    this.updateSelectionColor();
                }
                this.memberInfoPanel.rendererMemberInfo(this.selectedSeat);
            }
        } else {
            this.btnShared.setSelected(true);
            this.btnShared.setBackground(Color.red);
            tableButton = this.tableMap.get(this.tables.get(0).getId());
            if (tableButton != null) {
                tableButton.setSelected(true);
            }
            this.renderTable(this.tables.get(0));
            this.memberInfoPanel.rendererMemberInfo(this.selectedSeat);
        }
    }

    private void initData() {
        this.tables = this.ticket.getTables();
        List<TicketItem> ticketItems = this.ticket.getTicketItems();
        for (ShopTable table : this.tables) {
            Set<ShopSeat> seats = table.getSeats();
            if (seats == null) continue;
            for (ShopSeat shopSeat2 : seats) {
                shopSeat2.setMember(null);
                SeatButton button = new SeatButton(shopSeat2);
                this.seatButtonMap.put(shopSeat2, button);
            }
        }
        List<ShopSeat> extraSeats = this.ticket.getExtraSeats();
        if (!extraSeats.isEmpty()) {
            extraSeats.forEach(shopSeat -> {
                SeatButton button = new SeatButton((ShopSeat)shopSeat);
                this.miscSeatButtonMap.put((ShopSeat)shopSeat, button);
            });
        }
        if (ticketItems != null) {
            for (TicketItem ticketItem : ticketItems) {
                TicketItemSeat ticketItemSeat;
                if (!ticketItem.isTreatAsSeat().booleanValue() || (ticketItemSeat = ticketItem.getSeat()) == null) continue;
                ShopSeat ticketItemShopSeat = ticketItemSeat.getShopSeat();
                if (ticketItemShopSeat == null) {
                    ticketItemShopSeat = this.getShopSeatFromTicketItemSeat(ticketItemSeat, extraSeats);
                }
                if (ticketItemShopSeat == null) continue;
                this.ticketItemSeatMap.put(ticketItemShopSeat, ticketItemSeat);
                SeatButton seatButton = this.seatButtonMap.get(ticketItemShopSeat);
                if (seatButton != null) {
                    seatButton.getSeat().setMember(ticketItemSeat.getMember());
                }
                if ((seatButton = this.miscSeatButtonMap.get(ticketItemShopSeat)) == null) continue;
                seatButton.getSeat().setMember(ticketItemSeat.getMember());
            }
        }
    }

    private ShopSeat getShopSeatFromTicketItemSeat(TicketItemSeat ticketItemSeat, List<ShopSeat> shopSeats) {
        if (ticketItemSeat == null) {
            return null;
        }
        List list = shopSeats.stream().filter(seat -> seat.getId().equals(ticketItemSeat.getSeatId())).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (ShopSeat)list.get(0);
    }

    private void init() {
        this.setResizable(true);
        this.setLayout(new BorderLayout());
        this.titlePanel = new TitlePanel();
        this.add((Component)this.titlePanel, "North");
        JPanel southPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        this.btnAddSeat = new PosButton(Messages.getString("SeatSelectionDialog.4"));
        this.btnAddSeat.setActionCommand("Add seat");
        this.btnAddSeat.addActionListener(this);
        this.btnDeleteSeat = new POSToggleButton(Messages.getString("SeatSelectionDialog.8"));
        this.btnDeleteSeat.setActionCommand("Delete seat");
        this.btnShared = new PosButton(Messages.getString("SeatSelectionDialog.2"));
        this.btnShared.setActionCommand("Shared");
        this.btnShared.addActionListener(this);
        this.btnDone = new PosButton(Messages.getString("SeatSelectionDialog.1"));
        this.btnDone.setFocusable(false);
        this.btnDone.setVisible(false);
        this.btnDone.addActionListener(this);
        buttonPanel.add(this.btnDone);
        PosButton btnCancel = new PosButton(POSConstants.OK);
        btnCancel.setActionCommand("Cancel");
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        buttonPanel.add(btnCancel);
        southPanel.add((Component)new JSeparator(0), "North");
        southPanel.add((Component)buttonPanel, "South");
        this.add((Component)southPanel, "South");
        this.createLayoutPanel();
    }

    private void createLayoutPanel() {
        this.tableLayeredPane.setPreferredSize(new Dimension(400, 390));
        JPanel tableInfoPanel = new JPanel(new BorderLayout());
        tableInfoPanel.add(this.tableLayeredPane);
        tableInfoPanel.setPreferredSize(PosUIManager.getSize(400, 390));
        JPanel tablePanel = this.initShopTables();
        this.memberInfoPanel = new SeatMemberInfoView(this.ticket);
        this.memberInfoPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("SeatSelectionDialog.7")));
        int vsbPolicy = 20;
        int hsbPolicy = 30;
        PosScrollPane tablePanelContainerPane = new PosScrollPane(tableInfoPanel, vsbPolicy, hsbPolicy);
        tablePanelContainerPane.getHorizontalScrollBar().setPreferredSize(PosUIManager.getSize(40, 40));
        tablePanelContainerPane.setAutoscrolls(true);
        tablePanelContainerPane.setBorder(null);
        this.miscSeatPanel = new JPanel((LayoutManager)new MigLayout());
        HorizontalSimpleScrollPane miscSeatPanelContainerPane = new HorizontalSimpleScrollPane(this.miscSeatPanel);
        TitledSeparator miscSeatPanelSeperator = new TitledSeparator(Messages.getString("SeatSelectionDialog.12"), 2);
        this.miscSeatPanelContainer = new JPanel(new BorderLayout());
        this.miscSeatPanelContainer.add((Component)miscSeatPanelSeperator, "North");
        this.miscSeatPanelContainer.add((Component)((Object)miscSeatPanelContainerPane), "South");
        this.miscSeatPanelContainer.setVisible(Boolean.FALSE);
        TitledBorder insideBorder = BorderFactory.createTitledBorder(Messages.getString("SeatSelectionDialog.3"));
        CompoundBorder rightPanelBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 6, 10), insideBorder);
        JPanel tableAndSeatContainerPanel = new JPanel(new BorderLayout());
        tableAndSeatContainerPanel.add((Component)tablePanelContainerPane, "Center");
        tableAndSeatContainerPanel.add((Component)this.miscSeatPanelContainer, "South");
        tableAndSeatContainerPanel.setBorder(rightPanelBorder);
        this.add((Component)tableAndSeatContainerPanel, "Center");
        JPanel tableAndMemberInfoPanelContainer = new JPanel((LayoutManager)new MigLayout("fill"));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.tables != null && this.tables.size() > 1) {
            PosScrollPane tablePanelContainerScrollPane = new PosScrollPane(tablePanel, vsbPolicy, 31);
            tablePanelContainerScrollPane.setBorder(BorderFactory.createTitledBorder(Messages.getString("SeatSelectionDialog.9")));
            tablePanelContainerScrollPane.setPreferredSize(PosUIManager.getSize(300, (int)screenSize.getHeight()));
            tableAndMemberInfoPanelContainer.add((Component)tablePanelContainerScrollPane, "grow");
        }
        this.add((Component)tableAndMemberInfoPanelContainer, "West");
    }

    private JPanel initShopTables() {
        JPanel tablePanel = new JPanel(new WrapLayout());
        if (this.tables != null && this.tables.size() > 0) {
            ButtonGroup group = new ButtonGroup();
            for (ShopTable table : this.tables) {
                TableButton shopTableButton = new TableButton(table);
                shopTableButton.setPreferredSize(new Dimension(90, 70));
                shopTableButton.setForeground(new Color(76, 52, 47));
                shopTableButton.setBackground(new Color(147, 187, 70));
                group.add(shopTableButton);
                tablePanel.add(shopTableButton);
                this.tableMap.put(table.getId(), shopTableButton);
            }
        }
        return tablePanel;
    }

    private void renderTable(ShopTable table) {
        this.tableLayeredPane.removeAll();
        if (table == null) {
            return;
        }
        this.selectedTable = table;
        ShopTableButton tableButton = new ShopTableButton(this.tableLayeredPane, table);
        tableButton.drawShape(table.getStateTableType());
        this.tableLayeredPane.add((Component)tableButton, Float.valueOf(0.5f));
        this.seatButtonGroup = new ButtonGroup();
        Set<ShopSeat> seats = table.getSeats();
        if (seats != null) {
            for (ShopSeat shopSeat : seats) {
                SeatButton button = new SeatButton(shopSeat);
                this.tableLayeredPane.add(button);
                this.seatButtonGroup.add(button);
                this.seatButtonMap.put(shopSeat, button);
            }
            if (this.ticket.getTicketItems() != null) {
                for (TicketItemSeat ticketItemSeat : this.ticketItemSeatMap.values()) {
                    SeatButton seatButton = this.seatButtonMap.get(ticketItemSeat.getShopSeat());
                    if (seatButton == null) continue;
                    seatButton.setBackground(Color.red);
                }
                this.updateSelectionColor();
            }
        }
        this.tableLayeredPane.moveToBack(tableButton);
        this.tableLayeredPane.revalidate();
        this.tableLayeredPane.repaint();
        this.renderMiscSeats(table);
    }

    private void updateSelectionColor() {
        if (this.selectedSeat != null) {
            SeatButton button = this.seatButtonMap.get(this.selectedSeat);
            if (button == null) {
                button = this.miscSeatButtonMap.get(this.selectedSeat);
            }
            if (button != null) {
                button.setSelected(true);
                button.setBackground(Color.green);
            }
        }
    }

    private void updateMember() {
        if (this.ticket.getTicketItems() != null) {
            Set<ShopSeat> keySet = this.seatButtonMap.keySet();
            for (ShopSeat shopSeat : keySet) {
                TicketItemSeat ticketItemSeat = this.ticketItemSeatMap.get(shopSeat);
                if (ticketItemSeat == null) continue;
                ticketItemSeat.setMember(shopSeat.getMember());
            }
            if (this.selectedSeat != null) {
                SeatSelectionDialog.setCustomerForShopSeat(this.ticket, this.selectedSeat, this.selectedSeat.getMember());
            }
        }
        if (this.oldTicketItemSeat != null && this.oldTicketItemSeat.getSeatId().intern() != this.selectedSeat.getId().intern()) {
            this.oldTicketItemSeat.setMember(null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.btnDeleteSeat.setSelected(Boolean.FALSE);
        String actionCommand = e.getActionCommand();
        if ("Shared".equalsIgnoreCase(actionCommand)) {
            this.selectedSeat = null;
        } else {
            if ("Cancel".equalsIgnoreCase(actionCommand)) {
                this.setCanceled(true);
                this.dispose();
                return;
            }
            if ("Add seat".equalsIgnoreCase(actionCommand)) {
                this.insertMiscSeat(this.selectedTable);
                return;
            }
            this.updateMember();
        }
        this.doFinish();
    }

    private void renderMiscSeats(ShopTable table) {
        this.miscSeatPanel.removeAll();
        if (table == null) {
            return;
        }
        List<ShopSeat> extraSeats = this.ticket.getExtraSeats();
        if (extraSeats.isEmpty()) {
            return;
        }
        for (ShopSeat shopSeat : extraSeats) {
            SeatButton button = this.miscSeatButtonMap.get(shopSeat);
            if (button == null) {
                button = new SeatButton(shopSeat);
            }
            if (this.ticketItemSeatMap.containsKey(shopSeat)) {
                shopSeat.setMember(button.getSeat().getMember());
                button.setBackground(Color.red);
            }
            button.updateSeatInfo(shopSeat);
            button.setPreferredSize(PosUIManager.getSize(80, 80));
            this.miscSeatPanel.add(button);
        }
        this.miscSeatPanelContainer.setVisible(Boolean.TRUE);
        this.miscSeatPanel.revalidate();
        this.miscSeatPanel.repaint();
    }

    private void insertMiscSeat(ShopTable table) {
        try {
            if (table == null) {
                return;
            }
            int seatNumber = (int)NumberSelectionDialog2.takeIntInput(Messages.getString("SeatSelectionDialog.14"));
            if (seatNumber <= 0) {
                POSMessageDialog.showError(Messages.getString("SeatSelectionDialog.6"));
                return;
            }
            List<ShopSeat> extraSeats = this.ticket.getExtraSeats();
            if (!this.isExtraSeatNumberAvailable(extraSeats, seatNumber)) {
                POSMessageDialog.showError(Messages.getString("SeatSelectionDialog.13"));
                return;
            }
            ShopSeat shopSeat = new ShopSeat();
            shopSeat.setId(GlobalIdGenerator.generateGlobalId());
            shopSeat.setSeatNumber(seatNumber);
            extraSeats.add(shopSeat);
            this.ticket.addExtraSeats(extraSeats);
            SeatButton button = new SeatButton(shopSeat);
            button.setPreferredSize(PosUIManager.getSize(80, 80));
            this.miscSeatButtonMap.put(shopSeat, button);
            this.miscSeatPanel.add(button);
            this.miscSeatPanelContainer.setVisible(Boolean.TRUE);
            if (this.miscSeatPanel.getComponentCount() > 1) {
                this.miscSeatPanel.revalidate();
                this.miscSeatPanel.repaint();
            } else {
                this.revalidate();
                this.repaint();
            }
        }
        catch (PosException e2) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), e2.getMessage());
        }
        catch (Exception e2) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), e2.getMessage(), e2);
        }
    }

    private boolean isExtraSeatNumberAvailable(List<ShopSeat> extraSeats, Integer seatNumber) {
        List<ShopSeat> seats = this.ticket.getExtraSeats();
        if (seats == null || seats.isEmpty()) {
            return true;
        }
        for (ShopSeat shopSeat : seats) {
            if (!shopSeat.getSeatNumber().equals(seatNumber)) continue;
            return false;
        }
        return true;
    }

    private void doFinish() {
        if (this.originalTicketItemSeat != null) {
            try {
                PropertyUtils.copyProperties((Object)this.originalTicketItemSeat, (Object)this.oldTicketItemSeat);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
    }

    public void setDialogTitle(String title) {
        super.setTitle(title);
    }

    private Customer getCustomerForShopSeat(ShopSeat shopSeat) {
        List<TicketItem> ticketItems = this.ticket.getTicketItems();
        for (TicketItem ticketItem : ticketItems) {
            Customer member;
            TicketItemSeat ticketItemSeat;
            if (!ticketItem.isTreatAsSeat().booleanValue() || (ticketItemSeat = ticketItem.getSeat()) == null || !ticketItemSeat.getSeatId().equals(shopSeat.getId()) || (member = ticketItemSeat.getMember()) == null) continue;
            return member;
        }
        return null;
    }

    public static void setCustomerForShopSeat(Ticket ticket, ShopSeat shopSeat, Customer customer) {
        if (ticket == null) {
            return;
        }
        List<TicketItem> ticketItems = ticket.getTicketItems();
        for (TicketItem ticketItem : ticketItems) {
            TicketItemSeat ticketItemSeat;
            if (!ticketItem.isTreatAsSeat().booleanValue() || (ticketItemSeat = ticketItem.getSeat()) == null || !ticketItemSeat.getSeatId().equals(shopSeat.getId())) continue;
            ticketItemSeat.setMember(customer);
        }
    }

    public ShopSeat getSeat() {
        return this.selectedSeat;
    }

    public class ShopTableButton
    extends JLabel {
        private JLayeredPane parent;
        private ShopTable table;
        private int type;

        public ShopTableButton(JLayeredPane tablePanel, ShopTable table) {
            this.parent = tablePanel;
            this.table = table;
            this.setText(table.getId() + "");
            this.setBackground(Color.WHITE);
            Integer tableWidth = table.getWidth();
            Integer tableHeight = table.getHeight();
            if (tableWidth == null || tableWidth == 0) {
                tableWidth = TerminalConfig.getFloorButtonWidth();
            }
            if (tableHeight == null || tableHeight == 0) {
                tableHeight = TerminalConfig.getFloorButtonHeight();
            }
            int posX = this.parent.getPreferredSize().width / 2 - tableWidth / 2;
            int posY = this.parent.getPreferredSize().height / 2 - tableHeight / 2;
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
            this.setBounds(PosUIManager.getSize(posX), PosUIManager.getSize(posY), PosUIManager.getSize(tableWidth), PosUIManager.getSize(tableHeight));
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize() + 10));
        }

        public void drawShape(int type) {
            this.type = type;
            this.repaint();
        }

        @Override
        public void paintAll(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.getBackground());
            if (this.type == 2) {
                g2d.fillOval(10, 10, this.getSize().width - 20, this.getSize().height - 20);
            } else if (this.type == 1) {
                g2d.fillRoundRect(2, 2, this.getSize().width - 4, this.getSize().height - 4, 20, 20);
            } else if (this.type != 3) {
                g2d.fillRect(0, 0, this.getSize().width, this.getSize().height);
            }
        }

        @Override
        protected void paintBorder(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.getForeground());
            g2d.setStroke(new BasicStroke(6.0f));
            int w = this.getSize().width;
            int h = this.getSize().height;
            if (this.type == 2) {
                g2d.drawOval(10, 10, w - 20, h - 20);
            } else if (this.type == 1) {
                g2d.drawRoundRect(2, 2, w - 4, h - 4, 20, 20);
            } else if (this.type == 3) {
                int x = w / 2;
                int d = (int)Math.sqrt(w * w + w * w);
                int dX = d - w;
                int dY = d - w;
                g2d.rotate(Math.toRadians(45.0), x, 0.0);
                g2d.drawRoundRect(x + 2, 4, w - dX, w - dY, 20, 20);
            } else {
                g2d.drawRect(0, 0, w, h);
            }
        }

        public ShopTable getTable() {
            return this.table;
        }
    }

    class TableButton
    extends POSToggleButton
    implements ActionListener {
        ShopTable table;
        int pressedX;
        int pressedY;

        public TableButton(ShopTable table) {
            this.table = table;
            this.setText(table.getTableNumber() + "");
            this.setBounds(table.getX(), table.getY(), table.getWidth(), table.getHeight());
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize()));
            this.addActionListener(this);
        }

        public ShopTable getTable() {
            return this.table;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SeatSelectionDialog.this.renderTable(this.table);
        }
    }

    class SeatMemberInfoView
    extends JPanel {
        private JLabel lblMemberID;
        private JLabel tfMemberName;
        private JLabel lblMemberName;
        private JLabel lblPicture;
        private byte[] memberImageData;
        private JLabel lblMember;
        private JPanel centerPanel;
        private JPanel picturePanel;
        private Ticket ticket;
        private Customer selectedMember;
        private ShopSeat seat;
        private PosButton btnSelectMember;
        private PosButton btnClearSeat;

        public SeatMemberInfoView(Ticket ticket) {
            this.ticket = ticket;
            this.init();
            this.updateView();
        }

        private void init() {
            this.setLayout(new BorderLayout());
            this.centerPanel = new JPanel();
            this.centerPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3"));
            this.lblMemberID = new JLabel();
            this.tfMemberName = new JLabel();
            this.lblMemberName = new JLabel(Messages.getString("MemeberName"));
            this.lblMember = new JLabel(Messages.getString("MemberID"));
            Font newLabelFont = new Font(this.lblMemberID.getFont().getName(), 1, this.lblMemberID.getFont().getSize());
            this.lblMemberID.setFont(newLabelFont);
            this.tfMemberName.setFont(newLabelFont);
            this.centerPanel.add((Component)this.lblMember, "grow");
            this.centerPanel.add((Component)this.lblMemberID, "grow,h 25!,wrap");
            this.centerPanel.add((Component)this.lblMemberName, "grow");
            this.centerPanel.add((Component)this.tfMemberName, "grow,w 200!");
            this.btnClearSeat = new PosButton(Messages.getString("ClearSeatSelection"));
            this.btnClearSeat.addActionListener(e -> this.doClearSeat());
            this.createPicturePanel();
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.btnSelectMember);
            buttonPanel.add(this.btnClearSeat);
            this.add((Component)buttonPanel, "South");
            this.add(this.centerPanel);
        }

        private void doClearSeat() {
            if (SeatSelectionDialog.this.oldTicketItemSeat == null && SeatSelectionDialog.this.selectedSeat != null) {
                SeatButton seatButton = (SeatButton)SeatSelectionDialog.this.seatButtonMap.get(SeatSelectionDialog.this.selectedSeat);
                SeatSelectionDialog.this.selectedSeat.setMember(null);
                if (seatButton != null) {
                    seatButton.updateSeatInfo(SeatSelectionDialog.this.selectedSeat);
                    seatButton.setBackground(Color.WHITE);
                    seatButton.setSelected(false);
                }
                SeatSelectionDialog.this.memberInfoPanel.clearMemberInfo(false);
            }
            if (SeatSelectionDialog.this.oldTicketItemSeat == null) {
                SeatSelectionDialog.this.memberInfoPanel.clearMemberInfo(true);
                return;
            }
            if (SeatSelectionDialog.this.oldTicketItemSeat.getMember() == null) {
                SeatSelectionDialog.this.memberInfoPanel.clearMemberInfo(true);
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoNeedToClear"));
                return;
            }
            ShopSeat shopSeat = SeatSelectionDialog.this.oldTicketItemSeat.getShopSeat();
            SeatButton seatButton = (SeatButton)SeatSelectionDialog.this.seatButtonMap.get(shopSeat);
            SeatSelectionDialog.this.oldTicketItemSeat.setMember(null);
            SeatSelectionDialog.this.selectedSeat.setMember(null);
            shopSeat.setMember(null);
            if (seatButton != null) {
                seatButton.updateSeatInfo(shopSeat);
                seatButton.setBackground(Color.WHITE);
                seatButton.setSelected(false);
            }
            SeatSelectionDialog.this.memberInfoPanel.clearMemberInfo(true);
        }

        public void rendererMemberInfo(ShopSeat seat) {
            this.seat = seat;
            if (seat != null) {
                this.selectedMember = seat.getMember();
            }
            this.updateView();
        }

        private void createPicturePanel() {
            this.picturePanel = new JPanel((LayoutManager)new MigLayout());
            this.picturePanel.setBackground(Color.white);
            this.lblPicture = new JLabel("");
            this.lblPicture.setIconTextGap(0);
            this.lblPicture.setHorizontalAlignment(0);
            this.picturePanel.add((Component)this.lblPicture, "wrap,center");
            this.btnSelectMember = new PosButton(Messages.getString("SelectMember"));
            this.btnSelectMember.setFocusable(false);
            this.btnSelectMember.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(SeatMemberInfoView.this.ticket.getOrderType());
                    dialog.setCreateNewTicket(false);
                    if (SeatMemberInfoView.this.ticket != null) {
                        dialog.setTicket(SeatMemberInfoView.this.ticket);
                    }
                    dialog.openUndecoratedFullScreen();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    SeatMemberInfoView.this.selectedMember = dialog.getSelectedCustomer();
                    if (SeatMemberInfoView.this.seat != null) {
                        SeatMemberInfoView.this.seat.setMember(SeatMemberInfoView.this.selectedMember);
                    }
                    SeatMemberInfoView.this.updateView();
                }
            });
            this.centerPanel.add((Component)this.picturePanel, "skip 1,newline");
            this.setDefaultCustomerPicture();
        }

        private void updateMemberPicture(Customer member) {
            if (member != null) {
                ImageIcon image = IconFactory.getIconFromImageResource(member.getImageId(), 150, 150);
                if (image != null) {
                    this.lblPicture.setIcon(image);
                } else {
                    this.setDefaultCustomerPicture();
                }
            }
        }

        private void setDefaultCustomerPicture() {
            try {
                InputStream stream = this.getClass().getResourceAsStream("/images/generic-profile-pic-v2.png");
                this.memberImageData = IOUtils.toByteArray((InputStream)stream);
                IOUtils.closeQuietly((InputStream)stream);
                this.lblPicture.setIcon(new ImageIcon(this.memberImageData));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private void clearMemberInfo(boolean isClear) {
            if (isClear) {
                this.lblMemberID.setText("");
                this.tfMemberName.setText("");
            }
        }

        protected void updateView() {
            Customer customer;
            if (this.selectedMember != null) {
                this.lblMemberID.setText(this.selectedMember.getMemberId());
                this.tfMemberName.setText(this.selectedMember.getName());
                this.updateMemberPicture(this.selectedMember);
            } else if (!SeatSelectionDialog.this.editMode && (customer = this.ticket.getCustomer()) != null) {
                this.lblMemberID.setText(customer.getMemberId());
                this.tfMemberName.setText(customer.getName());
                this.updateMemberPicture(customer);
            }
        }

        public Customer getMember() {
            return this.selectedMember;
        }

        public String getCustomerName() {
            return this.tfMemberName.getText();
        }

        public void setMember(Customer member) {
            this.selectedMember = member;
            this.updateView();
        }

        public void disableMemberSelection() {
            this.btnSelectMember.setEnabled(false);
        }

        public void enableMemberSelection() {
            this.btnSelectMember.setEnabled(true);
        }
    }

    public class SeatButton
    extends PosButton
    implements ActionListener {
        ShopSeat seat;
        int pressedX;
        int pressedY;

        public SeatButton(ShopSeat seat) {
            this.setBounds(PosUIManager.getSize(seat.getPosX()), PosUIManager.getSize(seat.getPosY()), PosUIManager.getSize(70), PosUIManager.getSize(70));
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize()));
            this.updateSeatInfo(seat);
        }

        public void updateSeatInfo(ShopSeat seat) {
            this.seat = seat;
            Customer member = seat.getMember();
            String customerName = "";
            int nameFontSize = PosUIManager.getSize(2);
            if (member != null) {
                customerName = "<br><font size=\"" + nameFontSize + "\">" + member.getName() + "</font>";
            }
            if (SeatSelectionDialog.this.seatCustomerEnabled) {
                this.setText("<html><center>" + seat.getSeatNumber() + customerName + "</center></html>");
            } else {
                this.setText("<html><center>" + seat.getSeatNumber() + "</center></html>");
            }
        }

        public ShopSeat getSeat() {
            return this.seat;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<ShopSeat> extraSeats = SeatSelectionDialog.this.ticket.getExtraSeats();
            if (SeatSelectionDialog.this.btnDeleteSeat.isSelected()) {
                if (extraSeats.contains(this.seat)) {
                    Customer member = this.seat.getMember();
                    Color backgroundColor = this.getBackground();
                    if (member != null || backgroundColor == Color.red) {
                        this.setSelected(Boolean.FALSE);
                        String message = Messages.getString("SeatSelectionDialog.15");
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                        return;
                    }
                    SeatSelectionDialog.this.btnDeleteSeat.setSelected(Boolean.FALSE);
                    extraSeats.remove(this.seat);
                    SeatSelectionDialog.this.ticket.addExtraSeats(extraSeats);
                    SeatSelectionDialog.this.miscSeatPanel.remove(this);
                    if (SeatSelectionDialog.this.miscSeatPanel.getComponentCount() == 0) {
                        SeatSelectionDialog.this.miscSeatPanelContainer.setVisible(Boolean.FALSE);
                    }
                    SeatSelectionDialog.this.miscSeatPanel.revalidate();
                    SeatSelectionDialog.this.miscSeatPanel.repaint();
                } else {
                    SeatSelectionDialog.this.seatButtonGroup.clearSelection();
                    String message = Messages.getString("SeatSelectionDialog.16");
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                }
                return;
            }
            Customer member = null;
            SeatButton previousSelectedButton = null;
            if (SeatSelectionDialog.this.selectedSeat != null && (previousSelectedButton = (SeatButton)SeatSelectionDialog.this.seatButtonMap.get(SeatSelectionDialog.this.selectedSeat)) == null) {
                previousSelectedButton = (SeatButton)SeatSelectionDialog.this.miscSeatButtonMap.get(SeatSelectionDialog.this.selectedSeat);
            }
            SeatSelectionDialog.this.selectedSeat = this.seat;
            if (SeatSelectionDialog.this.oldTicketItemSeat == null) {
                Customer memberFromTicket = SeatSelectionDialog.this.selectedSeat.getMember();
                if (memberFromTicket == null) {
                    memberFromTicket = SeatSelectionDialog.this.getCustomerForShopSeat(SeatSelectionDialog.this.selectedSeat);
                }
                Customer memberFromRightPanel = SeatSelectionDialog.this.memberInfoPanel.getMember();
                if (memberFromTicket != null && memberFromRightPanel != null && !memberFromTicket.equals(memberFromRightPanel)) {
                    if (SeatSelectionDialog.this.selectedSeat.getMember() != null) {
                        this.displayWarningMsg(memberFromTicket, memberFromRightPanel);
                        return;
                    }
                    SeatSelectionDialog.this.selectedSeat.setMember(memberFromRightPanel);
                    SeatSelectionDialog.setCustomerForShopSeat(SeatSelectionDialog.this.ticket, SeatSelectionDialog.this.selectedSeat, memberFromRightPanel);
                } else if (memberFromRightPanel != null) {
                    SeatSelectionDialog.this.selectedSeat.setMember(memberFromRightPanel);
                    if (extraSeats.contains(SeatSelectionDialog.this.selectedSeat)) {
                        extraSeats.remove(SeatSelectionDialog.this.selectedSeat);
                        extraSeats.add(SeatSelectionDialog.this.selectedSeat);
                        SeatSelectionDialog.this.ticket.addExtraSeats(extraSeats);
                    }
                } else if (memberFromRightPanel == null && StringUtils.isNotBlank((String)SeatSelectionDialog.this.memberInfoPanel.getCustomerName())) {
                    SeatSelectionDialog.this.selectedSeat.setMember(SeatSelectionDialog.this.ticket.getCustomer());
                }
                SeatSelectionDialog.this.setCanceled(false);
                SeatSelectionDialog.this.dispose();
            } else if (SeatSelectionDialog.this.oldTicketItemSeat != null && SeatSelectionDialog.this.selectedSeat != null) {
                if (member == null) {
                    member = SeatSelectionDialog.this.getCustomerForShopSeat(SeatSelectionDialog.this.selectedSeat);
                }
                if (previousSelectedButton != null) {
                    if (SeatSelectionDialog.this.selectedSeat != null && SeatSelectionDialog.this.selectedSeat.getMember() != null) {
                        Customer memberFromRightPanel;
                        Customer memberFromTicket = SeatSelectionDialog.this.selectedSeat.getMember();
                        if (memberFromTicket.equals(memberFromRightPanel = SeatSelectionDialog.this.memberInfoPanel.getMember())) {
                            this.setSelected(false);
                            previousSelectedButton.setSelected(true);
                            SeatSelectionDialog.this.selectedSeat = previousSelectedButton.getSeat();
                            return;
                        }
                        this.displayWarningMsg(memberFromTicket, memberFromRightPanel);
                        this.setSelected(false);
                        previousSelectedButton.setSelected(true);
                        SeatSelectionDialog.this.selectedSeat = previousSelectedButton.getSeat();
                        return;
                    }
                    ShopSeat previousSeat = previousSelectedButton.getSeat();
                    previousSeat.setMember(null);
                    if (SeatSelectionDialog.this.oldTicketItemSeat != null) {
                        member = SeatSelectionDialog.this.oldTicketItemSeat.getMember();
                        SeatSelectionDialog.this.oldTicketItemSeat.setShopSeat(this.seat);
                    }
                    previousSelectedButton.updateSeatInfo(previousSeat);
                    previousSelectedButton.setBackground(Color.WHITE);
                    if (SeatSelectionDialog.this.seatButtonMap.containsValue(previousSelectedButton)) {
                        SeatSelectionDialog.this.seatButtonGroup.clearSelection();
                    } else {
                        previousSelectedButton.setSelected(Boolean.FALSE);
                    }
                }
                SeatSelectionDialog.this.selectedSeat.setMember(member);
                this.updateSeatInfo(SeatSelectionDialog.this.selectedSeat);
                SeatSelectionDialog.this.updateSelectionColor();
                SeatSelectionDialog.this.memberInfoPanel.rendererMemberInfo(SeatSelectionDialog.this.selectedSeat);
            } else {
                SeatSelectionDialog.this.memberInfoPanel.rendererMemberInfo(this.seat);
            }
        }

        private void displayWarningMsg(Customer memberFromTicket, Customer memberFromRightPanel) {
            if (memberFromTicket == null) {
                return;
            }
            if (memberFromRightPanel == null) {
                String message = Messages.getString("SeatSelectionDialog.100");
                String formattedMessage = String.format(message, SeatSelectionDialog.this.selectedSeat.getSeatNumber(), memberFromTicket.getName());
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), formattedMessage);
                return;
            }
            String message = Messages.getString("SeatSelectionDialog.10");
            String formattedMessage = String.format(message, SeatSelectionDialog.this.selectedSeat.getSeatNumber(), memberFromTicket.getName(), memberFromRightPanel.getName());
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), formattedMessage);
        }
    }
}

