/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ShopSeatForm
extends BeanEditor<ShopSeat> {
    private IntegerTextField tfSeatNumber;
    private JPanel centerPanel;
    private JLabel lblSeatNumber;
    private ShopSeat seat;
    private ShopTable table;

    public ShopSeatForm(ShopTable table) {
        this.table = table;
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout((LayoutManager)new MigLayout("fill"));
        this.tfSeatNumber = new IntegerTextField(0, 3);
        this.lblSeatNumber = new JLabel("Seat Number");
        this.centerPanel.add((Component)this.lblSeatNumber, "grow");
        this.centerPanel.add((Component)this.tfSeatNumber, "grow,w 200!");
        this.add(this.centerPanel);
    }

    public void setFieldsEditable(boolean editable) {
        this.tfSeatNumber.setEditable(editable);
    }

    @Override
    public void createNew() {
        this.setBean(new ShopSeat());
    }

    @Override
    public boolean delete() {
        try {
            ShopSeat seat = (ShopSeat)this.getBean();
            if (seat == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTabeTypeForm.2"), POSConstants.CONFIRM);
            if (option != 0) {
                return false;
            }
            this.table.getSeats().remove(seat);
            this.tfSeatNumber.setText("");
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfSeatNumber.setEnabled(enable);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            this.seat = (ShopSeat)this.getBean();
            this.table.addToseats(this.seat);
            return true;
        }
        catch (IllegalModelStateException illegalModelStateException) {
            return false;
        }
    }

    @Override
    protected void updateView() {
        ShopSeat tableType = (ShopSeat)this.getBean();
        if (tableType == null) {
            return;
        }
        this.tfSeatNumber.setText(String.valueOf(tableType.getSeatNumber()));
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Integer seatNumber;
        ShopSeat seat = (ShopSeat)this.getBean();
        if (seat == null) {
            seat = new ShopSeat();
            this.setBean(seat, false);
        }
        if ((seatNumber = Integer.valueOf(this.tfSeatNumber.getInteger())) == 0) {
            POSMessageDialog.showError(Messages.getString("ShopSeatForm.1"));
            return false;
        }
        if (!this.isSeatNumberAvailable(seatNumber)) {
            POSMessageDialog.showError(Messages.getString("ShopSeatForm.3"));
            return false;
        }
        seat.setSeatNumber(seatNumber);
        return true;
    }

    private boolean isSeatNumberAvailable(Integer seatNumber) {
        Set<ShopSeat> seats = null;
        if (this.table != null) {
            seats = this.table.getSeats();
        }
        if (seats == null || seats.isEmpty()) {
            return true;
        }
        for (ShopSeat shopSeat : seats) {
            if (shopSeat.equals(this.getBean()) || !shopSeat.getSeatNumber().equals(seatNumber)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("ShopSeatForm.0");
    }

    public ShopSeat getSeat() {
        return this.seat;
    }
}

