/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.CreditBook;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MemberType;
import com.floreantpos.model.dao.CreditBookDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ForeteesCustomerDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CreditBookForm;
import com.floreantpos.ui.views.payment.creditbook.CreditBookExplorer;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;
import org.hibernate.StaleObjectStateException;

public class CustomerForm
extends BeanEditor<Customer> {
    static MyOwnFocusTraversalPolicy newPolicy;
    private FixedLengthTextField tfLoyaltyNo;
    private JTextField tfAddress;
    private FixedLengthTextField tfCity;
    private FixedLengthTextField tfPostalCode;
    private FixedLengthTextField tfCountry;
    private DoubleTextField tfCreditLimit;
    private JCheckBox cbVip;
    private JCheckBox cbTaxExempt;
    private JCheckBox checkActive;
    private JCheckBox checkRestrictedFromPOS;
    private FixedLengthTextField tfFirstName;
    private FixedLengthTextField tfLastName;
    private FixedLengthTextField tfEmail;
    private FixedLengthTextField tfEmail2;
    private JLabel lblDob;
    private JLabel lblLoyaltyPoint;
    private IntegerTextField tfLoyaltyPoint;
    private JLabel lblPicture;
    private JPanel picturePanel;
    private PosSmallButton btnSelectImage;
    private PosSmallButton btnClearImage;
    private JComboBox cbSalutation;
    private JLabel lblHomePhone;
    private JLabel lblWorkPhone;
    private JLabel lblMobile;
    private FixedLengthTextField tfHomePhone;
    private FixedLengthTextField tfWorkPhone;
    private FixedLengthTextField tfMobile;
    private FixedLengthTextField tfSocialSecurityNumber;
    private QwertyKeyPad qwertyKeyPad;
    public boolean isKeypad;
    private ImageResource imageResource;
    private FixedLengthTextField tfState;
    private FixedLengthTextField tfMemberId;
    private JTextField tfStreet3;
    private JTextField tfStreet2;
    private JTextField tfStreet1;
    private JLabel lblBalance;
    private DoubleTextField tfBalance;
    private Image image;
    private CreditBookExplorer creditBookExplorer;
    private JComboBox<MemberType> cbMemberType;
    private FixedLengthTextField tfMemberShipType;
    private JComboBox<String> cbMonth;
    private JComboBox<String> cbDay;
    private JComboBox<String> cbYear;
    private JCheckBox checkRequireCashOrCredit;
    private PosSmallButton btnEdit;
    private PosSmallButton btnDelete;

    public CustomerForm() {
        this(false);
    }

    public CustomerForm(boolean enable) {
        this.isKeypad = enable;
        this.initComponents();
    }

    private void initComponents() {
        this.setOpaque(true);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(5, 20, 5, 20));
        this.creditBookExplorer = new CreditBookExplorer();
        JTabbedPane mainTabbedPanel = new JTabbedPane();
        mainTabbedPanel.addTab(Messages.getString("CustomerForm.13"), this.createCustomerForm());
        mainTabbedPanel.addTab(Messages.getString("CustomerForm.14"), this.creditBookExplorer);
        this.add(mainTabbedPanel);
        mainTabbedPanel.addChangeListener(e -> this.enableExtraButton(mainTabbedPanel.getSelectedIndex() == 1 ? Boolean.TRUE : Boolean.FALSE));
    }

    private void enableExtraButton(boolean visible) {
        this.btnEdit.setVisible(visible);
        this.btnDelete.setVisible(visible);
    }

    public void addExtraButton() {
        TransparentPanel buttonPanel = this.editorDialog.getButtonPanel();
        this.btnEdit = new PosSmallButton(POSConstants.EDIT);
        this.btnDelete = new PosSmallButton(POSConstants.DELETE);
        this.btnEdit.addActionListener(e -> this.doEditCreditBook());
        this.btnDelete.addActionListener(e -> this.doDeleteCreditBook());
        Component[] components = buttonPanel.getComponents();
        buttonPanel.removeAll();
        buttonPanel.add(this.btnEdit);
        buttonPanel.add(this.btnDelete);
        for (Component component : components) {
            buttonPanel.add(component);
        }
        this.enableExtraButton(false);
    }

    private void doDeleteCreditBook() {
        CreditBook selectedCreditBook = this.creditBookExplorer.getSelectedCreditBook();
        if (selectedCreditBook == null) {
            POSMessageDialog.showError(this, Messages.getString("SELECT_A_ROW"));
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.30"), POSConstants.CONFIRM);
        if (option != 0) {
            return;
        }
        CreditBookDAO.getInstance().delete(selectedCreditBook);
        this.creditBookExplorer.removeRow();
    }

    private void doEditCreditBook() {
        CreditBook selectedCreditBook = this.creditBookExplorer.getSelectedCreditBook();
        if (selectedCreditBook == null) {
            POSMessageDialog.showError(this, Messages.getString("SELECT_A_ROW"));
            return;
        }
        CreditBookForm editor = new CreditBookForm(selectedCreditBook);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.setPreferredSize(PosUIManager.getSize(500, 450));
        dialog.pack();
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.creditBookExplorer.repaintTable();
    }

    private void initData() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.creditBookExplorer.setMemberId(customer.getId());
    }

    private JPanel createCustomerForm() {
        JPanel centerPanel = new JPanel(new BorderLayout(10, 10));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("fillx", "[250px,grow][250px,grow]", ""));
        JScrollPane scrollPane = new JScrollPane(contentPanel, 20, 30);
        this.picturePanel = new JPanel((LayoutManager)new MigLayout());
        this.image = IconFactory.getIcon("/images/", "generic-profile-pic-v2.png").getImage();
        this.lblPicture = new JLabel("");
        this.lblPicture.setPreferredSize(new Dimension(200, 200));
        this.lblPicture.setIcon(new ImageIcon(this.image.getScaledInstance(200, 200, 1)));
        this.lblPicture.setIconTextGap(0);
        this.lblPicture.setHorizontalAlignment(0);
        this.picturePanel.setBorder(new TitledBorder(null, Messages.getString("CustomerForm.10"), 4, 2, null, null));
        this.picturePanel.add((Component)this.lblPicture, "grow, wrap,center");
        this.btnSelectImage = new PosSmallButton();
        this.btnSelectImage.setText(Messages.getString("CustomerForm.44"));
        this.picturePanel.add((Component)this.btnSelectImage, "center,split 2");
        this.btnClearImage = new PosSmallButton();
        this.btnClearImage.setText(Messages.getString("CustomerForm.45"));
        this.picturePanel.add(this.btnClearImage);
        JPanel leftPanel = new JPanel((LayoutManager)new MigLayout("fillx,wrap 2,hidemode 3,top", "[][grow]", ""));
        JPanel rightPanel = new JPanel((LayoutManager)new MigLayout("fillx,wrap 2,hidemode 3,top", "[][grow]", ""));
        centerPanel.add((Component)this.picturePanel, "West");
        JLabel lblMemberId = new JLabel(Messages.getString("CustomerForm.26"));
        leftPanel.add((Component)lblMemberId, "right ");
        this.tfMemberId = new FixedLengthTextField();
        leftPanel.add((Component)this.tfMemberId, "grow");
        JLabel lblSalutation = new JLabel(Messages.getString("CustomerForm.0"));
        leftPanel.add((Component)lblSalutation, "right");
        this.cbSalutation = new JComboBox();
        this.cbSalutation.addItem(null);
        this.cbSalutation.addItem(Messages.getString("CustomerForm.2"));
        this.cbSalutation.addItem(Messages.getString("CustomerForm.4"));
        this.cbSalutation.addItem(Messages.getString("CustomerForm.5"));
        this.cbSalutation.addItem(Messages.getString("CustomerForm.6"));
        this.cbSalutation.setPreferredSize(new Dimension(100, 0));
        leftPanel.add((Component)this.cbSalutation, "grow");
        leftPanel.add((Component)new JLabel(Messages.getString("CustomerForm.28")), "right");
        this.cbMemberType = new JComboBox();
        ComboBoxModel memberTypeModel = new ComboBoxModel();
        memberTypeModel.addElement((Object)null);
        for (MemberType memberType : MemberType.values()) {
            memberTypeModel.addElement((Object)memberType);
        }
        this.cbMemberType.setModel(memberTypeModel);
        this.cbMemberType.setPreferredSize(new Dimension(100, 0));
        leftPanel.add(this.cbMemberType, "grow");
        leftPanel.add((Component)new JLabel(Messages.getString("CustomerForm.68")), "right");
        this.tfMemberShipType = new FixedLengthTextField(255);
        this.tfMemberShipType.setEditable(Boolean.FALSE);
        leftPanel.add((Component)this.tfMemberShipType, "grow");
        JLabel lblFirstName = new JLabel(Messages.getString("CustomerForm.3"));
        leftPanel.add((Component)lblFirstName, "right ");
        this.tfFirstName = new FixedLengthTextField(30);
        leftPanel.add((Component)this.tfFirstName, "grow");
        JLabel lblLastName = new JLabel(Messages.getString("CustomerForm.11"));
        leftPanel.add((Component)lblLastName, "right");
        this.tfLastName = new FixedLengthTextField();
        leftPanel.add((Component)this.tfLastName, "grow");
        this.lblDob = new JLabel(Messages.getString("CustomerForm.33"));
        leftPanel.add((Component)this.lblDob, "right");
        String[] month = new String[]{Messages.getString("CustomerForm.35"), Messages.getString("CustomerForm.36"), Messages.getString("CustomerForm.38"), Messages.getString("CustomerForm.40"), Messages.getString("CustomerForm.43"), Messages.getString("CustomerForm.48"), Messages.getString("CustomerForm.49"), Messages.getString("CustomerForm.50"), Messages.getString("CustomerForm.61"), Messages.getString("CustomerForm.64"), Messages.getString("CustomerForm.65"), Messages.getString("CustomerForm.66")};
        this.cbMonth = new JComboBox<String>(month);
        this.cbDay = new JComboBox();
        this.addDays();
        this.cbYear = new JComboBox();
        this.addYear();
        leftPanel.add(this.cbMonth, "split 3");
        leftPanel.add(this.cbDay, "grow");
        leftPanel.add(this.cbYear, "grow");
        this.tfAddress = new JTextField();
        JLabel street1 = new JLabel(Messages.getString("CustomerForm.70"));
        leftPanel.add((Component)street1, "right");
        this.tfStreet1 = new JTextField();
        leftPanel.add((Component)this.tfStreet1, "grow");
        JLabel street2 = new JLabel(Messages.getString("CustomerForm.71"));
        leftPanel.add((Component)street2, "right");
        this.tfStreet2 = new JTextField();
        leftPanel.add((Component)this.tfStreet2, "grow");
        JLabel street3 = new JLabel(Messages.getString("CustomerForm.72"));
        leftPanel.add((Component)street3, "right");
        this.tfStreet3 = new JTextField();
        leftPanel.add((Component)this.tfStreet3, "grow");
        JLabel lblCitytown = new JLabel(Messages.getString("CustomerForm.24"));
        leftPanel.add((Component)lblCitytown, "right");
        this.tfCity = new FixedLengthTextField();
        leftPanel.add((Component)this.tfCity, "grow");
        JLabel lblState = new JLabel(Messages.getString("CustomerForm.73"));
        leftPanel.add((Component)lblState, "right");
        this.tfState = new FixedLengthTextField();
        leftPanel.add((Component)this.tfState, "grow");
        JLabel lblZip = new JLabel(Messages.getString("CustomerForm.74"));
        leftPanel.add((Component)lblZip, "right");
        this.tfPostalCode = new FixedLengthTextField();
        leftPanel.add((Component)this.tfPostalCode, "grow");
        JLabel lblCountry = new JLabel(Messages.getString("CustomerForm.27"));
        leftPanel.add((Component)lblCountry, "right");
        this.tfCountry = new FixedLengthTextField();
        this.tfCountry.setText(Messages.getString("CustomerForm.29"));
        leftPanel.add((Component)this.tfCountry, "grow");
        this.tfSocialSecurityNumber = new FixedLengthTextField();
        this.lblMobile = new JLabel(Messages.getString("CustomerForm.32"));
        rightPanel.add((Component)this.lblMobile, "right");
        this.tfMobile = new FixedLengthTextField(30);
        rightPanel.add((Component)this.tfMobile, "grow");
        this.lblHomePhone = new JLabel(Messages.getString("CustomerPhone2"));
        rightPanel.add((Component)this.lblHomePhone, "right");
        this.tfHomePhone = new FixedLengthTextField();
        rightPanel.add((Component)this.tfHomePhone, "grow");
        this.lblWorkPhone = new JLabel(Messages.getString("CustomerForm.39"));
        rightPanel.add((Component)this.lblWorkPhone, "right");
        this.tfWorkPhone = new FixedLengthTextField();
        rightPanel.add((Component)this.tfWorkPhone, "grow");
        JLabel lblEmail = new JLabel(Messages.getString("CustomerForm.75") + Messages.getString("CustomerForm.15"));
        rightPanel.add((Component)lblEmail, "right");
        this.tfEmail = new FixedLengthTextField();
        rightPanel.add((Component)this.tfEmail, "grow");
        JLabel lblEmail2 = new JLabel(Messages.getString("CustomerForm.77") + Messages.getString("CustomerForm.15"));
        rightPanel.add((Component)lblEmail2, "right");
        this.tfEmail2 = new FixedLengthTextField();
        rightPanel.add((Component)this.tfEmail2, "grow");
        this.lblLoyaltyPoint = new JLabel(Messages.getString("CustomerForm.34"));
        rightPanel.add((Component)this.lblLoyaltyPoint, "right");
        this.tfLoyaltyPoint = new IntegerTextField();
        rightPanel.add((Component)this.tfLoyaltyPoint, "grow");
        JLabel lblLoyaltyNo = new JLabel(Messages.getString("CustomerForm.31"));
        rightPanel.add((Component)lblLoyaltyNo, "right");
        this.tfLoyaltyNo = new FixedLengthTextField();
        this.tfLoyaltyNo.setLength(8);
        rightPanel.add((Component)this.tfLoyaltyNo, "grow");
        JLabel lblCreditLimit = new JLabel(Messages.getString("CustomerForm.37"));
        rightPanel.add((Component)lblCreditLimit, "right");
        this.tfCreditLimit = new DoubleTextField();
        this.tfCreditLimit.setText("500.00");
        rightPanel.add((Component)this.tfCreditLimit, "grow,wrap");
        this.lblBalance = new JLabel(Messages.getString("CustomerForm.1"));
        rightPanel.add((Component)this.lblBalance, Messages.getString("CustomerForm.7"));
        this.tfBalance = new DoubleTextField();
        this.tfBalance.setText("0.00");
        rightPanel.add((Component)this.tfBalance, "grow");
        this.cbVip = new JCheckBox(Messages.getString("CustomerForm.41"));
        this.cbVip.setFocusable(false);
        rightPanel.add((Component)this.cbVip, "skip 1,wrap");
        this.cbTaxExempt = new JCheckBox(Messages.getString("CustomerForm.42"));
        this.cbTaxExempt.setFocusable(false);
        rightPanel.add((Component)this.cbTaxExempt, "skip 1,wrap");
        this.checkRestrictedFromPOS = new JCheckBox(Messages.getString("CustomerForm.81"));
        this.checkRestrictedFromPOS.setFocusable(false);
        rightPanel.add((Component)this.checkRestrictedFromPOS, "skip 1,wrap");
        this.checkActive = new JCheckBox(Messages.getString("CustomerForm.83"));
        this.checkActive.setFocusable(false);
        this.checkActive.setSelected(true);
        rightPanel.add((Component)this.checkActive, "skip 1,wrap");
        this.checkRequireCashOrCredit = new JCheckBox(Messages.getString("CustomerForm.67"));
        this.checkRequireCashOrCredit.setFocusable(false);
        rightPanel.add((Component)this.checkRequireCashOrCredit, "skip 1,wrap");
        this.qwertyKeyPad = new QwertyKeyPad();
        if (this.isKeypad) {
            centerPanel.add((Component)((Object)this.qwertyKeyPad), "South");
        }
        this.btnSelectImage.addActionListener(e -> this.doSelectImageFile());
        this.btnClearImage.addActionListener(e -> this.doClearImage());
        contentPanel.add((Component)leftPanel, "aligny top");
        contentPanel.add((Component)rightPanel, "aligny top");
        this.enableCustomerFields(false);
        this.callOrderController();
        centerPanel.add(scrollPane);
        return centerPanel;
    }

    private void addYear() {
        for (int year = 1900; year < 2019; ++year) {
            this.cbYear.addItem("" + year);
        }
    }

    private void addDays() {
        for (int day = 1; day < 32; ++day) {
            if (day < 10) {
                this.cbDay.addItem("0" + day);
                continue;
            }
            this.cbDay.addItem("" + day);
        }
    }

    public void callOrderController() {
        Vector<Component> order = new Vector<Component>();
        order.add(this.tfFirstName);
        order.add(this.tfLastName);
        order.add(this.cbMonth);
        order.add(this.cbDay);
        order.add(this.cbYear);
        order.add(this.tfAddress);
        order.add(this.tfPostalCode);
        order.add(this.tfLoyaltyNo);
        order.add(this.tfCreditLimit);
        order.add(this.tfBalance);
        order.add(this.tfSocialSecurityNumber);
        order.add(this.tfCity);
        order.add(this.tfCountry);
        order.add(this.tfMobile);
        order.add(this.tfHomePhone);
        order.add(this.tfWorkPhone);
        order.add(this.tfEmail);
        order.add(this.tfEmail2);
        order.add(this.tfLoyaltyPoint);
        newPolicy = new MyOwnFocusTraversalPolicy(order);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(newPolicy);
    }

    public void enableCustomerFields(boolean enable) {
        this.cbSalutation.setEnabled(enable);
        this.tfLastName.setEnabled(enable);
        this.tfFirstName.setEnabled(enable);
        this.tfEmail.setEnabled(enable);
        this.tfLoyaltyNo.setEnabled(enable);
        this.tfAddress.setEnabled(enable);
        this.tfCity.setEnabled(enable);
        this.tfCreditLimit.setEnabled(enable);
        this.tfBalance.setEditable(enable);
        this.tfPostalCode.setEnabled(enable);
        this.tfCountry.setEnabled(enable);
        this.cbVip.setEnabled(enable);
        this.cbMonth.setEditable(enable);
        this.cbDay.setEditable(enable);
        this.cbYear.setEditable(enable);
        this.btnClearImage.setEnabled(enable);
        this.btnSelectImage.setEnabled(enable);
        this.tfLoyaltyPoint.setEnabled(enable);
        this.tfHomePhone.setEnabled(enable);
        this.tfWorkPhone.setEnabled(enable);
        this.tfMobile.setEnabled(enable);
        this.tfSocialSecurityNumber.setEnabled(enable);
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.cbSalutation.setEnabled(enable);
        this.tfFirstName.setEnabled(enable);
        this.tfLastName.setEnabled(enable);
        this.tfEmail.setEnabled(enable);
        this.tfLoyaltyNo.setEnabled(enable);
        this.tfAddress.setEnabled(enable);
        this.tfCity.setEnabled(enable);
        this.tfCreditLimit.setEnabled(enable);
        this.tfPostalCode.setEnabled(enable);
        this.tfCountry.setEnabled(enable);
        this.cbVip.setEnabled(enable);
        this.cbMonth.setEditable(enable);
        this.cbDay.setEditable(enable);
        this.cbYear.setEditable(enable);
        this.btnClearImage.setEnabled(enable);
        this.btnSelectImage.setEnabled(enable);
        this.tfLoyaltyPoint.setEnabled(enable);
        this.tfHomePhone.setEnabled(enable);
        this.tfWorkPhone.setEnabled(enable);
        this.tfMobile.setEnabled(enable);
        this.tfSocialSecurityNumber.setEnabled(enable);
    }

    public void setFieldsEditable(boolean editable) {
        this.cbSalutation.setEditable(editable);
        this.tfFirstName.setEditable(editable);
        this.tfLastName.setEditable(editable);
        this.tfEmail.setEditable(editable);
        this.tfLoyaltyNo.setEditable(editable);
        this.tfAddress.setEditable(editable);
        this.tfCity.setEditable(editable);
        this.tfCreditLimit.setEditable(editable);
        this.tfBalance.setEditable(editable);
        this.tfPostalCode.setEditable(editable);
        this.tfCountry.setEditable(editable);
        this.cbVip.setEnabled(editable);
        this.cbMonth.setEditable(editable);
        this.cbDay.setEditable(editable);
        this.cbYear.setEditable(editable);
        this.btnClearImage.setEnabled(editable);
        this.btnSelectImage.setEnabled(editable);
        this.tfLoyaltyPoint.setEditable(editable);
        this.tfHomePhone.setEditable(editable);
        this.tfWorkPhone.setEditable(editable);
        this.tfMobile.setEditable(editable);
        this.tfSocialSecurityNumber.setEditable(editable);
    }

    @Override
    public void createNew() {
        this.setBean(new Customer());
        this.tfFirstName.setText("");
        this.tfLastName.setText("");
        this.cbSalutation.setSelectedIndex(0);
        this.cbMonth.setSelectedItem(0);
        this.cbDay.setSelectedItem(0);
        this.cbYear.setSelectedItem(0);
        this.tfAddress.setText("");
        this.tfCity.setText("");
        this.tfCountry.setText("");
        this.tfCreditLimit.setText("");
        this.tfBalance.setText("");
        this.tfEmail.setText("");
        this.tfLoyaltyNo.setText("");
        this.tfLoyaltyPoint.setText("");
        this.tfHomePhone.setText("");
        this.tfPostalCode.setText("");
        this.cbVip.setSelected(false);
        this.tfWorkPhone.setText("");
        this.tfMobile.setText("");
        this.tfSocialSecurityNumber.setText("");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Customer customer = (Customer)this.getBean();
            CustomerDAO.getInstance().saveOrUpdate(customer);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException customer) {
        }
        catch (StaleObjectStateException e) {
            BOMessageDialog.showError(this, Messages.getString("CustomerForm.47"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.tfMemberId.setText(customer.getMemberId());
        this.cbSalutation.setSelectedItem(customer.getSalutation());
        this.tfFirstName.setText(customer.getFirstName());
        this.tfLastName.setText(customer.getLastName());
        this.addDOB(customer);
        this.tfAddress.setText(customer.getAddress());
        this.tfMemberShipType.setText(customer.getMemberShipType());
        this.tfCity.setText(customer.getCity());
        this.tfCountry.setText(customer.getCountry());
        this.tfCreditLimit.setText(NumberUtil.getCurrencyFormatWithoutCurrencySymbol(customer.getCreditLimit()));
        this.tfBalance.setText(NumberUtil.getCurrencyFormatWithoutCurrencySymbol(customer.getBalance()));
        this.tfEmail.setText(customer.getEmail());
        this.tfEmail2.setText(customer.getEmail2());
        this.tfLoyaltyNo.setText(customer.getLoyaltyNo());
        this.tfLoyaltyPoint.setText(customer.getLoyaltyPoint().toString());
        this.tfHomePhone.setText(customer.getHomePhoneNo());
        this.tfPostalCode.setText(customer.getZipCode());
        this.tfState.setText(customer.getState());
        this.cbVip.setSelected(customer.isVip());
        this.cbTaxExempt.setSelected(customer.isTaxExempt());
        this.tfWorkPhone.setText(customer.getWorkPhoneNo());
        this.tfMobile.setText(customer.getMobileNo());
        if (customer.getSsn() != null) {
            this.tfSocialSecurityNumber.setText(String.valueOf(customer.getSsn()));
        }
        this.imageResource = ImageResourceDAO.getInstance().findById(customer.getImageId());
        if (this.imageResource != null) {
            this.lblPicture.setIcon(new ImageIcon(this.imageResource.getImage().getScaledInstance(200, 200, 1)));
        } else {
            this.lblPicture.setIcon(new ImageIcon(this.image.getScaledInstance(200, 200, 1)));
        }
        this.cbMemberType.setSelectedItem((Object)customer.getMemberType());
        this.checkActive.setSelected(customer.isActive());
        this.checkRequireCashOrCredit.setSelected(customer.isRequireCashOrCredit());
        this.checkRestrictedFromPOS.setSelected(customer.isRestrictedFromPOS());
        this.initData();
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setTitle(Messages.getString("CustomerForm.8"));
        dialog.setSize(PosUIManager.getSize(850, 600));
        dialog.setSelectBtnVisible(true);
        dialog.setResizable(true);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblPicture.setIcon(new ImageIcon(this.imageResource.getImage().getScaledInstance(200, 200, 1)));
        }
    }

    protected void doClearImage() {
        this.lblPicture.setIcon(new ImageIcon(this.image.getScaledInstance(200, 200, 1)));
        this.imageResource = null;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        int option;
        String memberId;
        String fname = this.tfFirstName.getText();
        String lname = this.tfLastName.getText();
        String personalEmail = this.tfEmail.getText();
        String businessEmail = this.tfEmail2.getText();
        MemberType memberType = (MemberType)((Object)this.cbMemberType.getSelectedItem());
        if (StringUtils.isEmpty((String)fname) && StringUtils.isEmpty((String)lname)) {
            POSMessageDialog.showError(null, Messages.getString("CustomerForm.60"));
            return false;
        }
        if (StringUtils.isNotEmpty((String)personalEmail) && !this.doCheckValidEmail(personalEmail)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)businessEmail) && !this.doCheckValidEmail(businessEmail)) {
            return false;
        }
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            customer = new Customer();
            this.setBean(customer, false);
        }
        if (StringUtils.isNotEmpty((String)(memberId = this.tfMemberId.getText())) && ForeteesCustomerDAO.getInstance().isContainMemberId(memberId, customer.getId()) && (option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("MEMBER_ID_EXIST"), POSConstants.CONFIRM)) != 0) {
            return false;
        }
        customer.setMemberId(memberId);
        customer.setSalutation(String.valueOf(this.cbSalutation.getSelectedItem()));
        customer.setFirstName(this.tfFirstName.getText());
        customer.setLastName(this.tfLastName.getText());
        customer.setDob(this.updateDate());
        customer.setAddress(this.tfAddress.getText());
        customer.setMemberType(memberType);
        customer.setMemberShipType(this.tfMemberShipType.getText());
        customer.setRestrictedFromPOS(this.checkRestrictedFromPOS.isSelected());
        customer.setActive(this.checkActive.isSelected());
        customer.setRequireCashOrCredit(this.checkRequireCashOrCredit.isSelected());
        customer.setCity(this.tfCity.getText());
        customer.setCountry(this.tfCountry.getText());
        customer.setCreditLimit(PosGuiUtil.parseDouble(this.tfCreditLimit));
        customer.setBalance(PosGuiUtil.parseDouble(this.tfBalance));
        customer.setEmail(personalEmail);
        customer.setEmail2(businessEmail);
        customer.setLoyaltyNo(this.tfLoyaltyNo.getText());
        customer.setLoyaltyPoint(this.tfLoyaltyPoint.getInteger());
        customer.setState(this.tfState.getText());
        customer.setZipCode(this.tfPostalCode.getText());
        customer.setVip(this.cbVip.isSelected());
        customer.setTaxExempt(this.cbTaxExempt.isSelected());
        customer.setSsn(this.tfSocialSecurityNumber.getText());
        customer.setHomePhoneNo(this.tfHomePhone.getText());
        customer.setWorkPhoneNo(this.tfWorkPhone.getText());
        customer.setMobileNo(this.tfMobile.getText());
        if (this.imageResource != null) {
            customer.setImageId(this.imageResource.getId());
        } else {
            customer.setImageId(null);
        }
        return true;
    }

    private boolean doCheckValidEmail(String personalEmail) {
        boolean valid = EmailValidator.getInstance().isValid(personalEmail);
        if (!valid) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerForm.9"));
            return false;
        }
        return valid;
    }

    @Override
    public boolean delete() {
        try {
            Customer bean2 = (Customer)this.getBean();
            if (bean2 == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected table?", "Confirm");
            if (option != 0) {
                return false;
            }
            CustomerDAO.getInstance().delete(bean2);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("CustomerForm.88");
    }

    private void addDOB(Customer customer) {
        String dob = customer.getDob();
        if (dob == null) {
            this.cbMonth.setSelectedItem(null);
            this.cbDay.setSelectedItem(null);
            this.cbYear.setSelectedItem(null);
        } else {
            try {
                this.cbMonth.setSelectedItem(CustomerForm.getMonthInText(dob));
                this.cbDay.setSelectedItem(dob.substring(8, 10));
                this.cbYear.setSelectedItem(dob.substring(0, 4));
            }
            catch (Exception e) {
                this.cbMonth.setSelectedItem(null);
                this.cbDay.setSelectedItem(null);
                this.cbYear.setSelectedItem(null);
            }
        }
    }

    private String updateDate() {
        Object year = this.cbYear.getSelectedItem();
        Object month = this.cbMonth.getSelectedItem();
        Object day = this.cbDay.getSelectedItem();
        if (year == null || month == null || day == null) {
            return null;
        }
        return year.toString() + "-" + this.getMonthInNumeric(month.toString()) + "-" + day.toString();
    }

    private String getMonthInNumeric(String monthName) {
        try {
            Date date = new SimpleDateFormat("MMMM").parse(monthName);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int monthNum = cal.get(2) + 1;
            String month = null;
            month = monthNum < 10 ? "0" + monthNum : String.valueOf(monthNum);
            return month;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getMonthInText(String dob) {
        try {
            SimpleDateFormat month_date = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            if (dob != null) {
                Date date = sdf.parse(dob);
                return month_date.format(date);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        public MyOwnFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

