/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.model.FinancialAccount;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Promotion;
import com.floreantpos.model.dao.FinancialAccountDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PromotionDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PromotionForm
extends BeanEditor<Promotion> {
    private FixedLengthTextField tfName;
    private JRadioButton chkAmount;
    private JRadioButton chkPercentage;
    private JCheckBox chkActive;
    private CheckBoxList<OrderType> chkOrderType;
    private JComboBox<Object> cbFinancialAccounts;

    public PromotionForm() {
        this(new Promotion());
    }

    public PromotionForm(Promotion promotion) {
        this.initComponents();
        this.initData(promotion);
        this.setBean(promotion);
    }

    public void initData(Promotion promotion) {
        List<OrderType> orderTypes = OrderTypeDAO.getInstance().findAll();
        this.chkOrderType.setModel(orderTypes);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JLabel lblName = new JLabel("Name: ");
        this.tfName = new FixedLengthTextField(62);
        ButtonGroup btnGroup = new ButtonGroup();
        this.chkAmount = new JRadioButton("Amount");
        this.chkPercentage = new JRadioButton("Percentage");
        btnGroup.add(this.chkAmount);
        btnGroup.add(this.chkPercentage);
        this.chkActive = new JCheckBox("Active");
        this.chkOrderType = new CheckBoxList();
        this.chkOrderType.setTableHeaderHide(true);
        JPanel promotionTypePanel = new JPanel((LayoutManager)new MigLayout(""));
        promotionTypePanel.setBorder(BorderFactory.createTitledBorder(null, "Promotion Type", 1, 0));
        promotionTypePanel.add(this.chkAmount);
        promotionTypePanel.add((Component)this.chkPercentage, "right");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx, center", "[][]", ""));
        centerPanel.add((Component)lblName, "trailing");
        centerPanel.add((Component)this.tfName, " wrap, w 350!");
        centerPanel.add((Component)new JScrollPane(this.chkOrderType), "skip 1, wrap, , w 350!, h 150!");
        centerPanel.add((Component)promotionTypePanel, "skip 1, w 350!,  wrap");
        centerPanel.add((Component)this.chkActive, "skip 1, wrap");
        JLabel lblFinancialAccounts = new JLabel("Financial Account: ");
        this.cbFinancialAccounts = new JComboBox();
        ArrayList<Object> allFinancialAccounts = new ArrayList<Object>();
        allFinancialAccounts.add("");
        allFinancialAccounts.addAll(FinancialAccountDAO.getInstance().findAll());
        this.cbFinancialAccounts.setModel(new ListComboBoxModel(allFinancialAccounts));
        centerPanel.add((Component)lblFinancialAccounts, "trailing");
        centerPanel.add(this.cbFinancialAccounts, "w 350!, wrap");
        this.add((Component)centerPanel, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            PromotionDAO.getInstance().saveOrUpdate((Promotion)this.getBean());
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
        return true;
    }

    @Override
    protected void updateView() {
        Promotion promotion = (Promotion)this.getBean();
        if (promotion.getId() == null) {
            return;
        }
        PromotionDAO.getInstance().initializeOrderTypes(promotion);
        this.tfName.setText(promotion.getName());
        this.chkAmount.setSelected(promotion.isAmountBased());
        this.chkPercentage.setSelected(promotion.isPercentageBased());
        this.chkActive.setSelected(promotion.isActive());
        this.chkOrderType.selectItems(promotion.getOrderTypes());
        for (int i = 0; i < this.cbFinancialAccounts.getItemCount(); ++i) {
            FinancialAccount financialAccount;
            Object object = this.cbFinancialAccounts.getItemAt(i);
            if (!(object instanceof FinancialAccount) || !(financialAccount = (FinancialAccount)object).getId().equals(promotion.getFinancialAccountId())) continue;
            this.cbFinancialAccounts.setSelectedItem(financialAccount);
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Promotion promotion = (Promotion)this.getBean();
        String name = this.tfName.getText();
        boolean isAmount = this.chkAmount.isSelected();
        boolean isPercentage = this.chkPercentage.isSelected();
        boolean isActive = this.chkActive.isSelected();
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter name.");
            return false;
        }
        if (!isAmount && !isPercentage) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select either amount or percentage.");
            return false;
        }
        if (this.chkOrderType.getCheckedValues() == null || this.chkOrderType.getCheckedValues().isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select ordertype.");
            return false;
        }
        promotion.setName(name);
        promotion.setAmountBased(isAmount);
        promotion.setPercentageBased(isPercentage);
        promotion.setActive(isActive);
        promotion.setOrderTypes(this.chkOrderType.getCheckedValues());
        Object object = this.cbFinancialAccounts.getSelectedItem();
        String financialAccountId = "";
        if (object != null && object instanceof FinancialAccount) {
            financialAccountId = ((FinancialAccount)object).getId();
        }
        promotion.setFinancialAccountId(financialAccountId);
        return true;
    }

    @Override
    public String getDisplayText() {
        Promotion promotion = (Promotion)this.getBean();
        if (promotion.getId() == null) {
            return "Add Promotion";
        }
        return "Edit Promotion";
    }
}

