/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerDocument;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class ComboItemEntryDialog
extends POSDialog
implements ActionListener {
    private JComboBox cbGroup;
    private JComboBox cbMenuItem;
    private DoubleTextField tfQuantity;
    private JLabel lblMenuItem;
    private JLabel lblQuantity;

    public ComboItemEntryDialog(MenuItem menuItem) {
        super(POSUtil.getFocusedWindow(), "");
        this.init();
        this.rendererMenuItems();
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setIconImage(Application.getPosWindow().getIconImage());
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ComboItemEntryDialog.2"));
        this.add((Component)titlePanel, "North");
        this.cbGroup = new JComboBox();
        this.cbMenuItem = new JComboBox();
        this.tfQuantity = new DoubleTextField(10);
        List<MenuGroup> menuGroupList = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup s : menuGroupList) {
            this.cbGroup.addItem(s);
        }
        this.cbGroup.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ComboItemEntryDialog.this.rendererMenuItems();
            }
        });
        contentPane.add(new JLabel(Messages.getString("ComboItemEntryDialog.3")));
        contentPane.add((Component)this.cbGroup, "grow,wrap");
        this.lblMenuItem = new JLabel(Messages.getString("ComboItemEntryDialog.5"));
        contentPane.add(this.lblMenuItem);
        contentPane.add((Component)this.cbMenuItem, "grow,wrap");
        this.lblQuantity = new JLabel(Messages.getString("ComboItemEntryDialog.7"));
        contentPane.add(this.lblQuantity);
        contentPane.add((Component)this.tfQuantity, "grow,wrap");
        contentPane.add((Component)new JSeparator(), "gaptop 10,span 2,grow");
        PosButton btnOk = new PosButton(POSConstants.OK);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
        this.pack();
    }

    private void rendererMenuItems() {
        MenuGroup selectedGroup = (MenuGroup)this.cbGroup.getSelectedItem();
        List<MenuItem> menuItems = MenuItemDAO.getInstance().findByParent(null, selectedGroup, false);
        Iterator<MenuItem> iterator = menuItems.iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem = iterator.next();
            if (!menuItem.isComboItem().booleanValue()) continue;
            iterator.remove();
        }
        this.cbMenuItem.setModel(new ListComboBoxModel(menuItems));
    }

    public void setSelectedItem(MenuItem item) {
        this.cbGroup.setSelectedItem(null);
        if (item != null && item.getMenuGroupId() != null) {
            PosGuiUtil.selectComboItemById(this.cbGroup, item.getMenuGroupId());
        }
        this.rendererMenuItems();
        this.cbMenuItem.setSelectedItem(item);
    }

    public void setSelectedGroup(MenuGroup menuGroup) {
        this.lblQuantity.setText(Messages.getString("ComboItemEntryDialog.13"));
        this.lblMenuItem.setVisible(false);
        this.cbMenuItem.setVisible(false);
        if (menuGroup != null) {
            this.cbGroup.setSelectedItem(menuGroup);
        }
    }

    public void setQuantity(Double quantity) {
        this.tfQuantity.setText(String.valueOf(quantity));
    }

    public void setQuantity(Integer quantity) {
        this.tfQuantity.setText(String.valueOf(quantity));
    }

    private void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    public MenuItem getItem() {
        return (MenuItem)this.cbMenuItem.getSelectedItem();
    }

    public MenuGroup getSelectedGroup() {
        return (MenuGroup)this.cbGroup.getSelectedItem();
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    public Double getQuantity() {
        if (Double.isNaN(this.tfQuantity.getDouble())) {
            return 1.0;
        }
        return this.tfQuantity.getDouble();
    }

    public void setFloatingPoint(boolean b) {
        if (!b) {
            this.tfQuantity.setDocument(new IntegerDocument());
        }
    }

    public int getIntegerValue() {
        try {
            return Integer.parseInt(this.tfQuantity.getText());
        }
        catch (Exception e) {
            return 0;
        }
    }
}

