/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.model.FinancialAccount;
import com.floreantpos.model.dao.FinancialAccountDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class FinancialAccountEntryForm
extends BeanEditor<FinancialAccount> {
    private FinancialAccount financialAccount;
    private FixedLengthTextField txtName;

    public FinancialAccountEntryForm(FinancialAccount financialAccount) {
        this.financialAccount = financialAccount;
        this.initComponents();
        this.setBean(financialAccount);
    }

    public void initComponents() {
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fill,alignx center", "[][]", ""));
        JLabel lblName = new JLabel("Name");
        this.txtName = new FixedLengthTextField(20);
        mainPanel.add(lblName);
        mainPanel.add(this.txtName);
        this.add(mainPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            FinancialAccount item = (FinancialAccount)this.getBean();
            FinancialAccountDAO financialAccountDAO = new FinancialAccountDAO();
            financialAccountDAO.saveOrUpdate(item);
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        FinancialAccount item = (FinancialAccount)this.getBean();
        this.txtName.setText(item.getName());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String name = this.txtName.getText();
        if (name == null) {
            MessageDialog.showError("Please enter name");
            return false;
        }
        this.financialAccount.setName(name);
        return true;
    }

    @Override
    public String getDisplayText() {
        FinancialAccount item = (FinancialAccount)this.getBean();
        if (item.getId() == null) {
            return "Add New Financial Account";
        }
        return "Edit Financial Account";
    }
}

