/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class MenuModifierForm
extends BeanEditor
implements RefreshableView {
    private JCheckBox chkPrintToKitchen;
    private JComboBox cbTaxGroup;
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfTranslatedName;
    private DoubleTextField tfNormalPrice;
    private DoubleTextField tfExtraPrice;
    private IntegerTextField tfSortOrder;
    private JButton btnButtonColor;
    private JButton btnTextColor;
    private JTable priceTable;
    private JTabbedPane jTabbedPane1;
    private Map<String, MultiplierPricePanel> itemMap = new HashMap<String, MultiplierPricePanel>();
    private JCheckBox chkUseFixedPrice;
    private JCheckBox chkComboModifier;
    private JCheckBox chkTaxable;
    private JPanel taxablePanel;
    private JLabel lblTaxGroup;
    private JButton btnNewTax;
    private JRadioButton btnSameAsItem;
    private JRadioButton btnCustom;

    public MenuModifierForm() throws Exception {
        this(new MenuModifier());
    }

    public MenuModifierForm(MenuModifier modifier) throws Exception {
        this.checkRegularMultiplier();
        this.initComponents();
        this.initData();
        this.add(this.jTabbedPane1);
        this.setBean(modifier);
    }

    private void initData() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        List<TaxGroup> taxGroups = TaxGroupDAO.getInstance().findAll();
        for (TaxGroup taxGroup : taxGroups) {
            comboBoxModel.addElement(taxGroup);
        }
        this.cbTaxGroup.setModel(comboBoxModel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(0, 0));
        this.jTabbedPane1 = new JTabbedPane();
        this.tfName = new FixedLengthTextField(120);
        this.tfTranslatedName = new FixedLengthTextField();
        this.tfNormalPrice = new DoubleTextField();
        this.tfExtraPrice = new DoubleTextField();
        this.tfSortOrder = new IntegerTextField(100);
        this.cbTaxGroup = new OverflowCombobox();
        this.cbTaxGroup.setVisible(Boolean.FALSE);
        this.btnNewTax = new JButton();
        this.btnNewTax.setVisible(Boolean.FALSE);
        this.chkPrintToKitchen = new JCheckBox();
        this.chkUseFixedPrice = new JCheckBox(Messages.getString("MenuModifierForm.11"));
        JPanel tabPrice = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        this.priceTable = new JTable();
        JLabel lblName = new JLabel(POSConstants.NAME + ":");
        JLabel lblTranslatedName = new JLabel(Messages.getString("MenuModifierForm.0"));
        JLabel lblSortOrder = new JLabel(Messages.getString("MenuModifierForm.15"));
        this.lblTaxGroup = new JLabel(Messages.getString("MenuModifierForm.13") + ":");
        this.lblTaxGroup.setVisible(Boolean.FALSE);
        this.tfExtraPrice.setText("0");
        this.tfNormalPrice.setText("0");
        this.btnNewTax.setText("...");
        this.btnNewTax.addActionListener(evt -> this.btnNewTaxActionPerformed(evt));
        this.chkPrintToKitchen.setText(POSConstants.PRINT_TO_KITCHEN);
        this.chkPrintToKitchen.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkPrintToKitchen.setMargin(new Insets(0, 0, 0, 0));
        JPanel generalTabPanel = new JPanel(new BorderLayout(10, 10));
        this.jTabbedPane1.addTab(POSConstants.GENERAL, generalTabPanel);
        TransparentPanel lelfInputPanel = new TransparentPanel();
        lelfInputPanel.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[90px][grow]", ""));
        lelfInputPanel.add((Component)lblName, "alignx left,aligny center");
        lelfInputPanel.add((Component)this.tfName, "growx,aligny top");
        lelfInputPanel.add((Component)lblTranslatedName, "alignx left,aligny center");
        lelfInputPanel.add((Component)this.tfTranslatedName, "growx");
        JPanel rightInputPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[90px][grow]", ""));
        this.chkTaxable = new JCheckBox(Messages.getString("MenuModifierForm.333"));
        this.chkTaxable.addItemListener(e -> this.doPerformOnTaxUI());
        rightInputPanel.add((Component)this.chkTaxable, "alignx left,aligny center,wrap");
        this.taxablePanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[86px][grow]"));
        this.taxablePanel.setBorder(BorderFactory.createTitledBorder(POSConstants.TAX));
        this.taxablePanel.setVisible(Boolean.FALSE);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnSameAsItem = new JRadioButton(Messages.getString("MenuModifierForm.777"));
        this.btnSameAsItem.setSelected(Boolean.TRUE);
        this.btnCustom = new JRadioButton(Messages.getString("MenuModifierForm.888"));
        this.btnCustom.addItemListener(e -> this.doPerformOnCustomTaxUI(e));
        buttonGroup.add(this.btnSameAsItem);
        buttonGroup.add(this.btnCustom);
        this.taxablePanel.add((Component)this.btnSameAsItem, "alignx left,aligny center,wrap");
        this.taxablePanel.add((Component)this.btnCustom, "alignx left,aligny center,wrap");
        this.taxablePanel.add((Component)this.lblTaxGroup, "alignx left,aligny top,split 2");
        this.taxablePanel.add((Component)this.cbTaxGroup, "growx,aligny top,split 2,width 100!");
        this.taxablePanel.add((Component)this.btnNewTax, "alignx left,aligny top");
        rightInputPanel.add(this.taxablePanel);
        rightInputPanel.add((Component)lblSortOrder, "newline,alignx left,aligny center,split 2");
        rightInputPanel.add((Component)this.tfSortOrder, "alignx left,growx,aligny top,width 150!");
        rightInputPanel.add((Component)this.chkPrintToKitchen, "skip 1,alignx left,aligny top");
        this.chkComboModifier = new JCheckBox(Messages.getString("MenuModifierForm.18"));
        rightInputPanel.add((Component)this.chkComboModifier, "skip 1,alignx left,aligny top");
        generalTabPanel.add(lelfInputPanel);
        generalTabPanel.add((Component)rightInputPanel, "East");
        JLabel lblButtonColor = new JLabel(Messages.getString("MenuModifierForm.1"));
        this.btnButtonColor = new JButton("");
        this.btnButtonColor.setPreferredSize(new Dimension(140, 40));
        JLabel lblTextColor = new JLabel(Messages.getString("MenuModifierForm.27"));
        this.btnTextColor = new JButton(Messages.getString("MenuModifierForm.29"));
        this.btnTextColor.setPreferredSize(new Dimension(140, 40));
        JPanel tabButtonStyle = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2"));
        tabButtonStyle.add(lblButtonColor);
        tabButtonStyle.add(this.btnButtonColor);
        tabButtonStyle.add(lblTextColor);
        tabButtonStyle.add(this.btnTextColor);
        this.jTabbedPane1.addTab("Button Style", tabButtonStyle);
        this.btnButtonColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(MenuModifierForm.this, Messages.getString("MenuModifierForm.39"), MenuModifierForm.this.btnButtonColor.getBackground());
                if (color != null) {
                    MenuModifierForm.this.btnButtonColor.setBackground(color);
                    MenuModifierForm.this.btnTextColor.setBackground(color);
                }
            }
        });
        this.btnTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(MenuModifierForm.this, Messages.getString("MenuModifierForm.40"), MenuModifierForm.this.btnTextColor.getForeground());
                if (color != null) {
                    MenuModifierForm.this.btnTextColor.setForeground(color);
                }
            }
        });
        this.priceTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        jScrollPane3.setViewportView(this.priceTable);
        tabPrice.setLayout(new BorderLayout());
        tabPrice.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        tabPrice.add((Component)jScrollPane3, "Center");
        JPanel buttonPanel = new JPanel();
        JPanel multiplierPanel = new JPanel((LayoutManager)new MigLayout("fillx,wrap 1"));
        List<Multiplier> multipliers = MultiplierDAO.getInstance().findAll();
        if (multipliers != null) {
            for (Multiplier multiplier : multipliers) {
                MultiplierPricePanel multiplierPricePanel = new MultiplierPricePanel(multiplier);
                multiplierPanel.add((Component)multiplierPricePanel, "grow");
                this.itemMap.put(multiplier.getId(), multiplierPricePanel);
            }
        }
        JScrollPane scrollPane = new JScrollPane(multiplierPanel);
        scrollPane.setBorder(new TitledBorder(Messages.getString("MenuModifierForm.28")));
        lelfInputPanel.add((Component)scrollPane, "newline,skip 1,grow");
        tabPrice.add((Component)buttonPanel, "South");
        if (TerminalConfig.isMultipleOrderSupported()) {
            // empty if block
        }
    }

    private void doPerformOnCustomTaxUI(ItemEvent e) {
        if (e.getStateChange() == 1) {
            this.lblTaxGroup.setVisible(Boolean.TRUE);
            this.cbTaxGroup.setVisible(Boolean.TRUE);
            this.btnNewTax.setVisible(Boolean.TRUE);
        } else {
            this.lblTaxGroup.setVisible(Boolean.FALSE);
            this.cbTaxGroup.setVisible(Boolean.FALSE);
            this.btnNewTax.setVisible(Boolean.FALSE);
        }
    }

    private void doPerformOnTaxUI() {
    }

    private void checkRegularMultiplier() {
        Multiplier multiplier = MultiplierDAO.getInstance().get("Regular");
        if (multiplier != null && multiplier.isMain().booleanValue()) {
            return;
        }
        if (multiplier == null) {
            multiplier = new Multiplier("Regular");
            multiplier.setRate(0.0);
            multiplier.setSortOrder(0);
            multiplier.setTicketPrefix("");
            multiplier.setDefaultMultiplier(true);
            multiplier.setMain(true);
            MultiplierDAO.getInstance().save(multiplier);
        } else {
            multiplier.setMain(true);
            MultiplierDAO.getInstance().update(multiplier);
        }
    }

    private void btnNewTaxActionPerformed(ActionEvent evt) {
        try {
            TaxForm editor = new TaxForm();
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            ComboBoxModel model = (ComboBoxModel)this.cbTaxGroup.getModel();
            model.setDataList(TaxGroupDAO.getInstance().findAll());
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuModifier modifier = (MenuModifier)this.getBean();
            MenuModifierDAO.getInstance().saveMenuModifierFormData(modifier);
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        MultiplierPricePanel multiplierPricePanel;
        List<ModifierMultiplierPrice> multiplierPriceList;
        MenuModifier modifier = (MenuModifier)this.getBean();
        if (modifier == null) {
            this.tfName.setText("");
            this.tfNormalPrice.setText("0");
            this.tfExtraPrice.setText("0");
            return;
        }
        MenuModifierDAO.getInstance().initialize(modifier);
        this.tfName.setText(modifier.getName());
        this.tfTranslatedName.setText(modifier.getTranslatedName());
        this.tfNormalPrice.setText(NumberUtil.formatNumber(modifier.getPrice()));
        this.tfExtraPrice.setText(NumberUtil.formatNumber(modifier.getExtraPrice()));
        this.chkPrintToKitchen.setSelected(modifier.isShouldPrintToKitchen());
        this.chkComboModifier.setSelected(modifier.isComboModifier());
        this.chkUseFixedPrice.setSelected(modifier.isFixedPrice());
        this.chkTaxable.setSelected(modifier.isTaxable());
        if (modifier.getId() == null) {
            this.btnSameAsItem.setSelected(true);
        } else {
            boolean taxSameAsItem = POSUtil.getBoolean(modifier.getProperty("tax.same.as.item"));
            if (taxSameAsItem) {
                this.btnSameAsItem.setSelected(true);
            } else {
                this.btnCustom.setSelected(true);
            }
        }
        if (modifier.getSortOrder() != null) {
            this.tfSortOrder.setText(modifier.getSortOrder().toString());
        }
        if (modifier.getButtonColor() != null) {
            Color color = new Color(modifier.getButtonColor());
            this.btnButtonColor.setBackground(color);
            this.btnTextColor.setBackground(color);
        }
        if (modifier.getTextColor() != null) {
            Color color = new Color(modifier.getTextColor());
            this.btnTextColor.setForeground(color);
        }
        if (modifier.getTaxGroup() != null) {
            this.cbTaxGroup.setSelectedItem(modifier.getTaxGroup());
        }
        if ((multiplierPriceList = modifier.getMultiplierPriceList()) != null && multiplierPriceList.size() > 0) {
            for (ModifierMultiplierPrice multiplierPrice : multiplierPriceList) {
                MultiplierPricePanel pricePanel;
                Multiplier multiplier = multiplierPrice.getMultiplier();
                if (multiplier == null || (pricePanel = this.itemMap.get(multiplier.getId())) == null) continue;
                pricePanel.setModifierMultiplierPrice(multiplierPrice);
            }
        }
        if ((multiplierPricePanel = this.itemMap.get("Regular")) != null) {
            multiplierPricePanel.tfAditionalPrice.setText(String.valueOf(modifier.getPrice()));
        }
    }

    @Override
    protected boolean updateModel() {
        MenuModifier modifier = (MenuModifier)this.getBean();
        String name = this.tfName.getText();
        if (StringUtils.isBlank((String)name)) {
            POSMessageDialog.showError(this, Messages.getString("MenuModifierForm.44"));
            return false;
        }
        modifier.setName(name.trim());
        modifier.setExtraPrice(this.tfExtraPrice.getDouble());
        modifier.setShouldPrintToKitchen(this.chkPrintToKitchen.isSelected());
        modifier.setComboModifier(this.chkComboModifier.isSelected());
        modifier.setTranslatedName(this.tfTranslatedName.getText());
        modifier.setButtonColor(this.btnButtonColor.getBackground().getRGB());
        modifier.setTextColor(this.btnTextColor.getForeground().getRGB());
        modifier.setSortOrder(this.tfSortOrder.getInteger());
        modifier.setFixedPrice(this.chkUseFixedPrice.isSelected());
        boolean isTaxable = this.chkTaxable.isSelected();
        modifier.setTaxable(isTaxable);
        if (isTaxable) {
            modifier.setTaxable(true);
            modifier.addProperty("tax.same.as.item", String.valueOf(Boolean.TRUE));
        } else {
            modifier.setTaxable(false);
        }
        ArrayList<ModifierMultiplierPrice> mulplierPriceList = new ArrayList<ModifierMultiplierPrice>();
        for (MultiplierPricePanel panel : this.itemMap.values()) {
            if (!panel.isSelected()) continue;
            ModifierMultiplierPrice multiplierPrice = panel.getMultiplierPrice();
            if (multiplierPrice == null) {
                multiplierPrice = new ModifierMultiplierPrice();
                multiplierPrice.setMultiplier(panel.getMultiplier());
                multiplierPrice.setModifierId(modifier.getId());
            }
            multiplierPrice.setPrice(panel.getPrice());
            mulplierPriceList.add(multiplierPrice);
        }
        MultiplierPricePanel multiplierPricePanel = this.itemMap.get("Regular");
        if (multiplierPricePanel != null) {
            modifier.setPrice(multiplierPricePanel.getPrice());
        }
        modifier.setMultiplierPriceList(mulplierPriceList);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuModifier modifier = (MenuModifier)this.getBean();
        if (modifier.getId() == null) {
            return Messages.getString("MenuModifierForm.45");
        }
        return Messages.getString("MenuModifierForm.46");
    }

    protected void doCalculateMultiplierPrice() {
        MultiplierPricePanel regularPricePanel = this.itemMap.get("Regular");
        if (regularPricePanel == null) {
            return;
        }
        for (MultiplierPricePanel panel : this.itemMap.values()) {
            panel.calculatePrice(regularPricePanel.tfAditionalPrice.getDoubleOrZero());
        }
    }

    public double getDoubleOrZero(String text) {
        try {
            return Double.parseDouble(text);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @Override
    public void refresh() {
        MenuModifier mModifier = (MenuModifier)this.getBean();
        MenuModifier menuModifier = MenuModifierDAO.getInstance().get(mModifier.getId());
        this.setBean(menuModifier);
    }

    private class MultiplierPricePanel
    extends JPanel {
        ModifierMultiplierPrice multiplierPrice;
        Multiplier multiplier;
        DoubleTextField tfAditionalPrice;

        public MultiplierPricePanel(Multiplier multiplier) {
            this.multiplier = multiplier;
            this.setLayout((LayoutManager)new MigLayout("inset 0,fillx", "[100px][grow][100px]", ""));
            Boolean isMain = multiplier.isMain();
            this.tfAditionalPrice = new DoubleTextField(isMain != false ? 6 : 9, isMain != false ? 6 : 12);
            this.tfAditionalPrice.setHorizontalAlignment(4);
            JLabel lblName = new JLabel(multiplier.getTicketPrefix());
            if (isMain.booleanValue()) {
                lblName.setFont(new Font(null, 1, MenuModifierForm.this.tfName.getFont().getSize()));
            }
            this.add(lblName);
            this.add((Component)new JLabel(isMain != false ? Messages.getString("MenuModifierForm.35") : Messages.getString("MenuModifierForm.36"), 11), "grow, gapright 10px");
            this.add((Component)this.tfAditionalPrice, "split 2,grow");
            if (isMain.booleanValue()) {
                JButton btnCalculateMultilierPrice = new JButton(Messages.getString("MenuModifierForm.41"));
                btnCalculateMultilierPrice.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MenuModifierForm.this.doCalculateMultiplierPrice();
                    }
                });
                this.add(btnCalculateMultilierPrice);
            }
        }

        public void calculatePrice(double regPrice) {
            if (this.multiplier.isMain().booleanValue()) {
                return;
            }
            this.tfAditionalPrice.setText(NumberUtil.formatNumber(regPrice * this.multiplier.getRate() / 100.0));
        }

        public Double getPrice() {
            return NumberUtil.parseOrGetZero(this.tfAditionalPrice.getText()).doubleValue();
        }

        public Multiplier getMultiplier() {
            return this.multiplier;
        }

        public boolean isSelected() {
            Double value = this.tfAditionalPrice.getDouble();
            return !value.isNaN();
        }

        private void update() {
            if (this.multiplierPrice == null) {
                return;
            }
            this.tfAditionalPrice.setText(NumberUtil.formatNumber(this.multiplierPrice.getPrice()));
        }

        public void setModifierMultiplierPrice(ModifierMultiplierPrice price) {
            this.multiplierPrice = price;
            this.update();
        }

        public ModifierMultiplierPrice getMultiplierPrice() {
            return this.multiplierPrice;
        }
    }
}

