/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.InventoryPlugin;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class MultipleMenuItemEditForm
extends BeanEditor<MenuItem> {
    private List<MenuItem> menuItems;
    private JLabel lblMemberPrice = new JLabel();
    private DoubleTextField tfMemberPrice;
    private DoubleTextField tfCost;
    private JLabel lblKitchenPrinter = new JLabel(Messages.getString("MenuItemForm.27"));
    private OverflowCombobox cbPrinterGroup;
    private JLabel lblUnitName = new JLabel();
    private FixedLengthTextField tfUnitName;
    private JComboBox cbUnits = new JComboBox();
    private JCheckBox chkPrintToKitchen;
    private JCheckBox chkUnitName;
    private JCheckBox chkMemberPrice;
    private JCheckBox chkCost;
    private JCheckBox chkPrinterGroup;
    private JCheckBox chkPrintKitchen;

    public MultipleMenuItemEditForm(List<MenuItem> menuItems) throws Exception {
        this.menuItems = menuItems;
        this.initComponents();
        this.initData();
    }

    private Component getUnitField() {
        InventoryPlugin plugin = (InventoryPlugin)ExtensionManager.getPlugin(InventoryPlugin.class);
        if (plugin == null) {
            this.cbUnits.setVisible(false);
            return this.tfUnitName;
        }
        this.lblUnitName.setText(Messages.getString("MenuItemForm.63"));
        ArrayList<InventoryUnit> inventoryUnits = new ArrayList<InventoryUnit>();
        List<InventoryUnit> allInventoryUnitList = InventoryUnitDAO.getInstance().findAll();
        inventoryUnits.add(null);
        inventoryUnits.addAll(allInventoryUnitList);
        this.cbUnits.setModel(new ComboBoxModel(inventoryUnits));
        return this.cbUnits;
    }

    @Override
    public boolean save() {
        if (!this.updateModel()) {
            return false;
        }
        MenuItemDAO.getInstance().saveAll(this.menuItems);
        return true;
    }

    @Override
    protected boolean updateModel() {
        double doubleOrZeroCost = this.tfCost.getDoubleOrZero();
        PrinterGroup printerGroup = (PrinterGroup)this.cbPrinterGroup.getSelectedItem();
        boolean isPrintToKitchen = this.chkPrintToKitchen.isSelected();
        Double memberPrice = this.tfMemberPrice.getDoubleOrZero();
        if (this.menuItems != null) {
            for (MenuItem menuItem : this.menuItems) {
                if (this.chkCost.isSelected()) {
                    menuItem.setCost(doubleOrZeroCost);
                }
                if (this.chkMemberPrice.isSelected()) {
                    menuItem.setPrice(memberPrice);
                }
                if (this.chkUnitName.isSelected()) {
                    if (this.cbUnits.isVisible()) {
                        InventoryUnit unit = (InventoryUnit)this.cbUnits.getSelectedItem();
                        menuItem.setUnit(unit);
                    } else {
                        menuItem.setUnitName(this.tfUnitName.getText());
                    }
                }
                if (this.chkPrinterGroup.isSelected()) {
                    menuItem.setPrinterGroup(printerGroup);
                }
                if (!this.chkPrintKitchen.isSelected()) continue;
                menuItem.setShouldPrintToKitchen(isPrintToKitchen);
            }
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("MultipleMenuItemEditForm.2");
    }

    public void initComponents() {
        this.setLayout(new BorderLayout());
        int comboWidth = PosUIManager.getSize(117);
        this.tfUnitName = new FixedLengthTextField(10, 20);
        this.cbUnits.setEnabled(false);
        this.tfMemberPrice = new DoubleTextField(10);
        this.lblMemberPrice.setHorizontalAlignment(11);
        this.lblMemberPrice.setText(Messages.getString("MultipleMenuItemEditForm.0"));
        this.tfMemberPrice.setHorizontalAlignment(4);
        this.tfMemberPrice.setEnabled(false);
        this.tfCost = new DoubleTextField(10);
        this.tfCost.setHorizontalAlignment(4);
        this.tfCost.setEnabled(false);
        this.cbPrinterGroup = new OverflowCombobox();
        this.cbPrinterGroup.setEnabled(false);
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[]30[][]", ""));
        this.chkPrintToKitchen = new JCheckBox(Messages.getString("MenuItemForm.84"));
        this.chkPrintToKitchen.setEnabled(false);
        this.chkUnitName = new JCheckBox();
        this.chkMemberPrice = new JCheckBox();
        this.chkCost = new JCheckBox();
        this.chkPrinterGroup = new JCheckBox();
        this.chkPrintKitchen = new JCheckBox();
        JLabel lblEdit = new JLabel("Edit");
        mainPanel.add((Component)lblEdit, "wrap");
        mainPanel.add((Component)new JSeparator(), "growx,spanx 3,wrap");
        mainPanel.add(this.chkUnitName);
        mainPanel.add((Component)this.lblUnitName, "left");
        mainPanel.add(this.getUnitField(), "w " + comboWidth + "!,left, wrap");
        mainPanel.add(this.chkMemberPrice);
        mainPanel.add((Component)this.lblMemberPrice, "left");
        mainPanel.add((Component)this.tfMemberPrice, "left,wrap");
        mainPanel.add(this.chkCost);
        mainPanel.add((Component)new JLabel(Messages.getString("MultipleMenuItemEditForm.1")), "left");
        mainPanel.add((Component)this.tfCost, "left,wrap");
        mainPanel.add(this.chkPrinterGroup);
        mainPanel.add((Component)this.lblKitchenPrinter, "left");
        mainPanel.add((Component)this.cbPrinterGroup, "w " + comboWidth + "!,left, wrap");
        mainPanel.add(this.chkPrintKitchen);
        mainPanel.add((Component)this.chkPrintToKitchen, "skip 1");
        this.chkUnitName.addItemListener(e -> this.doEnableUnit());
        this.chkMemberPrice.addItemListener(e -> this.doEnableMemberPrice());
        this.chkCost.addItemListener(e -> this.doEnableCost());
        this.chkPrinterGroup.addItemListener(e -> this.doEnablePrienterGroup());
        this.chkPrintKitchen.addItemListener(e -> this.doEnablePrintToKitchen());
        this.add(mainPanel);
    }

    public void initData() {
        List<PrinterGroup> printerGroups = PrinterGroupDAO.getInstance().findAll();
        ComboBoxModel printerGroupModel = new ComboBoxModel();
        printerGroupModel.addElement((Object)null);
        for (PrinterGroup printerGroup : printerGroups) {
            printerGroupModel.addElement(printerGroup);
        }
        this.cbPrinterGroup.setModel(printerGroupModel);
        this.cbUnits.setSelectedIndex(0);
    }

    private void doEnablePrintToKitchen() {
        this.chkPrintToKitchen.setEnabled(this.chkPrintKitchen.isSelected());
        if (!this.chkPrintKitchen.isSelected()) {
            this.chkPrintToKitchen.setEnabled(false);
        }
    }

    private void doEnableCost() {
        this.tfCost.setEnabled(this.chkCost.isSelected());
        if (!this.chkCost.isSelected()) {
            this.tfCost.setEnabled(false);
        }
    }

    private void doEnablePrienterGroup() {
        this.cbPrinterGroup.setEnabled(this.chkPrinterGroup.isSelected());
        if (!this.chkPrinterGroup.isSelected()) {
            this.cbPrinterGroup.setEnabled(false);
        }
    }

    private void doEnableUnit() {
        this.cbUnits.setEnabled(this.chkUnitName.isSelected());
        if (!this.chkUnitName.isSelected()) {
            this.cbUnits.setEnabled(false);
        }
    }

    private void doEnableMemberPrice() {
        this.tfMemberPrice.setEnabled(this.chkMemberPrice.isSelected());
        if (!this.chkMemberPrice.isSelected()) {
            this.tfMemberPrice.setEnabled(false);
        }
    }

    @Override
    protected void updateView() {
    }
}

